/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.deeplinkdispatch;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import androidx.core.app.TaskStackBuilder;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.airbnb.deeplinkdispatch.DeepLinkEntry;
import com.airbnb.deeplinkdispatch.DeepLinkResult;
import com.airbnb.deeplinkdispatch.DeepLinkUri;
import com.airbnb.deeplinkdispatch.Parser;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public class BaseDeepLinkDelegate {
    protected static final String TAG = "DeepLinkDelegate";
    protected final List<? extends Parser> loaders;

    public BaseDeepLinkDelegate(List<? extends Parser> loaders) {
        this.loaders = loaders;
    }

    private DeepLinkEntry findEntry(String uriString) {
        for (Parser parser : this.loaders) {
            DeepLinkEntry entry = parser.parseUri(uriString);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    public DeepLinkResult dispatchFrom(Activity activity) {
        if (activity == null) {
            throw new NullPointerException("activity == null");
        }
        return this.dispatchFrom(activity, activity.getIntent());
    }

    /*
     * WARNING - void declaration
     */
    public DeepLinkResult dispatchFrom(Activity activity, Intent sourceIntent) {
        if (activity == null) {
            throw new NullPointerException("activity == null");
        }
        if (sourceIntent == null) {
            throw new NullPointerException("sourceIntent == null");
        }
        Uri uri = sourceIntent.getData();
        if (uri == null) {
            return BaseDeepLinkDelegate.createResultAndNotify((Context)activity, false, null, null, "No Uri in given activity's intent.");
        }
        String uriString = uri.toString();
        DeepLinkEntry entry = this.findEntry(uriString);
        if (entry != null) {
            DeepLinkUri deepLinkUri = DeepLinkUri.parse((String)uriString);
            Map parameterMap = entry.getParameters(uriString);
            for (Object queryParameter : deepLinkUri.queryParameterNames()) {
                for (String queryParameterValue : deepLinkUri.queryParameterValues((String)queryParameter)) {
                    if (parameterMap.containsKey(queryParameter)) {
                        Log.w((String)TAG, (String)("Duplicate parameter name in path and query param: " + (String)queryParameter));
                    }
                    parameterMap.put(queryParameter, queryParameterValue);
                }
            }
            parameterMap.put("deep_link_uri", uri.toString());
            Bundle parameters = sourceIntent.getExtras() != null ? new Bundle(sourceIntent.getExtras()) : new Bundle();
            for (Map.Entry entry2 : parameterMap.entrySet()) {
                parameters.putString((String)entry2.getKey(), (String)entry2.getValue());
            }
            try {
                void var10_22;
                Class c = entry.getActivityClass();
                TaskStackBuilder taskStackBuilder = null;
                if (entry.getType() == DeepLinkEntry.Type.CLASS) {
                    Intent intent = new Intent((Context)activity, c);
                } else {
                    try {
                        Method method = c.getMethod(entry.getMethod(), Context.class);
                        if (method.getReturnType().equals(TaskStackBuilder.class)) {
                            taskStackBuilder = (TaskStackBuilder)method.invoke((Object)c, activity);
                            if (taskStackBuilder.getIntentCount() == 0) {
                                return BaseDeepLinkDelegate.createResultAndNotify((Context)activity, false, uri, entry.getUriTemplate(), "Could not deep link to method: " + entry.getMethod() + " intents length == 0");
                            }
                            Intent intent = taskStackBuilder.editIntentAt(taskStackBuilder.getIntentCount() - 1);
                        } else {
                            Intent intent = (Intent)method.invoke((Object)c, activity);
                        }
                    }
                    catch (NoSuchMethodException exception) {
                        Method method = c.getMethod(entry.getMethod(), Context.class, Bundle.class);
                        if (method.getReturnType().equals(TaskStackBuilder.class)) {
                            taskStackBuilder = (TaskStackBuilder)method.invoke((Object)c, activity, parameters);
                            if (taskStackBuilder.getIntentCount() == 0) {
                                return BaseDeepLinkDelegate.createResultAndNotify((Context)activity, false, uri, entry.getUriTemplate(), "Could not deep link to method: " + entry.getMethod() + " intents length == 0");
                            }
                            Intent intent = taskStackBuilder.editIntentAt(taskStackBuilder.getIntentCount() - 1);
                        }
                        Intent intent = (Intent)method.invoke((Object)c, activity, parameters);
                    }
                }
                if (var10_22.getAction() == null) {
                    var10_22.setAction(sourceIntent.getAction());
                }
                if (var10_22.getData() == null) {
                    var10_22.setData(sourceIntent.getData());
                }
                var10_22.putExtras(parameters);
                var10_22.putExtra("is_deep_link_flag", true);
                var10_22.putExtra("android.intent.extra.REFERRER", (Parcelable)uri);
                if (activity.getCallingActivity() != null) {
                    var10_22.setFlags(0x2000000);
                }
                if (taskStackBuilder != null) {
                    taskStackBuilder.startActivities();
                } else {
                    activity.startActivity((Intent)var10_22);
                }
                return BaseDeepLinkDelegate.createResultAndNotify((Context)activity, true, uri, entry.getUriTemplate(), null);
            }
            catch (NoSuchMethodException exception) {
                return BaseDeepLinkDelegate.createResultAndNotify((Context)activity, false, uri, entry.getUriTemplate(), "Deep link to non-existent method: " + entry.getMethod());
            }
            catch (IllegalAccessException exception) {
                return BaseDeepLinkDelegate.createResultAndNotify((Context)activity, false, uri, entry.getUriTemplate(), "Could not deep link to method: " + entry.getMethod());
            }
            catch (InvocationTargetException exception) {
                return BaseDeepLinkDelegate.createResultAndNotify((Context)activity, false, uri, entry.getUriTemplate(), "Could not deep link to method: " + entry.getMethod());
            }
        }
        return BaseDeepLinkDelegate.createResultAndNotify((Context)activity, false, uri, null, "No registered entity to handle deep link: " + uri.toString());
    }

    private static DeepLinkResult createResultAndNotify(Context context, boolean successful, Uri uri, String uriTemplate, String error) {
        BaseDeepLinkDelegate.notifyListener(context, !successful, uri, uriTemplate, error);
        return new DeepLinkResult(successful, uri != null ? uri.toString() : null, error);
    }

    private static void notifyListener(Context context, boolean isError, Uri uri, String uriTemplate, String errorMessage) {
        Intent intent = new Intent();
        intent.setAction("com.airbnb.deeplinkdispatch.DEEPLINK_ACTION");
        intent.putExtra("com.airbnb.deeplinkdispatch.EXTRA_URI", uri != null ? uri.toString() : "");
        intent.putExtra("com.airbnb.deeplinkdispatch.EXTRA_URI_TEMPLATE", uriTemplate != null ? uriTemplate : "");
        intent.putExtra("com.airbnb.deeplinkdispatch.EXTRA_SUCCESSFUL", !isError);
        if (isError) {
            intent.putExtra("com.airbnb.deeplinkdispatch.EXTRA_ERROR_MESSAGE", errorMessage);
        }
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
    }

    public boolean supportsUri(String uriString) {
        return this.findEntry(uriString) != null;
    }
}

