/*
 * Decompiled with CFR 0.152.
 */
package com.aids61517.easyratingview;

import android.graphics.drawable.Drawable;
import com.aids61517.easyratingview.EasyRatingView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002J\b\u0010\u000f\u001a\u00020\u0006H\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/aids61517/easyratingview/StarBoundCalculator;", "", "ratingView", "Lcom/aids61517/easyratingview/EasyRatingView;", "(Lcom/aids61517/easyratingview/EasyRatingView;)V", "value", "", "gravity", "getGravity", "()I", "setGravity", "(I)V", "calculateXOfGravityCenter", "indexOfLine", "calculateXOfGravityEnd", "calculateXOfGravityStart", "calculateYOfGravityBottom", "calculateYOfGravityCenter", "calculateYOfGravityTop", "getBoundStart", "getBoundTop", "getCountOfStars", "easyratingview_release"})
public final class StarBoundCalculator {
    private int gravity;
    private final EasyRatingView ratingView;

    public final int getGravity() {
        return this.gravity;
    }

    public final void setGravity(int value) {
        int g = value;
        if ((g & 0x800007) == 0) {
            g |= 0x800003;
        }
        if ((g & 0x70) == 0) {
            g |= 0x30;
        }
        this.gravity = g;
    }

    public final int getBoundStart(int indexOfLine) {
        int n;
        if (this.ratingView.getEmptyDrawable() == null) {
            return 0;
        }
        switch (this.gravity & 0x800007) {
            case 1: 
            case 17: {
                n = this.calculateXOfGravityCenter(indexOfLine);
                break;
            }
            case 5: 
            case 0x800005: {
                n = this.calculateXOfGravityEnd(indexOfLine);
                break;
            }
            default: {
                n = this.calculateXOfGravityStart();
            }
        }
        return n;
    }

    public final int getBoundTop(int indexOfLine) {
        int n;
        if (this.ratingView.getEmptyDrawable() == null) {
            return 0;
        }
        switch (this.gravity & 0x70) {
            case 16: 
            case 17: {
                n = this.calculateYOfGravityCenter(indexOfLine);
                break;
            }
            case 80: {
                n = this.calculateYOfGravityBottom(indexOfLine);
                break;
            }
            default: {
                n = this.calculateYOfGravityTop(indexOfLine);
            }
        }
        return n;
    }

    private final int calculateYOfGravityCenter(int indexOfLine) {
        Drawable drawable = this.ratingView.getEmptyDrawable();
        Intrinsics.checkNotNull((Object)drawable);
        int drawableHeight = drawable.getIntrinsicHeight();
        int topY = this.ratingView.getPaddingTop();
        int bottomY = this.ratingView.getHeight() - this.ratingView.getPaddingBottom();
        int centerY = (topY + bottomY) / 2;
        int lines = this.ratingView.getNumberOfStars() / this.ratingView.getCountOfStarsPerRow() + 1;
        int contentHeight = lines * drawableHeight + (lines - 1) * this.ratingView.getVerticalSpacing();
        int firstLineY = centerY - contentHeight / 2;
        return firstLineY + indexOfLine * (drawableHeight + this.ratingView.getVerticalSpacing());
    }

    private final int calculateYOfGravityBottom(int indexOfLine) {
        int lines = this.ratingView.getNumberOfStars() / this.ratingView.getCountOfStarsPerRow() + 1;
        Drawable drawable = this.ratingView.getEmptyDrawable();
        Intrinsics.checkNotNull((Object)drawable);
        int drawableHeight = drawable.getIntrinsicHeight();
        return this.ratingView.getHeight() - this.ratingView.getPaddingBottom() - (lines - indexOfLine) * drawableHeight - (lines - indexOfLine - 1) * this.ratingView.getVerticalSpacing();
    }

    private final int calculateYOfGravityTop(int indexOfLine) {
        Drawable drawable = this.ratingView.getEmptyDrawable();
        Intrinsics.checkNotNull((Object)drawable);
        int drawableHeight = drawable.getIntrinsicHeight();
        return this.ratingView.getPaddingTop() + indexOfLine * (drawableHeight + this.ratingView.getVerticalSpacing());
    }

    private final int calculateXOfGravityCenter(int indexOfLine) {
        int count = this.getCountOfStars(indexOfLine);
        Drawable drawable = this.ratingView.getEmptyDrawable();
        Intrinsics.checkNotNull((Object)drawable);
        int drawableWidth = drawable.getIntrinsicWidth();
        int startX = this.ratingView.getPaddingStart();
        int endX = this.ratingView.getWidth() - this.ratingView.getPaddingEnd();
        int centerX = (startX + endX) / 2;
        int contentWidth = count * drawableWidth + (count - 1) * this.ratingView.getSpacing();
        return centerX - contentWidth / 2;
    }

    private final int calculateXOfGravityStart() {
        return this.ratingView.getPaddingStart();
    }

    private final int calculateXOfGravityEnd(int indexOfLine) {
        int count = this.getCountOfStars(indexOfLine);
        Drawable drawable = this.ratingView.getEmptyDrawable();
        Intrinsics.checkNotNull((Object)drawable);
        int drawableWidth = drawable.getIntrinsicWidth();
        return this.ratingView.getWidth() - this.ratingView.getPaddingEnd() - count * drawableWidth - (count - 1) * this.ratingView.getSpacing();
    }

    private final int getCountOfStars(int indexOfLine) {
        int numberOfStars;
        int countOfStarsPerRow = this.ratingView.getCountOfStarsPerRow();
        int startCountOfStar = indexOfLine * countOfStarsPerRow;
        int endCountOfStart = startCountOfStar + countOfStarsPerRow > (numberOfStars = this.ratingView.getNumberOfStars()) ? numberOfStars : startCountOfStar + countOfStarsPerRow;
        return endCountOfStart - startCountOfStar;
    }

    public StarBoundCalculator(@NotNull EasyRatingView ratingView) {
        Intrinsics.checkNotNullParameter((Object)((Object)ratingView), (String)"ratingView");
        this.ratingView = ratingView;
        this.gravity = 0x800003;
    }
}

