/*
 * Decompiled with CFR 0.152.
 */
package com.aids61517.easyratingview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import androidx.core.content.ContextCompat;
import com.aids61517.easyratingview.R;
import com.aids61517.easyratingview.StarBoundCalculator;
import java.util.HashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010A\u001a\u00020\t2\u0006\u0010B\u001a\u00020\tH\u0002J\u0010\u0010C\u001a\u00020\t2\u0006\u0010D\u001a\u00020\tH\u0002J \u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u00172\u0006\u0010J\u001a\u00020\tH\u0002J\u0010\u0010K\u001a\u00020L2\u0006\u0010I\u001a\u00020\u0017H\u0002J\u0010\u0010M\u001a\u00020,2\u0006\u0010;\u001a\u00020,H\u0002J\u0010\u0010N\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0014J\u0018\u0010O\u001a\u00020F2\u0006\u0010P\u001a\u00020\t2\u0006\u0010Q\u001a\u00020\tH\u0014J\u000e\u0010R\u001a\u00020F2\u0006\u0010S\u001a\u00020\tR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR$\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R(\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR$\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0014\"\u0004\b\u001f\u0010\u0016R\"\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u0011\u001a\u0004\u0018\u00010 @BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\"\u0010#R(\u0010$\u001a\u0004\u0018\u00010\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001a\"\u0004\b&\u0010\u001cR\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010)\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0014\"\u0004\b+\u0010\u0016R$\u0010-\u001a\u00020,2\u0006\u0010\u0011\u001a\u00020,@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R$\u00102\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0014\"\u0004\b4\u0010\u0016R$\u00105\u001a\u00020,2\u0006\u0010\u0011\u001a\u00020,@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010/\"\u0004\b7\u00101R$\u00108\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u0014\"\u0004\b:\u0010\u0016R$\u0010;\u001a\u00020,2\u0006\u0010\u0011\u001a\u00020,@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010/\"\u0004\b=\u00101R$\u0010>\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u0014\"\u0004\b@\u0010\u0016\u00a8\u0006T"}, d2={"Lcom/aids61517/easyratingview/EasyRatingView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "attributeSet", "defStyleAttribute", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "boundCalculator", "Lcom/aids61517/easyratingview/StarBoundCalculator;", "getBoundCalculator", "()Lcom/aids61517/easyratingview/StarBoundCalculator;", "boundCalculator$delegate", "Lkotlin/Lazy;", "value", "countOfStarsPerRow", "getCountOfStarsPerRow", "()I", "setCountOfStarsPerRow", "(I)V", "Landroid/graphics/drawable/Drawable;", "emptyDrawable", "getEmptyDrawable", "()Landroid/graphics/drawable/Drawable;", "setEmptyDrawable", "(Landroid/graphics/drawable/Drawable;)V", "emptyDrawableResourceId", "getEmptyDrawableResourceId", "setEmptyDrawableResourceId", "Landroid/graphics/BitmapShader;", "fullBitmapShader", "setFullBitmapShader", "(Landroid/graphics/BitmapShader;)V", "fullDrawable", "getFullDrawable", "setFullDrawable", "fullDrawablePaint", "Landroid/graphics/Paint;", "fullDrawableResourceId", "getFullDrawableResourceId", "setFullDrawableResourceId", "", "maxRating", "getMaxRating", "()F", "setMaxRating", "(F)V", "numberOfStars", "getNumberOfStars", "setNumberOfStars", "rating", "getRating", "setRating", "spacing", "getSpacing", "setSpacing", "step", "getStep", "setStep", "verticalSpacing", "getVerticalSpacing", "setVerticalSpacing", "calculateCountOfStarsPerRow", "width", "calculateViewHeight", "realWidth", "drawStar", "", "canvas", "Landroid/graphics/Canvas;", "drawable", "countOfStar", "drawableToBitmap", "Landroid/graphics/Bitmap;", "getRatingByStep", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setGravity", "gravity", "easyratingview_release"})
public final class EasyRatingView
extends View {
    private int emptyDrawableResourceId;
    @Nullable
    private Drawable emptyDrawable;
    private int fullDrawableResourceId;
    @Nullable
    private Drawable fullDrawable;
    private float rating;
    private int numberOfStars;
    private int spacing;
    private int verticalSpacing;
    private float step;
    private float maxRating;
    private BitmapShader fullBitmapShader;
    private Paint fullDrawablePaint;
    private int countOfStarsPerRow;
    private final Lazy boundCalculator$delegate;
    private HashMap _$_findViewCache;

    public final int getEmptyDrawableResourceId() {
        return this.emptyDrawableResourceId;
    }

    public final void setEmptyDrawableResourceId(int value) {
        if (this.emptyDrawableResourceId != value) {
            this.emptyDrawableResourceId = value;
            Drawable drawable = ContextCompat.getDrawable((Context)this.getContext(), (int)value);
            Intrinsics.checkNotNull((Object)drawable);
            this.setEmptyDrawable(drawable);
        }
    }

    @Nullable
    public final Drawable getEmptyDrawable() {
        return this.emptyDrawable;
    }

    public final void setEmptyDrawable(@Nullable Drawable value) {
        this.emptyDrawable = value;
        this.invalidate();
        this.requestLayout();
    }

    public final int getFullDrawableResourceId() {
        return this.fullDrawableResourceId;
    }

    public final void setFullDrawableResourceId(int value) {
        if (this.fullDrawableResourceId != value) {
            this.fullDrawableResourceId = value;
            Drawable drawable = ContextCompat.getDrawable((Context)this.getContext(), (int)value);
            Intrinsics.checkNotNull((Object)drawable);
            this.setFullDrawable(drawable);
        }
    }

    @Nullable
    public final Drawable getFullDrawable() {
        return this.fullDrawable;
    }

    public final void setFullDrawable(@Nullable Drawable value) {
        this.fullDrawable = value;
        Drawable drawable = value;
        if (drawable != null) {
            Drawable drawable2 = drawable;
            boolean bl = false;
            boolean bl2 = false;
            Drawable it = drawable2;
            boolean bl3 = false;
            Bitmap srcBitmap = this.drawableToBitmap(value);
            this.setFullBitmapShader(new BitmapShader(srcBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        }
        this.invalidate();
    }

    public final float getRating() {
        return this.rating;
    }

    public final void setRating(float value) {
        if (this.rating != value) {
            this.rating = value;
            this.invalidate();
        }
    }

    public final int getNumberOfStars() {
        return this.numberOfStars;
    }

    public final void setNumberOfStars(int value) {
        if (this.numberOfStars != value) {
            this.numberOfStars = value;
            this.invalidate();
            this.requestLayout();
        }
    }

    public final int getSpacing() {
        return this.spacing;
    }

    public final void setSpacing(int value) {
        if (this.spacing != value) {
            this.spacing = value;
            this.invalidate();
            this.requestLayout();
        }
    }

    public final int getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public final void setVerticalSpacing(int value) {
        if (this.verticalSpacing != value) {
            this.verticalSpacing = value;
            this.invalidate();
            this.requestLayout();
        }
    }

    public final float getStep() {
        return this.step;
    }

    public final void setStep(float value) {
        if (this.step != value) {
            this.step = value;
            this.invalidate();
        }
    }

    public final float getMaxRating() {
        return this.maxRating;
    }

    public final void setMaxRating(float value) {
        if (this.maxRating != value) {
            this.maxRating = value;
            this.invalidate();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setFullBitmapShader(BitmapShader value) {
        void $this$apply;
        this.fullBitmapShader = value;
        Paint paint = new Paint();
        boolean bl = false;
        boolean bl2 = false;
        Paint paint2 = paint;
        EasyRatingView easyRatingView = this;
        boolean bl3 = false;
        $this$apply.setAntiAlias(true);
        $this$apply.setShader((Shader)this.fullBitmapShader);
        Unit unit = Unit.INSTANCE;
        easyRatingView.fullDrawablePaint = paint;
    }

    public final int getCountOfStarsPerRow() {
        return this.countOfStarsPerRow;
    }

    private final void setCountOfStarsPerRow(int value) {
        this.countOfStarsPerRow = value <= 0 ? 1 : value;
    }

    private final StarBoundCalculator getBoundCalculator() {
        Lazy lazy = this.boundCalculator$delegate;
        EasyRatingView easyRatingView = this;
        Object var3_3 = null;
        boolean bl = false;
        return (StarBoundCalculator)lazy.getValue();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        block1: {
            int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            if (this.emptyDrawable == null || this.numberOfStars == 0) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            Drawable drawable = this.emptyDrawable;
            if (drawable == null) break block1;
            Drawable drawable2 = drawable;
            boolean bl = false;
            boolean bl2 = false;
            Drawable it = drawable2;
            boolean bl3 = false;
            int drawableWidth = it.getIntrinsicWidth();
            int expectWidth = this.numberOfStars * drawableWidth + (this.numberOfStars - 1) * this.spacing + this.getPaddingStart() + this.getPaddingEnd();
            int calculateWidth = View.resolveSizeAndState((int)expectWidth, (int)widthMeasureSpec, (int)0);
            int realWidth = calculateWidth > widthSize ? widthSize : calculateWidth;
            Log.d((String)"EasyRatingView", (String)("onMeasure realWidth = " + realWidth));
            this.setCountOfStarsPerRow(this.calculateCountOfStarsPerRow(realWidth));
            Log.d((String)"EasyRatingView", (String)("onMeasure countOfStarsPerRow = " + this.countOfStarsPerRow));
            int expectHeight = this.calculateViewHeight(realWidth);
            int realHeight = View.resolveSizeAndState((int)expectHeight, (int)heightMeasureSpec, (int)0);
            Log.d((String)"EasyRatingView", (String)("onMeasure expectHeight = " + expectHeight));
            Log.d((String)"EasyRatingView", (String)("onMeasure realHeight = " + realHeight));
            this.setMeasuredDimension(realWidth, realHeight);
        }
    }

    private final int calculateCountOfStarsPerRow(int width) {
        int remainingWidth = width - this.getPaddingStart() - this.getPaddingEnd();
        Drawable drawable = this.emptyDrawable;
        Intrinsics.checkNotNull((Object)drawable);
        int bitmapWidth = drawable.getIntrinsicWidth();
        float calculateN = (float)(remainingWidth + this.spacing) / (float)(bitmapWidth + this.spacing);
        boolean bl = false;
        return (int)Math.floor(calculateN);
    }

    private final int calculateViewHeight(int realWidth) {
        int n;
        boolean isMultiLine = this.numberOfStars > this.countOfStarsPerRow;
        Drawable drawable = this.emptyDrawable;
        Intrinsics.checkNotNull((Object)drawable);
        int drawableHeight = drawable.getIntrinsicHeight();
        if (isMultiLine) {
            int lines = this.numberOfStars / this.countOfStarsPerRow + 1;
            n = lines * drawableHeight + this.getPaddingTop() + this.getPaddingBottom() + (lines - 1) * this.verticalSpacing;
        } else {
            n = drawableHeight + this.getPaddingTop() + this.getPaddingBottom();
        }
        return n;
    }

    public final void setGravity(int gravity) {
        this.getBoundCalculator().setGravity(gravity);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        block2: {
            Drawable $this$apply;
            boolean bl;
            boolean bl2;
            Drawable drawable;
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            if (this.emptyDrawable == null || this.numberOfStars == 0) {
                return;
            }
            Drawable drawable2 = this.emptyDrawable;
            if (drawable2 != null) {
                drawable = drawable2;
                bl2 = false;
                bl = false;
                $this$apply = drawable;
                boolean bl3 = false;
                this.drawStar(canvas, $this$apply, this.numberOfStars);
            }
            Drawable drawable3 = this.fullDrawable;
            if (drawable3 == null) break block2;
            drawable = drawable3;
            bl2 = false;
            bl = false;
            $this$apply = drawable;
            boolean bl4 = false;
            float ratingByStep = this.getRatingByStep(this.step);
            int fullCountOfStar = (int)ratingByStep;
            this.drawStar(canvas, $this$apply, fullCountOfStar);
            int indexLineOfNextStar = (fullCountOfStar + 1) / this.countOfStarsPerRow;
            int lineDrawStarX = this.getBoundCalculator().getBoundStart(indexLineOfNextStar);
            int lineDrawStarY = this.getBoundCalculator().getBoundTop(indexLineOfNextStar);
            int indexOfStar = (int)(ratingByStep - (float)(indexLineOfNextStar * this.countOfStarsPerRow));
            int drawStartX = lineDrawStarX + indexOfStar * ($this$apply.getIntrinsicWidth() + this.spacing);
            canvas.save();
            canvas.translate((float)drawStartX, (float)lineDrawStarY);
            float targetWidth = (float)$this$apply.getIntrinsicWidth() * (ratingByStep % 1.0f);
            float f = $this$apply.getIntrinsicHeight();
            Paint paint = this.fullDrawablePaint;
            Intrinsics.checkNotNull((Object)paint);
            canvas.drawRect(0.0f, 0.0f, targetWidth, f, paint);
            canvas.restore();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawStar(Canvas canvas, Drawable drawable, int countOfStar) {
        int lines = countOfStar / this.countOfStarsPerRow + 1;
        Drawable drawable2 = drawable;
        boolean bl = false;
        boolean bl2 = false;
        Drawable $this$run = drawable2;
        boolean bl3 = false;
        int drawableWidth = $this$run.getIntrinsicWidth();
        int drawableHeight = $this$run.getIntrinsicHeight();
        int n = lines;
        boolean bl4 = false;
        int n2 = 0;
        int n3 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            int indexOfLine = n2;
            boolean bl5 = false;
            int drawStartX = this.getBoundCalculator().getBoundStart(indexOfLine);
            int drawStartY = this.getBoundCalculator().getBoundTop(indexOfLine);
            int startCountOfStar = indexOfLine * this.countOfStarsPerRow;
            int endCountOfStart = startCountOfStar + this.countOfStarsPerRow > countOfStar ? countOfStar : startCountOfStar + this.countOfStarsPerRow;
            int n4 = 0;
            int n5 = endCountOfStart - startCountOfStar;
            while (n4 < n5) {
                void i;
                void startX = i * (drawableWidth + this.spacing) + drawStartX;
                $this$run.setBounds((int)startX, drawStartY, (int)(startX + drawableWidth), drawStartY + drawableHeight);
                $this$run.draw(canvas);
                ++i;
            }
        }
    }

    private final float getRatingByStep(float step) {
        float maxRating = this.maxRating != 0.0f ? this.maxRating : (float)this.numberOfStars;
        float rating = this.rating > maxRating ? maxRating : this.rating / maxRating * (float)this.numberOfStars;
        float newRatingRatio = rating / step;
        int multiple = (double)(newRatingRatio % 1.0f) >= 0.5 ? (int)newRatingRatio + 1 : (int)newRatingRatio;
        return (float)multiple * step;
    }

    private final Bitmap drawableToBitmap(Drawable drawable) {
        if (drawable instanceof BitmapDrawable) {
            Bitmap bitmap = ((BitmapDrawable)drawable).getBitmap();
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"drawable.bitmap");
            return bitmap;
        }
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicWidth();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, width, height);
        drawable.draw(canvas);
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap");
        return bitmap2;
    }

    @JvmOverloads
    public EasyRatingView(@NotNull Context context, @Nullable AttributeSet attributeSet, int defStyleAttribute) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributeSet, defStyleAttribute);
        this.numberOfStars = 5;
        this.step = 0.5f;
        this.countOfStarsPerRow = 1;
        this.boundCalculator$delegate = LazyKt.lazy((Function0)((Function0)new Function0<StarBoundCalculator>(this){
            final /* synthetic */ EasyRatingView this$0;

            @NotNull
            public final StarBoundCalculator invoke() {
                return new StarBoundCalculator(this.this$0);
            }
            {
                this.this$0 = easyRatingView;
                super(0);
            }
        }));
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.EasyRatingView);
        this.setNumberOfStars(typedArray.getInt(R.styleable.EasyRatingView_numStars, 5));
        this.setSpacing(typedArray.getDimensionPixelSize(R.styleable.EasyRatingView_spacing, 0));
        this.setVerticalSpacing(typedArray.getDimensionPixelSize(R.styleable.EasyRatingView_verticalSpacing, 0));
        this.setRating(typedArray.getFloat(R.styleable.EasyRatingView_rating, 0.0f));
        this.setStep(typedArray.getFloat(R.styleable.EasyRatingView_step, 0.5f));
        this.setMaxRating(typedArray.getFloat(R.styleable.EasyRatingView_maxRating, 0.0f));
        this.setFullDrawableResourceId(typedArray.getResourceId(R.styleable.EasyRatingView_fullDrawable, 0));
        this.setEmptyDrawableResourceId(typedArray.getResourceId(R.styleable.EasyRatingView_emptyDrawable, 0));
        int gravity = typedArray.getInt(R.styleable.EasyRatingView_android_gravity, 0x800003);
        this.setGravity(gravity);
        typedArray.recycle();
    }

    public /* synthetic */ EasyRatingView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public EasyRatingView(@NotNull Context context, int defStyleAttribute) {
        this(context, null, defStyleAttribute, 2, null);
    }

    public EasyRatingView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    public /* synthetic */ EasyRatingView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

