/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.view;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.ahmadullahpk.alldocumentreader.xs.common.BackgroundDrawer;
import com.ahmadullahpk.alldocumentreader.xs.common.PaintKit;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.AutoShapeKit;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.PictureKit;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.GroupShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.IShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.PictureShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.WPAutoShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.WPChartShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.WPGroupShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.WPPictureShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.WatermarkShape;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.DocAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.PageAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ParaAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ViewKit;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.AbstractChart;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LeafView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.PositionLayoutKit;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.WPSTRoot;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.WPViewKit;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class ShapeView
extends LeafView {
    private static final int GAP = 100;
    private PageAttr pageAttr;
    private WPAutoShape wpShape;
    private Rect rect = new Rect();
    private boolean isInline;
    private Map<Integer, WPSTRoot> roots;

    public ShapeView() {
    }

    public ShapeView(IElement paraElem, IElement elem, AutoShape shape) {
        super(paraElem, elem);
        this.wpShape = (WPAutoShape)shape;
        this.roots = new Hashtable<Integer, WPSTRoot>();
    }

    @Override
    public short getType() {
        return 13;
    }

    @Override
    public int doLayout(DocAttr docAttr, PageAttr pageAttr, ParaAttr paraAttr, int x, int y, int w, int h, long maxEnd, int flag) {
        this.pageAttr = pageAttr;
        boolean bl = this.isInline = docAttr.rootType == 1 || this.wpShape.getWrap() != 3 && this.wpShape.getWrap() != 6;
        if (this.wpShape.isWatermarkShape()) {
            this.isInline = false;
        } else if (WPViewKit.instance().getArea(this.start + 1L) == 0x1000000000000000L || WPViewKit.instance().getArea(this.start + 1L) == 0x2000000000000000L) {
            this.isInline = true;
        }
        int width = 0;
        Rectangle r = this.wpShape.getBounds();
        if (this.isInline) {
            width = r.width;
            this.setSize(width, r.height);
        } else if (this.wpShape.isWatermarkShape()) {
            WatermarkShape watermark = (WatermarkShape)this.wpShape;
            this.paint = new Paint();
            this.paint.setAntiAlias(true);
            String str = watermark.getWatermartString();
            if (str != null && str.length() > 0) {
                int len = str.length();
                int span = pageAttr.pageWidth - pageAttr.leftMargin - pageAttr.rightMargin;
                if (watermark.isAutoFontSize()) {
                    int fontSize = span / len;
                    this.paint.setTextSize((float)fontSize);
                    this.paint.getTextBounds(str, 0, len, this.rect);
                    int preFontSize = fontSize;
                    if (this.rect.width() < span) {
                        while (this.rect.width() < span) {
                            preFontSize = fontSize++;
                            this.paint.setTextSize((float)fontSize);
                            this.paint.getTextBounds(str, 0, len, this.rect);
                        }
                    } else if (this.rect.width() > span) {
                        while (this.rect.width() > span) {
                            preFontSize = fontSize--;
                            this.paint.setTextSize((float)fontSize);
                            this.paint.getTextBounds(str, 0, len, this.rect);
                        }
                    }
                    watermark.setFontSize(preFontSize);
                    this.paint.setTextSize((float)preFontSize);
                } else {
                    this.paint.setTextSize((float)watermark.getFontSize());
                }
                this.paint.setColor(watermark.getFontColor());
                int alpha = Math.round(255.0f * watermark.getOpacity());
                this.paint.setAlpha(alpha);
                this.paint.getTextBounds(str, 0, len, this.rect);
                this.setX((pageAttr.pageWidth - this.rect.width()) / 2);
                this.setY((pageAttr.pageHeight - this.rect.height()) / 2);
            }
        } else {
            PositionLayoutKit.instance().processShapePosition(this, this.wpShape, pageAttr);
        }
        this.setEndOffset(this.start + 1L);
        boolean keepOne = ViewKit.instance().getBitValue(flag, 0);
        int breakType = 0;
        if (!keepOne && width > w) {
            breakType = 1;
        } else {
            this.layoutTextbox(this.wpShape, this.wpShape.getGroupShape());
        }
        return breakType;
    }

    private void layoutTextbox(WPAutoShape wpShape, WPGroupShape wpGroup) {
        if (wpGroup != null) {
            IShape[] shapes = wpGroup.getShapes();
            if (shapes != null) {
                for (IShape shape : shapes) {
                    if (shape.getType() == 7) {
                        this.layoutTextbox(null, (WPGroupShape)shape);
                        continue;
                    }
                    if (!(shape instanceof WPAutoShape)) continue;
                    this.layoutTextbox((WPAutoShape)shape, ((WPAutoShape)shape).getGroupShape());
                }
            }
        } else if (wpShape.getElementIndex() >= 0) {
            WPSTRoot stRoot = new WPSTRoot(this.getContainer(), this.getDocument(), wpShape.getElementIndex());
            stRoot.setWrapLine(wpShape.isTextWrapLine());
            stRoot.doLayout();
            stRoot.setParentView(this);
            this.roots.put(wpShape.getElementIndex(), stRoot);
            if (!wpShape.isTextWrapLine()) {
                wpShape.getBounds().width = stRoot.getAdjustTextboxWidth();
            }
        }
    }

    @Override
    public float getTextWidth() {
        return this.isInline ? (float)this.wpShape.getBounds().width : 0.0f;
    }

    @Override
    public synchronized void draw(Canvas canvas, int originX, int originY, float zoom) {
        if (this.isInline) {
            WPSTRoot root;
            int dX = (int)((float)this.x * zoom) + originX;
            int dY = (int)((float)this.y * zoom) + originY;
            Rectangle r = this.wpShape.getBounds();
            this.rect.set(dX, dY, (int)((float)dX + (float)r.width * zoom), (int)((float)dY + (float)r.height * zoom));
            if (this.wpShape.getGroupShape() != null) {
                this.drawGroupShape(canvas, this.wpShape.getGroupShape(), this.rect, zoom);
            } else if (this.wpShape.getType() == 2) {
                AutoShapeKit.instance().drawAutoShape(canvas, this.getControl(), this.getPageNumber(), this.wpShape, this.rect, zoom);
            } else if (this.wpShape.getType() == 5) {
                AbstractChart chart = ((WPChartShape)this.wpShape).getAChart();
                chart.setZoomRate(zoom);
                chart.draw(canvas, this.getControl(), this.rect.left, this.rect.top, this.rect.width(), this.rect.height(), PaintKit.instance().getPaint());
            }
            if (this.roots.size() > 0 && this.wpShape.getElementIndex() >= 0 && (root = this.roots.get(this.wpShape.getElementIndex())) != null) {
                canvas.save();
                canvas.rotate(this.wpShape.getRotation(), this.rect.exactCenterX(), this.rect.exactCenterY());
                root.draw(canvas, dX, dY, zoom);
                canvas.restore();
            }
        }
    }

    public synchronized void drawForWrap(Canvas canvas, int originX, int originY, float zoom) {
        try {
            WPSTRoot root;
            int dX = (int)((float)this.x * zoom) + originX;
            int dY = (int)((float)this.y * zoom) + originY;
            Rectangle r = this.wpShape.getBounds();
            if (this.wpShape.isWatermarkShape()) {
                String str = ((WatermarkShape)this.wpShape).getWatermartString();
                if (str != null && str.length() > 0) {
                    canvas.save();
                    float oldSize = this.paint.getTextSize();
                    this.paint.setTextSize((float)((WatermarkShape)this.wpShape).getFontSize() * zoom);
                    float angle = this.wpShape.getRotation();
                    int mainBodyWidth = this.pageAttr.pageWidth - this.pageAttr.leftMargin - this.pageAttr.rightMargin;
                    int mainBodyHeight = this.pageAttr.pageHeight - this.pageAttr.topMargin - this.pageAttr.bottomMargin;
                    float centerX = (float)originX + ((float)this.pageAttr.leftMargin + (float)mainBodyWidth / 2.0f) * zoom;
                    float centerY = (float)originY + ((float)this.pageAttr.topMargin + (float)mainBodyHeight / 2.0f) * zoom;
                    canvas.translate(centerX, centerY);
                    canvas.rotate(angle, 0.0f, 0.0f);
                    canvas.drawText(str, (float)(-this.rect.width()) * zoom / 2.0f, 0.0f, this.paint);
                    this.paint.setTextSize(oldSize);
                    canvas.restore();
                    return;
                }
            } else {
                this.rect.set(dX, dY, (int)((float)dX + (float)r.width * zoom), (int)((float)dY + (float)r.height * zoom));
                if (this.wpShape.getGroupShape() != null) {
                    AutoShapeKit.instance().drawAutoShape(canvas, this.getControl(), this.getPageNumber(), this.wpShape, this.rect, zoom);
                    this.drawGroupShape(canvas, this.wpShape.getGroupShape(), this.rect, zoom);
                } else if (this.wpShape.getType() == 2) {
                    AutoShapeKit.instance().drawAutoShape(canvas, this.getControl(), this.getPageNumber(), this.wpShape, this.rect, zoom);
                } else if (this.wpShape.getType() == 5) {
                    AbstractChart chart = ((WPChartShape)this.wpShape).getAChart();
                    chart.setZoomRate(zoom);
                    chart.draw(canvas, this.getControl(), this.rect.left, this.rect.top, this.rect.width(), this.rect.height(), PaintKit.instance().getPaint());
                }
            }
            if (this.roots.size() > 0 && this.wpShape.getElementIndex() >= 0 && (root = this.roots.get(this.wpShape.getElementIndex())) != null) {
                canvas.save();
                canvas.rotate(this.wpShape.getRotation(), this.rect.exactCenterX(), this.rect.exactCenterY());
                root.draw(canvas, dX, dY, zoom);
                canvas.restore();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawGroupShape(Canvas canvas, GroupShape gs, Rect rect, float zoom) {
        IShape[] shapes;
        if (gs != null && (shapes = gs.getShapes()) != null) {
            Rect gsRect = new Rect();
            for (IShape shape : shapes) {
                WPSTRoot root;
                Rectangle r;
                if (shape.getType() == 7) {
                    this.drawGroupShape(canvas, (GroupShape)shape, rect, zoom);
                    continue;
                }
                if (shape.getType() == 0) {
                    gsRect.setEmpty();
                    r = shape.getBounds();
                    gsRect.left = rect.left + (int)((float)r.x * zoom);
                    gsRect.top = rect.top + (int)((float)r.y * zoom);
                    gsRect.right = (int)((float)gsRect.left + (float)r.width * zoom);
                    gsRect.bottom = (int)((float)gsRect.top + (float)r.height * zoom);
                    if (shape instanceof WPPictureShape) {
                        shape = ((WPPictureShape)shape).getPictureShape();
                    }
                    if (shape == null) continue;
                    BackgroundDrawer.drawLineAndFill(canvas, this.getControl(), this.getPageNumber(), (PictureShape)shape, rect, zoom);
                    PictureKit.instance().drawPicture(canvas, this.getControl(), this.getPageNumber(), ((PictureShape)shape).getPicture(this.getControl()), gsRect.left, gsRect.top, zoom, (float)shape.getBounds().width * zoom, (float)shape.getBounds().height * zoom, ((PictureShape)shape).getPictureEffectInfor());
                    continue;
                }
                if (shape.getType() != 2) continue;
                gsRect.setEmpty();
                r = shape.getBounds();
                gsRect.left = rect.left + (int)((float)r.x * zoom);
                gsRect.top = rect.top + (int)((float)r.y * zoom);
                gsRect.right = (int)((float)gsRect.left + (float)r.width * zoom);
                gsRect.bottom = (int)((float)gsRect.top + (float)r.height * zoom);
                AutoShapeKit.instance().drawAutoShape(canvas, this.getControl(), this.getPageNumber(), (AutoShape)shape, gsRect, zoom);
                WPAutoShape txShape = (WPAutoShape)shape;
                if (txShape.getElementIndex() < 0 || (root = this.roots.get(txShape.getElementIndex())) == null) continue;
                root.draw(canvas, gsRect.left, gsRect.top, zoom);
            }
        }
    }

    @Override
    public Rectangle modelToView(long offset, Rectangle rect, boolean isBack) {
        rect.x += this.getX();
        rect.y += this.getY();
        return rect;
    }

    @Override
    public long viewToModel(int x, int y, boolean isBack) {
        return this.start;
    }

    @Override
    public int getBaseline() {
        return this.isInline ? (int)this.wpShape.getBounds().getHeight() : 0;
    }

    public boolean isBehindDoc() {
        if (this.wpShape.getGroupShape() != null) {
            return this.wpShape.getGroupShape().getWrapType() == 6;
        }
        return this.wpShape.getWrap() == 6;
    }

    public boolean isInline() {
        return this.isInline;
    }

    @Override
    public void free() {
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.roots != null) {
            Set<Integer> keySet = this.roots.keySet();
            for (Integer key : keySet) {
                WPSTRoot root = this.roots.get(key);
                if (root == null) continue;
                root.dispose();
            }
            this.roots.clear();
            this.roots = null;
        }
        this.wpShape = null;
    }
}

