/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.mozilla.intl.chardet;

import com.ahmadullahpk.alldocumentreader.xs.thirdpart.mozilla.intl.chardet.nsDetector;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.mozilla.intl.chardet.nsICharsetDetectionObserver;
import java.io.BufferedInputStream;
import java.io.FileInputStream;

public class CharsetDetector {
    public static boolean found = false;
    public static String charsetStr;

    private CharsetDetector() {
    }

    public static String detect(BufferedInputStream imp) throws Exception {
        int len;
        found = false;
        charsetStr = "ASCII";
        nsDetector det = new nsDetector(0);
        det.Init(new nsICharsetDetectionObserver(){

            @Override
            public void Notify(String charset) {
                found = true;
                charsetStr = charset;
            }
        });
        byte[] buf = new byte[1024];
        boolean done = false;
        boolean isAscii = true;
        for (int count = 0; (len = imp.read(buf, 0, buf.length)) != -1 && count <= 50; ++count) {
            if (count == 0) {
                if (buf[0] == -1 && buf[1] == -2 || buf[1] == -2 && buf[0] == -1) {
                    charsetStr = "Unicode";
                    return charsetStr;
                }
                if (buf[0] == -17 && buf[1] == -69 && buf[2] == -65) {
                    charsetStr = "UTF-8";
                    return charsetStr;
                }
            }
            if (isAscii) {
                isAscii = det.isAscii(buf, len);
            }
            if (isAscii || done) continue;
            done = det.DoIt(buf, len, false);
        }
        det.DataEnd();
        if (isAscii) {
            return "ASCII";
        }
        if (!found) {
            return null;
        }
        return charsetStr;
    }

    public static String detect(String fileName) throws Exception {
        FileInputStream file = new FileInputStream(fileName);
        BufferedInputStream imp = new BufferedInputStream(file);
        String charset = CharsetDetector.detect(imp);
        imp.close();
        return charset;
    }
}

