/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.font;

import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.font.TTFTable;
import java.io.IOException;

public class TTFNameTable
extends TTFTable {
    private int format;
    private int numberOfNameRecords;
    private int stringStorage;
    private String[][] name = new String[4][19];

    @Override
    public String getTag() {
        return "name";
    }

    @Override
    public void readTable() throws IOException {
        this.format = this.ttf.readUShort();
        this.numberOfNameRecords = this.ttf.readUShort();
        this.stringStorage = this.ttf.readUShort();
        for (int i = 0; i < this.numberOfNameRecords; ++i) {
            int pid = this.ttf.readUShort();
            int eid = this.ttf.readUShort();
            int lid = this.ttf.readUShort();
            int nid = this.ttf.readUShort();
            int stringLen = this.ttf.readUShort();
            int stringOffset = this.ttf.readUShort();
            this.ttf.pushPos();
            this.ttf.seek(this.stringStorage + stringOffset);
            byte[] b = new byte[stringLen];
            this.ttf.readFully(b);
            if (pid == 0) {
                this.name[pid][nid] = new String(b, "UnicodeBig");
            } else if (pid == 1 && eid == 0) {
                if (lid == 0) {
                    this.name[pid][nid] = new String(b, "ISO8859-1");
                }
            } else if (pid == 3 && eid == 1) {
                if (lid == 1033) {
                    this.name[pid][nid] = new String(b, "UnicodeBig");
                }
            } else {
                System.out.println("Unimplemented PID, EID, LID scheme: " + pid + ", " + eid + ", " + lid);
                System.out.println("NID = " + nid);
                this.name[pid][nid] = new String(b, "Default");
            }
            this.ttf.popPos();
        }
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(super.toString() + "\n");
        s.append("  format: " + this.format);
        for (int i = 0; i < this.name.length; ++i) {
            for (int j = 0; j < this.name[i].length; ++j) {
                if (this.name[i][j] == null) continue;
                s.append("\n  name[" + i + "][" + j + "]: " + this.name[i][j]);
            }
        }
        return s.toString();
    }
}

