/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data;

import android.graphics.Bitmap;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Color;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFConstants;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFImageLoader;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFInputStream;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFTag;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data.BitmapInfo;
import java.io.IOException;

public class StretchDIBits
extends EMFTag
implements EMFConstants {
    public static final int size = 80;
    private Rectangle bounds;
    private int x;
    private int y;
    private int width;
    private int height;
    private int xSrc;
    private int ySrc;
    private int widthSrc;
    private int heightSrc;
    private int usage;
    private int dwROP;
    private Color bkg;
    private BitmapInfo bmi;
    private Bitmap image;

    public StretchDIBits() {
        super(81, 1);
    }

    public StretchDIBits(Rectangle bounds, int x, int y, int width, int height, Bitmap image, Color bkg) {
        this();
        this.bounds = bounds;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.xSrc = 0;
        this.ySrc = 0;
        this.widthSrc = image.getWidth();
        this.heightSrc = image.getHeight();
        this.usage = 0;
        this.dwROP = 0xCC0020;
        this.bkg = bkg;
        this.image = image;
        this.bmi = null;
    }

    @Override
    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        StretchDIBits tag = new StretchDIBits();
        tag.bounds = emf.readRECTL();
        tag.x = emf.readLONG();
        tag.y = emf.readLONG();
        tag.xSrc = emf.readLONG();
        tag.ySrc = emf.readLONG();
        tag.width = emf.readLONG();
        tag.height = emf.readLONG();
        emf.readDWORD();
        emf.readDWORD();
        emf.readDWORD();
        emf.readDWORD();
        tag.usage = emf.readDWORD();
        tag.dwROP = emf.readDWORD();
        tag.widthSrc = emf.readLONG();
        tag.heightSrc = emf.readLONG();
        tag.bmi = new BitmapInfo(emf);
        tag.image = EMFImageLoader.readImage(tag.bmi.getHeader(), tag.width, tag.height, emf, len - 72 - 40, null);
        return tag;
    }

    @Override
    public String toString() {
        return super.toString() + "\n  bounds: " + this.bounds + "\n  x, y, w, h: " + this.x + " " + this.y + " " + this.width + " " + this.height + "\n  xSrc, ySrc, widthSrc, heightSrc: " + this.xSrc + " " + this.ySrc + " " + this.widthSrc + " " + this.heightSrc + "\n  usage: " + this.usage + "\n  dwROP: " + this.dwROP + "\n  bkg: " + this.bkg + "\n" + this.bmi.toString();
    }

    @Override
    public void render(EMFRenderer renderer) {
        if (this.image != null) {
            renderer.drawImage(this.image, this.x, this.y, this.widthSrc, this.heightSrc);
        }
    }
}

