/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data;

import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.AffineTransform;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFConstants;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFInputStream;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFTag;
import java.io.IOException;

public class SetMapMode
extends EMFTag
implements EMFConstants {
    private int mode;

    public SetMapMode() {
        super(17, 1);
    }

    public SetMapMode(int mode) {
        this();
        this.mode = mode;
    }

    @Override
    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        return new SetMapMode(emf.readDWORD());
    }

    @Override
    public String toString() {
        return super.toString() + "\n  mode: " + this.mode;
    }

    @Override
    public void render(EMFRenderer renderer) {
        if (this.mode == 8) {
            renderer.setMapModeIsotropic(false);
        } else if (this.mode == 5) {
            double scale = 0.0254;
            renderer.setMapModeTransform(AffineTransform.getScaleInstance(scale, scale));
        } else if (this.mode == 3) {
            double scale = 0.01;
            renderer.setMapModeTransform(AffineTransform.getScaleInstance(scale, scale));
        } else if (this.mode == 7) {
            renderer.setMapModeIsotropic(true);
            renderer.fixViewportSize();
        } else if (this.mode == 4) {
            double scale = 0.254;
            renderer.setMapModeTransform(AffineTransform.getScaleInstance(scale, scale));
        } else if (this.mode == 2) {
            double scale = 0.1;
            renderer.setMapModeTransform(AffineTransform.getScaleInstance(scale, scale));
        } else if (this.mode == 1) {
            renderer.setMapModeTransform(AffineTransform.getScaleInstance(1.0, -1.0));
        } else if (this.mode == 6) {
            renderer.setMapModeTransform(AffineTransform.getScaleInstance(EMFRenderer.TWIP_SCALE, EMFRenderer.TWIP_SCALE));
        }
    }
}

