/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class XYSeries
implements Serializable {
    private String mTitle;
    private List<Double> mX = new ArrayList<Double>();
    private List<Double> mY = new ArrayList<Double>();
    private double mMinX = Double.MAX_VALUE;
    private double mMaxX = -1.7976931348623157E308;
    private double mMinY = Double.MAX_VALUE;
    private double mMaxY = -1.7976931348623157E308;
    private int mScaleNumber;

    public XYSeries(String title) {
        this(title, 0);
    }

    public XYSeries(String title, int scaleNumber) {
        this.mTitle = title;
        this.mScaleNumber = scaleNumber;
        this.initRange();
    }

    public int getScaleNumber() {
        return this.mScaleNumber;
    }

    private void initRange() {
        this.mMinX = Double.MAX_VALUE;
        this.mMaxX = -1.7976931348623157E308;
        this.mMinY = Double.MAX_VALUE;
        this.mMaxY = -1.7976931348623157E308;
        int length = this.getItemCount();
        for (int k = 0; k < length; ++k) {
            double x = this.getX(k);
            double y = this.getY(k);
            this.updateRange(x, y);
        }
    }

    private void updateRange(double x, double y) {
        this.mMinX = Math.min(this.mMinX, x);
        this.mMaxX = Math.max(this.mMaxX, x);
        this.mMinY = Math.min(this.mMinY, y);
        this.mMaxY = Math.max(this.mMaxY, y);
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public synchronized void add(double x, double y) {
        this.mX.add(x);
        this.mY.add(y);
        this.updateRange(x, y);
    }

    public synchronized void remove(int index) {
        double removedX = this.mX.remove(index);
        double removedY = this.mY.remove(index);
        if (removedX == this.mMinX || removedX == this.mMaxX || removedY == this.mMinY || removedY == this.mMaxY) {
            this.initRange();
        }
    }

    public synchronized void clear() {
        this.mX.clear();
        this.mY.clear();
        this.initRange();
    }

    public synchronized double getX(int index) {
        return this.mX.get(index);
    }

    public synchronized double getY(int index) {
        return this.mY.get(index);
    }

    public synchronized int getItemCount() {
        return this.mX.size();
    }

    public double getMinX() {
        return this.mMinX;
    }

    public double getMinY() {
        return this.mMinY;
    }

    public double getMaxX() {
        return this.mMaxX;
    }

    public double getMaxY() {
        return this.mMaxY;
    }
}

