/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.view;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.ahmadullahpk.alldocumentreader.xs.common.PaintKit;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.other.SheetScroller;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.HeaderUtil;
import com.ahmadullahpk.alldocumentreader.xs.ss.view.SheetView;

public class ColumnHeader {
    private SheetView sheetview;
    private int columnHeaderHeight = 30;
    private float x;
    private Rect rect;

    public ColumnHeader(SheetView sheetView) {
        this.sheetview = sheetView;
        this.rect = new Rect();
    }

    public int getColumnRightBound(Canvas canvas, float zoom) {
        canvas.save();
        Rect clip = canvas.getClipBounds();
        Paint paint = PaintKit.instance().getPaint();
        paint.setTextSize(16.0f * zoom);
        this.x = this.sheetview.getRowHeaderWidth();
        this.layoutColumnLine(canvas, 0, zoom, paint);
        canvas.restore();
        return Math.min((int)this.x, clip.right);
    }

    private void layoutColumnLine(Canvas canvas, int columnStart, float zoom, Paint paint) {
        int maxSheetColumns;
        int colIndex;
        float w = 0.0f;
        Rect clip = canvas.getClipBounds();
        Sheet sheet = this.sheetview.getCurrentSheet();
        SheetScroller minRowAndColumnInformation = this.sheetview.getMinRowAndColumnInformation();
        int n = colIndex = minRowAndColumnInformation.getMinColumnIndex() > columnStart ? minRowAndColumnInformation.getMinColumnIndex() : columnStart;
        if (!minRowAndColumnInformation.isColumnAllVisible()) {
            ++colIndex;
            this.x = (float)((double)this.x + minRowAndColumnInformation.getVisibleColumnWidth() * (double)zoom);
        }
        int n2 = maxSheetColumns = sheet.getWorkbook().isBefore07Version() ? 256 : 16384;
        while (this.x <= (float)clip.right && colIndex < maxSheetColumns) {
            if (sheet.isColumnHidden(colIndex)) {
                ++colIndex;
                continue;
            }
            w = sheet.getColumnPixelWidth(colIndex) * zoom;
            this.x += w;
            ++colIndex;
        }
    }

    public void draw(Canvas canvas, int bottomBound, float zoom) {
        canvas.save();
        Paint paint = PaintKit.instance().getPaint();
        int oldColor = paint.getColor();
        float oldTextSize = paint.getTextSize();
        paint.setTextSize(16.0f * zoom);
        this.x = this.sheetview.getRowHeaderWidth();
        Rect clip = canvas.getClipBounds();
        this.drawColumnLine(canvas, bottomBound, 0, zoom, paint);
        paint.setColor(-9671571);
        canvas.drawRect(0.0f, (float)this.columnHeaderHeight, this.x, (float)(this.columnHeaderHeight + 1), paint);
        paint.setColor(oldColor);
        paint.setTextSize(oldTextSize);
        canvas.restore();
    }

    private void drawFirstVisibleColumn(Canvas canvas, float zoom, Paint paint) {
        Paint.FontMetrics fm = paint.getFontMetrics();
        float visibleColumnWidth = 0.0f;
        SheetScroller minRowAndColumnInformation = this.sheetview.getMinRowAndColumnInformation();
        float columnWidht = minRowAndColumnInformation.getColumnWidth() * zoom;
        visibleColumnWidth = (float)(minRowAndColumnInformation.getVisibleColumnWidth() * (double)zoom);
        if (HeaderUtil.instance().isActiveColumn(this.sheetview.getCurrentSheet(), minRowAndColumnInformation.getMinColumnIndex())) {
            paint.setColor(-3932316);
        } else {
            paint.setColor(-2894893);
        }
        this.rect.set((int)this.x, 0, (int)(this.x + visibleColumnWidth), this.columnHeaderHeight);
        canvas.drawRect(this.rect, paint);
        paint.setColor(-9671571);
        canvas.drawRect(this.x, 0.0f, this.x + 1.0f, (float)this.columnHeaderHeight, paint);
        canvas.save();
        canvas.clipRect(this.rect);
        paint.setColor(-16777216);
        String rowText = HeaderUtil.instance().getColumnHeaderTextByIndex(minRowAndColumnInformation.getMinColumnIndex());
        float textWidth = paint.measureText(rowText);
        float textX = (columnWidht - textWidth) / 2.0f;
        float textY = (int)((double)this.columnHeaderHeight - Math.ceil(fm.descent - fm.ascent)) / 2;
        canvas.drawText(rowText, this.x + textX - (columnWidht - visibleColumnWidth), textY - fm.ascent, paint);
        canvas.restore();
    }

    private void drawColumnLine(Canvas canvas, int bottomBound, int columnStart, float zoom, Paint paint) {
        int maxSheetColumns;
        int colIndex;
        Paint.FontMetrics fm = paint.getFontMetrics();
        float w = 0.0f;
        Rect clip = canvas.getClipBounds();
        Sheet sheet = this.sheetview.getCurrentSheet();
        SheetScroller minRowAndColumnInformation = this.sheetview.getMinRowAndColumnInformation();
        int n = colIndex = minRowAndColumnInformation.getMinColumnIndex() > columnStart ? minRowAndColumnInformation.getMinColumnIndex() : columnStart;
        if (!minRowAndColumnInformation.isColumnAllVisible()) {
            this.drawFirstVisibleColumn(canvas, zoom, paint);
            ++colIndex;
            this.x = (float)((double)this.x + minRowAndColumnInformation.getVisibleColumnWidth() * (double)zoom);
        }
        int n2 = maxSheetColumns = sheet.getWorkbook().isBefore07Version() ? 256 : 16384;
        while (this.x <= (float)clip.right && colIndex < maxSheetColumns) {
            if (sheet.isColumnHidden(colIndex)) {
                paint.setColor(-9671571);
                canvas.drawRect(this.x - 1.0f, 0.0f, this.x + 1.0f, (float)this.columnHeaderHeight, paint);
                ++colIndex;
                continue;
            }
            w = sheet.getColumnPixelWidth(colIndex) * zoom;
            if (HeaderUtil.instance().isActiveColumn(this.sheetview.getCurrentSheet(), colIndex)) {
                paint.setColor(-3932316);
            } else {
                paint.setColor(-2894893);
            }
            this.rect.set((int)this.x, 0, (int)(this.x + w), this.columnHeaderHeight);
            canvas.drawRect(this.rect, paint);
            if (colIndex != minRowAndColumnInformation.getMinColumnIndex()) {
                paint.setColor(-3681831);
                canvas.drawRect(this.x, 0.0f, this.x + 1.0f, (float)bottomBound, paint);
            }
            paint.setColor(-9671571);
            canvas.drawRect(this.x, 0.0f, this.x + 1.0f, (float)this.columnHeaderHeight, paint);
            canvas.save();
            canvas.clipRect(this.rect);
            paint.setColor(-16777216);
            String colText = HeaderUtil.instance().getColumnHeaderTextByIndex(colIndex);
            int textWidth = (int)paint.measureText(colText);
            float textX = (w - (float)textWidth) / 2.0f;
            float textY = (int)((double)this.columnHeaderHeight - Math.ceil(fm.descent - fm.ascent)) / 2;
            canvas.drawText(colText, this.x + textX, textY - fm.ascent, paint);
            canvas.restore();
            this.x += w;
            ++colIndex;
        }
        paint.setColor(-3681831);
        canvas.drawRect(this.x, 0.0f, this.x + 1.0f, (float)bottomBound, paint);
        paint.setColor(-9671571);
        canvas.drawRect(this.x, 0.0f, this.x + 1.0f, (float)this.columnHeaderHeight, paint);
        if (this.x < (float)clip.right) {
            paint.setColor(-2894893);
            this.rect.set((int)this.x + 1, 0, clip.right, clip.bottom);
            canvas.drawRect(this.rect, paint);
        }
    }

    public int getColumnHeaderHeight() {
        return this.columnHeaderHeight;
    }

    public void setColumnHeaderHeight(int columnHeaderHeight) {
        this.columnHeaderHeight = columnHeaderHeight;
    }

    public void calculateColumnHeaderHeight(float zoom) {
        this.columnHeaderHeight = Math.round(30.0f * zoom);
    }

    public void dispose() {
        this.sheetview = null;
        this.rect = null;
    }
}

