/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.util;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.common.UnicodeString;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFRichTextString;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFTextbox;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute.ParaAttr;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute.RunAttr;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttributeSetImpl;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IAttributeSet;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.LeafElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.ParagraphElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.SectionElement;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Cell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.style.CellStyle;
import java.util.Iterator;

public class SectionElementFactory {
    private static Workbook book;
    private static int offset;
    private static ParagraphElement paraElem;
    private static AttributeSetImpl attrLayout;
    private static LeafElement leaf;

    public static SectionElement getSectionElement(Workbook workbook, UnicodeString unicodeString, Cell cell) {
        book = workbook;
        CellStyle cellStyle = cell.getCellStyle();
        SectionElement secElem = new SectionElement();
        secElem.setStartOffset(0L);
        IAttributeSet attr = secElem.getAttribute();
        AttrManage.instance().setPageMarginLeft(attr, Math.round(30.0f));
        AttrManage.instance().setPageMarginRight(attr, Math.round(30.0f));
        AttrManage.instance().setPageMarginTop(attr, 0);
        AttrManage.instance().setPageMarginBottom(attr, 0);
        AttrManage.instance().setPageVerticalAlign(attr, switch (cellStyle.getVerticalAlign()) {
            case 0 -> 0;
            case 1 -> 1;
            case 3 -> 3;
            case 2 -> 2;
            default -> 0;
        });
        short font = cellStyle.getFontIndex();
        offset = 0;
        int pos = SectionElementFactory.processParagraph(secElem, unicodeString, cellStyle, cell);
        if (pos != 0) {
            secElem.setEndOffset(pos);
        } else {
            secElem.dispose();
            secElem = null;
        }
        SectionElementFactory.dispose();
        return secElem;
    }

    public static SectionElement getSectionElement(Workbook workbook, HSSFTextbox textbox, Rectangle rect) {
        book = workbook;
        SectionElement secElem = new SectionElement();
        secElem.setStartOffset(0L);
        IAttributeSet attr = secElem.getAttribute();
        AttrManage.instance().setPageWidth(attr, Math.round((float)rect.width * 15.0f));
        AttrManage.instance().setPageHeight(attr, Math.round((float)rect.height * 15.0f));
        AttrManage.instance().setPageMarginLeft(attr, Math.round((float)textbox.getMarginLeft() * 15.0f));
        AttrManage.instance().setPageMarginTop(attr, Math.round((float)textbox.getMarginTop() * 15.0f));
        AttrManage.instance().setPageMarginRight(attr, Math.round((float)textbox.getMarginRight() * 15.0f));
        AttrManage.instance().setPageMarginBottom(attr, Math.round((float)textbox.getMarginBottom() * 15.0f));
        byte valign = 0;
        switch (textbox.getVerticalAlignment()) {
            case 1: {
                valign = 0;
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                valign = 1;
                break;
            }
            case 3: {
                valign = 2;
            }
        }
        AttrManage.instance().setPageVerticalAlign(attr, valign);
        int pos = SectionElementFactory.processParagraph(secElem, textbox);
        secElem.setEndOffset(pos);
        SectionElementFactory.dispose();
        return secElem;
    }

    private static int processParagraph(SectionElement secElem, UnicodeString unicodeString, CellStyle cellStyle, Cell cell) {
        offset = 0;
        String text = unicodeString.getString();
        byte halign = 0;
        switch (cellStyle.getHorizontalAlign()) {
            case 1: {
                halign = 0;
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                halign = 1;
                break;
            }
            case 3: {
                halign = 2;
            }
        }
        paraElem = new ParagraphElement();
        paraElem.setStartOffset(offset);
        attrLayout = new AttributeSetImpl();
        ParaAttr.instance().setParaAttribute(cellStyle, paraElem.getAttribute(), attrLayout);
        AttrManage.instance().setParaHorizontalAlign(paraElem.getAttribute(), halign);
        if (unicodeString.getFormatRunCount() == 0) {
            SectionElementFactory.processParagraph_SubString(secElem, cellStyle, text, cellStyle.getFontIndex(), halign);
        } else {
            Iterator<UnicodeString.FormatRun> iter = unicodeString.formatIterator();
            UnicodeString.FormatRun begin = null;
            UnicodeString.FormatRun end = iter.next();
            String subString = text.substring(0, end.getCharacterPos());
            if (!cellStyle.isWrapText()) {
                subString = subString.replace("\n", "");
            }
            SectionElementFactory.processParagraph_SubString(secElem, cellStyle, subString, cellStyle.getFontIndex(), halign);
            begin = end;
            while (iter.hasNext() && (end = iter.next()).getCharacterPos() <= text.length()) {
                subString = text.substring(begin.getCharacterPos(), end.getCharacterPos());
                if (!cellStyle.isWrapText()) {
                    subString = subString.replace("\n", "");
                }
                SectionElementFactory.processParagraph_SubString(secElem, cellStyle, subString, begin.getFontIndex(), halign);
                begin = end;
            }
            subString = text.substring(begin.getCharacterPos());
            if (!cellStyle.isWrapText()) {
                subString = subString.replace("\n", "");
            }
            SectionElementFactory.processParagraph_SubString(secElem, cellStyle, subString, begin.getFontIndex(), halign);
            if (leaf != null) {
                leaf.setText(leaf.getText(null) + "\n");
                ++offset;
            }
        }
        if (leaf != null && paraElem.getLeaf(leaf.getStartOffset()) == null) {
            leaf.setEndOffset(offset);
            paraElem.appendLeaf(leaf);
        }
        if (paraElem != null && secElem.getElement(paraElem.getStartOffset()) == null) {
            paraElem.setEndOffset(offset);
            secElem.appendParagraph(paraElem, 0L);
        }
        return offset;
    }

    private static void processParagraph_SubString(SectionElement secElem, CellStyle cellStyle, String subString, int fontIndex, byte hAlign) {
        if (!subString.contains("\n")) {
            leaf = new LeafElement(subString);
            RunAttr.instance().setRunAttribute(book, fontIndex, null, leaf.getAttribute(), attrLayout);
            leaf.setStartOffset(offset);
            leaf.setEndOffset(offset += subString.length());
            paraElem.appendLeaf(leaf);
        } else {
            int index = subString.indexOf(10);
            while (index >= 0) {
                offset = SectionElementFactory.processBreakLine(secElem, cellStyle, fontIndex, hAlign, subString.substring(0, index), true);
                if (index + 1 < subString.length()) {
                    subString = subString.substring(index + 1, subString.length());
                    index = subString.indexOf(10);
                    continue;
                }
                subString = null;
                break;
            }
            if (subString != null) {
                offset = SectionElementFactory.processBreakLine(secElem, cellStyle, fontIndex, hAlign, subString, true);
            }
        }
    }

    private static int processParagraph(SectionElement secElem, HSSFTextbox textbox) {
        offset = 0;
        HSSFRichTextString richText = textbox.getString();
        String text = richText.getString();
        byte halign = 0;
        switch (textbox.getHorizontalAlignment()) {
            case 1: {
                halign = 0;
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                halign = 1;
                break;
            }
            case 3: {
                halign = 2;
            }
        }
        paraElem = new ParagraphElement();
        paraElem.setStartOffset(offset);
        attrLayout = new AttributeSetImpl();
        AttrManage.instance().setParaHorizontalAlign(paraElem.getAttribute(), halign);
        Iterator<UnicodeString.FormatRun> iter = richText.getUnicodeString().formatIterator();
        UnicodeString.FormatRun begin = iter.next();
        UnicodeString.FormatRun end = null;
        while (iter.hasNext() && (end = iter.next()).getCharacterPos() <= text.length()) {
            SectionElementFactory.processParagraph_SubString(secElem, null, text.substring(begin.getCharacterPos(), end.getCharacterPos()), begin.getFontIndex(), halign);
            begin = end;
        }
        SectionElementFactory.processParagraph_SubString(secElem, null, text.substring(begin.getCharacterPos()), begin.getFontIndex(), halign);
        if (leaf != null && paraElem.getLeaf(leaf.getStartOffset()) == null) {
            leaf.setText(leaf.getText(null) + "\n");
            leaf.setEndOffset(++offset);
            paraElem.appendLeaf(leaf);
        }
        if (paraElem != null && secElem.getElement(paraElem.getStartOffset()) == null) {
            paraElem.setEndOffset(offset);
            secElem.appendParagraph(paraElem, 0L);
        }
        return offset;
    }

    private static int processBreakLine(SectionElement secElem, CellStyle cellStyle, int fontID, byte hAlign, String text, boolean paraEnd) {
        if (text == null || text.length() == 0) {
            if (leaf != null) {
                leaf.setText(leaf.getText(null) + "\n");
                leaf.setEndOffset(++offset);
            } else {
                leaf = new LeafElement("\n");
                RunAttr.instance().setRunAttribute(book, fontID, null, leaf.getAttribute(), attrLayout);
                leaf.setStartOffset(offset);
                leaf.setEndOffset(++offset);
                paraElem.appendLeaf(leaf);
            }
            paraElem.setEndOffset(offset);
            secElem.appendParagraph(paraElem, 0L);
            paraElem = new ParagraphElement();
            paraElem.setStartOffset(offset);
            attrLayout = new AttributeSetImpl();
            ParaAttr.instance().setParaAttribute(cellStyle, paraElem.getAttribute(), attrLayout);
            AttrManage.instance().setParaHorizontalAlign(paraElem.getAttribute(), hAlign);
            leaf = null;
        } else {
            leaf = new LeafElement(text);
            RunAttr.instance().setRunAttribute(book, fontID, null, leaf.getAttribute(), attrLayout);
            leaf.setStartOffset(offset);
            leaf.setEndOffset(offset += text.length());
            paraElem.appendLeaf(leaf);
            if (paraEnd) {
                leaf.setText(leaf.getText(null) + "\n");
                leaf.setEndOffset(++offset);
                paraElem.setEndOffset(offset);
                secElem.appendParagraph(paraElem, 0L);
                paraElem = new ParagraphElement();
                paraElem.setStartOffset(offset);
                attrLayout = new AttributeSetImpl();
                ParaAttr.instance().setParaAttribute(cellStyle, paraElem.getAttribute(), attrLayout);
                AttrManage.instance().setParaHorizontalAlign(paraElem.getAttribute(), hAlign);
                leaf = null;
            }
        }
        return offset;
    }

    private static void dispose() {
        leaf = null;
        paraElem = null;
        book = null;
        offset = 0;
        attrLayout = null;
    }
}

