/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.other;

import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Row;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.sheetProperty.PaneInformation;

public class SheetScroller {
    private int minRowIndex;
    private int minColumnIndex;
    private float columnWidth;
    private float rowHeight;
    private boolean isRowAllVisible = true;
    private boolean isColumnAllVisible = true;
    private double visibleRowHeight;
    private double visibleColumnWidth;

    public void reset() {
        this.setMinRowIndex(0);
        this.setMinColumnIndex(0);
        this.setRowHeight(0.0f);
        this.setColumnWidth(0.0f);
        this.setVisibleRowHeight(0.0);
        this.setVisibleColumnWidth(0.0);
        this.setRowAllVisible(true);
        this.setColumnAllVisible(true);
    }

    public void update(Sheet sheet, int scrollX, int scrollY) {
        int maxSheetColumns;
        this.reset();
        this.setVisibleRowHeight(scrollY);
        this.setVisibleColumnWidth(scrollX);
        PaneInformation paneInfo = sheet.getPaneInformation();
        if (paneInfo != null) {
            this.setMinRowIndex(paneInfo.getHorizontalSplitTopRow());
            this.setMinColumnIndex(paneInfo.getVerticalSplitLeftColumn());
        }
        int maxSheetRows = sheet.getWorkbook().isBefore07Version() ? 65536 : 0x100000;
        int n = maxSheetColumns = sheet.getWorkbook().isBefore07Version() ? 256 : 16384;
        if (scrollY > 0) {
            Row row;
            int firstRow = sheet.getFirstRowNum();
            int lastRow = sheet.getLastRowNum();
            int defaultRowHeight = sheet.getDefaultRowHeight();
            while (this.visibleRowHeight >= 1.0 && this.minRowIndex <= maxSheetRows) {
                row = this.minRowIndex >= firstRow && this.minRowIndex <= lastRow ? sheet.getRow(this.minRowIndex) : null;
                if (row == null || row != null && !row.isZeroHeight()) {
                    this.rowHeight = row == null ? (float)defaultRowHeight : row.getRowPixelHeight();
                    this.visibleRowHeight -= (double)this.rowHeight;
                }
                ++this.minRowIndex;
            }
            if (this.minRowIndex != maxSheetRows) {
                --this.minRowIndex;
                this.setVisibleRowHeight(Math.abs(this.getVisibleRowHeight()));
                if (this.getVisibleRowHeight() < 1.0) {
                    ++this.minRowIndex;
                    this.setVisibleRowHeight(0.0);
                } else {
                    this.setRowAllVisible(false);
                }
            } else {
                --this.minRowIndex;
                row = sheet.getRow(this.minRowIndex);
                while (row != null && row.isZeroHeight()) {
                    --this.minRowIndex;
                    row = sheet.getRow(this.getMinRowIndex());
                }
                this.setVisibleRowHeight(0.0);
            }
        }
        if (scrollX > 0) {
            while (this.visibleColumnWidth >= 1.0 && this.minColumnIndex <= maxSheetColumns) {
                if (!sheet.isColumnHidden(this.minColumnIndex)) {
                    this.columnWidth = sheet.getColumnPixelWidth(this.minColumnIndex);
                    this.visibleColumnWidth -= (double)this.columnWidth;
                }
                ++this.minColumnIndex;
            }
            if (this.minColumnIndex != maxSheetColumns) {
                --this.minColumnIndex;
                this.setVisibleColumnWidth(Math.abs(this.getVisibleColumnWidth()));
                if (this.getVisibleColumnWidth() < 1.0) {
                    ++this.minColumnIndex;
                    this.setVisibleColumnWidth(0.0);
                } else {
                    this.setColumnAllVisible(false);
                }
            } else {
                --this.minColumnIndex;
                while (sheet.isColumnHidden(this.minColumnIndex)) {
                    --this.minColumnIndex;
                }
                this.setVisibleColumnWidth(0.0);
            }
        }
    }

    public int getMinRowIndex() {
        return this.minRowIndex;
    }

    public void setMinRowIndex(int minRowIndex) {
        this.minRowIndex = minRowIndex;
    }

    public void dispose() {
    }

    public int getMinColumnIndex() {
        return this.minColumnIndex;
    }

    public void setMinColumnIndex(int minColumnIndex) {
        this.minColumnIndex = minColumnIndex;
    }

    public float getColumnWidth() {
        return this.columnWidth;
    }

    public void setColumnWidth(float columnWidth) {
        this.columnWidth = columnWidth;
    }

    public float getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(float rowHeight) {
        this.rowHeight = rowHeight;
    }

    public boolean isRowAllVisible() {
        return this.isRowAllVisible;
    }

    public void setRowAllVisible(boolean isRowAllVisible) {
        this.isRowAllVisible = isRowAllVisible;
    }

    public boolean isColumnAllVisible() {
        return this.isColumnAllVisible;
    }

    public void setColumnAllVisible(boolean isColumnAllVisible) {
        this.isColumnAllVisible = isColumnAllVisible;
    }

    public double getVisibleRowHeight() {
        return this.visibleRowHeight;
    }

    public void setVisibleRowHeight(double visibleRowHeight) {
        this.visibleRowHeight = visibleRowHeight;
    }

    public double getVisibleColumnWidth() {
        return this.visibleColumnWidth;
    }

    public void setVisibleColumnWidth(double visibleColumnWidth) {
        this.visibleColumnWidth = visibleColumnWidth;
    }
}

