/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.other;

import com.ahmadullahpk.alldocumentreader.xs.ss.model.CellRangeAddress;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.sheetProperty.PaneInformation;
import com.ahmadullahpk.alldocumentreader.xs.ss.other.MergeCell;
import com.ahmadullahpk.alldocumentreader.xs.ss.view.SheetView;

public class MergeCellMgr {
    private CellRangeAddress cellRangeAddress = new CellRangeAddress(0, 0, 0, 0);
    private MergeCell mergedCell = new MergeCell();

    public CellRangeAddress getVisibleCellRangeAddress(Sheet sheet, CellRangeAddress cr) {
        int firstCol;
        int lastCol = cr.getLastColumn();
        int firstRow = cr.getFirstRow();
        int lastRow = cr.getLastRow();
        for (firstCol = cr.getFirstColumn(); firstCol <= lastCol && sheet.isColumnHidden(firstCol); ++firstCol) {
        }
        while (lastCol >= firstCol && sheet.isColumnHidden(lastCol)) {
            --lastCol;
        }
        while (firstRow <= lastRow && sheet.getRow(firstRow).isZeroHeight()) {
            ++firstRow;
        }
        while (lastRow >= firstRow && sheet.getRow(lastRow).isZeroHeight()) {
            --lastRow;
        }
        this.cellRangeAddress.setFirstColumn(firstCol);
        this.cellRangeAddress.setFirstRow(firstRow);
        this.cellRangeAddress.setLastColumn(lastCol);
        this.cellRangeAddress.setLastRow(lastRow);
        return this.cellRangeAddress;
    }

    public boolean isDrawMergeCell(SheetView sheetView, CellRangeAddress cr, int row, int col) {
        boolean isDraw = false;
        int minColumn = sheetView.getMinRowAndColumnInformation().getMinColumnIndex();
        int minRow = sheetView.getMinRowAndColumnInformation().getMinRowIndex();
        PaneInformation paneInfo = sheetView.getCurrentSheet().getPaneInformation();
        this.getVisibleCellRangeAddress(sheetView.getCurrentSheet(), cr);
        if (paneInfo != null) {
            if (row < paneInfo.getHorizontalSplitTopRow() && cr.getLastRow() >= paneInfo.getHorizontalSplitTopRow()) {
                this.cellRangeAddress.setLastRow(paneInfo.getHorizontalSplitTopRow() - 1);
                minRow = 0;
            } else if (row >= paneInfo.getHorizontalSplitTopRow() && cr.getFirstRow() < paneInfo.getHorizontalSplitTopRow()) {
                this.cellRangeAddress.setFirstRow(paneInfo.getHorizontalSplitTopRow());
            }
            if (col < paneInfo.getVerticalSplitLeftColumn() && cr.getLastColumn() >= paneInfo.getVerticalSplitLeftColumn()) {
                this.cellRangeAddress.setLastColumn(paneInfo.getVerticalSplitLeftColumn() - 1);
                minColumn = 0;
            } else if (col >= paneInfo.getVerticalSplitLeftColumn() && cr.getFirstColumn() < paneInfo.getVerticalSplitLeftColumn()) {
                this.cellRangeAddress.setFirstColumn(paneInfo.getVerticalSplitLeftColumn());
            }
        }
        if (this.cellRangeAddress.getFirstColumn() == col && this.cellRangeAddress.getFirstRow() == row) {
            isDraw = true;
        } else if (row == this.cellRangeAddress.getFirstRow() && col > this.cellRangeAddress.getFirstColumn()) {
            isDraw = col == minColumn;
        } else if (col == this.cellRangeAddress.getFirstColumn() && row > this.cellRangeAddress.getFirstRow()) {
            isDraw = row == minRow;
        } else if (row > this.cellRangeAddress.getFirstRow() && col > this.cellRangeAddress.getFirstColumn()) {
            isDraw = col == minColumn && row == minRow;
        }
        return isDraw;
    }

    public MergeCell getMergedCellSize(SheetView sheetView, CellRangeAddress cellRangeAddress, int row, int col) {
        this.mergedCell.reset();
        int minColumn = sheetView.getMinRowAndColumnInformation().getMinColumnIndex();
        int minRow = sheetView.getMinRowAndColumnInformation().getMinRowIndex();
        PaneInformation paneInfo = sheetView.getCurrentSheet().getPaneInformation();
        if (paneInfo == null) {
            int i;
            for (i = cellRangeAddress.getFirstColumn(); i <= cellRangeAddress.getLastColumn(); ++i) {
                if (sheetView.getCurrentSheet().isColumnHidden(i)) continue;
                float tW = sheetView.getCurrentSheet().getColumnPixelWidth(i) * sheetView.getZoom();
                this.mergedCell.setWidth(this.mergedCell.getWidth() + tW);
                if (i >= minColumn) continue;
                this.mergedCell.setNovisibleWidth(this.mergedCell.getNovisibleWidth() + tW);
            }
            for (i = cellRangeAddress.getFirstRow(); i <= cellRangeAddress.getLastRow(); ++i) {
                if (sheetView.getCurrentSheet().getRow(i).isZeroHeight()) continue;
                float tH = sheetView.getCurrentSheet().getRow(i).getRowPixelHeight() * sheetView.getZoom();
                this.mergedCell.setHeight(this.mergedCell.getHeight() + tH);
                if (i >= minRow) continue;
                this.mergedCell.setNoVisibleHeight(this.mergedCell.getNoVisibleHeight() + tH);
            }
        } else {
            int i;
            if (col >= paneInfo.getVerticalSplitLeftColumn()) {
                for (i = cellRangeAddress.getFirstColumn(); i <= cellRangeAddress.getLastColumn(); ++i) {
                    if (sheetView.getCurrentSheet().isColumnHidden(i)) continue;
                    tW = sheetView.getCurrentSheet().getColumnPixelWidth(i) * sheetView.getZoom();
                    this.mergedCell.setWidth(this.mergedCell.getWidth() + tW);
                    if (i >= minColumn) continue;
                    this.mergedCell.setNovisibleWidth(this.mergedCell.getNovisibleWidth() + tW);
                }
            } else {
                this.mergedCell.setFrozenColumn(true);
                for (i = cellRangeAddress.getFirstColumn(); i <= cellRangeAddress.getLastColumn(); ++i) {
                    if (sheetView.getCurrentSheet().isColumnHidden(i)) continue;
                    tW = sheetView.getCurrentSheet().getColumnPixelWidth(i) * sheetView.getZoom();
                    this.mergedCell.setWidth(this.mergedCell.getWidth() + tW);
                    if (i < paneInfo.getVerticalSplitLeftColumn()) continue;
                    this.mergedCell.setNovisibleWidth(this.mergedCell.getNovisibleWidth() + tW);
                }
            }
            if (row >= paneInfo.getHorizontalSplitTopRow()) {
                for (i = cellRangeAddress.getFirstRow(); i <= cellRangeAddress.getLastRow(); ++i) {
                    if (sheetView.getCurrentSheet().getRow(i).isZeroHeight()) continue;
                    tH = sheetView.getCurrentSheet().getRow(i).getRowPixelHeight() * sheetView.getZoom();
                    this.mergedCell.setHeight(this.mergedCell.getHeight() + tH);
                    if (i >= minRow) continue;
                    this.mergedCell.setNoVisibleHeight(this.mergedCell.getNoVisibleHeight() + tH);
                }
            } else {
                this.mergedCell.setFrozenRow(true);
                for (i = cellRangeAddress.getFirstRow(); i <= cellRangeAddress.getLastRow(); ++i) {
                    if (sheetView.getCurrentSheet().getRow(i).isZeroHeight()) continue;
                    tH = sheetView.getCurrentSheet().getRow(i).getRowPixelHeight() * sheetView.getZoom();
                    this.mergedCell.setHeight(this.mergedCell.getHeight() + tH);
                    if (i < paneInfo.getHorizontalSplitTopRow()) continue;
                    this.mergedCell.setNoVisibleHeight(this.mergedCell.getNoVisibleHeight() + tH);
                }
            }
        }
        return this.mergedCell;
    }

    public void dispose() {
        if (this.cellRangeAddress != null) {
            this.cellRangeAddress.dispose();
            this.cellRangeAddress = null;
        }
        if (this.mergedCell != null) {
            this.mergedCell.dispose();
            this.mergedCell = null;
        }
    }
}

