/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.model;

import com.ahmadullahpk.alldocumentreader.xs.ss.model.Anchor;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Row;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.interfacePart.IClientAnchor;

public final class ClientAnchor
extends Anchor
implements IClientAnchor {
    private short col1;
    private int row1;
    private short col2;
    private int row2;
    private int anchorType;

    public ClientAnchor() {
    }

    public ClientAnchor(int dx1, int dy1, int dx2, int dy2, short col1, int row1, short col2, int row2) {
        super(dx1, dy1, dx2, dy2);
        this.checkRange(dx1, 0, 1023, "dx1");
        this.checkRange(dx2, 0, 1023, "dx2");
        this.checkRange(dy1, 0, 255, "dy1");
        this.checkRange(dy2, 0, 255, "dy2");
        this.checkRange(col1, 0, 255, "col1");
        this.checkRange(col2, 0, 255, "col2");
        this.checkRange(row1, 0, 65280, "row1");
        this.checkRange(row2, 0, 65280, "row2");
        this.col1 = col1;
        this.row1 = row1;
        this.col2 = col2;
        this.row2 = row2;
    }

    public float getAnchorHeightInPoints(Sheet sheet) {
        int y1 = this.getDy1();
        int y2 = this.getDy2();
        int row1 = Math.min(this.getRow1(), this.getRow2());
        int row2 = Math.max(this.getRow1(), this.getRow2());
        float points = 0.0f;
        if (row1 == row2) {
            points = (float)(y2 - y1) / 256.0f * this.getRowHeightInPoints(sheet, row2);
        } else {
            points += (256.0f - (float)y1) / 256.0f * this.getRowHeightInPoints(sheet, row1);
            for (int i = row1 + 1; i < row2; ++i) {
                points += this.getRowHeightInPoints(sheet, i);
            }
            points += (float)y2 / 256.0f * this.getRowHeightInPoints(sheet, row2);
        }
        return points;
    }

    private float getRowHeightInPoints(Sheet sheet, int rowNum) {
        Row row = sheet.getRow(rowNum);
        if (row == null) {
            return 13.5f;
        }
        return row.getRowPixelHeight() * 0.75f;
    }

    @Override
    public short getCol1() {
        return this.col1;
    }

    public void setCol1(short col1) {
        this.checkRange(col1, 0, 255, "col1");
        this.col1 = col1;
    }

    @Override
    public void setCol1(int col1) {
        this.setCol1((short)col1);
    }

    @Override
    public short getCol2() {
        return this.col2;
    }

    public void setCol2(short col2) {
        this.checkRange(col2, 0, 255, "col2");
        this.col2 = col2;
    }

    @Override
    public void setCol2(int col2) {
        this.setCol2((short)col2);
    }

    @Override
    public int getRow1() {
        return this.row1;
    }

    @Override
    public void setRow1(int row1) {
        this.checkRange(row1, 0, 65536, "row1");
        this.row1 = row1;
    }

    @Override
    public int getRow2() {
        return this.row2;
    }

    @Override
    public void setRow2(int row2) {
        this.checkRange(row2, 0, 65536, "row2");
        this.row2 = row2;
    }

    public void setAnchor(short col1, int row1, int x1, int y1, short col2, int row2, int x2, int y2) {
        this.checkRange(this.dx1, 0, 1023, "dx1");
        this.checkRange(this.dx2, 0, 1023, "dx2");
        this.checkRange(this.dy1, 0, 255, "dy1");
        this.checkRange(this.dy2, 0, 255, "dy2");
        this.checkRange(col1, 0, 255, "col1");
        this.checkRange(col2, 0, 255, "col2");
        this.checkRange(row1, 0, 65280, "row1");
        this.checkRange(row2, 0, 65280, "row2");
        this.col1 = col1;
        this.row1 = row1;
        this.dx1 = x1;
        this.dy1 = y1;
        this.col2 = col2;
        this.row2 = row2;
        this.dx2 = x2;
        this.dy2 = y2;
    }

    @Override
    public boolean isHorizontallyFlipped() {
        if (this.col1 == this.col2) {
            return this.dx1 > this.dx2;
        }
        return this.col1 > this.col2;
    }

    @Override
    public boolean isVerticallyFlipped() {
        if (this.row1 == this.row2) {
            return this.dy1 > this.dy2;
        }
        return this.row1 > this.row2;
    }

    @Override
    public int getAnchorType() {
        return this.anchorType;
    }

    @Override
    public void setAnchorType(int anchorType) {
        this.anchorType = anchorType;
    }

    private void checkRange(int value, int minRange, int maxRange, String varName) {
        if (value < minRange || value > maxRange) {
            throw new IllegalArgumentException(varName + " must be between " + minRange + " and " + maxRange);
        }
    }
}

