/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.simpletext.model;

import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IAttributeSet;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IDocument;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.ParagraphElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.SectionElement;

public class STDocument
implements IDocument {
    private SectionElement section;

    @Override
    public long getArea(long offset) {
        return offset & 0xF000000000000000L;
    }

    @Override
    public long getAreaStart(long offset) {
        long area = offset & 0xF000000000000000L;
        if (area == 0x5000000000000000L) {
            return offset & 0xFFFFFFF00000000L;
        }
        return area;
    }

    @Override
    public long getAreaEnd(long offset) {
        return this.getAreaStart(offset) + this.getLength(offset);
    }

    @Override
    public long getLength(long offset) {
        return this.section.getEndOffset() - this.section.getStartOffset();
    }

    @Override
    public IElement getSection(long offset) {
        return this.section;
    }

    @Override
    public void appendSection(IElement elem) {
        this.section = (SectionElement)elem;
    }

    @Override
    public void appendElement(IElement elem, long offset) {
    }

    @Override
    public IElement getHFElement(long area, byte type) {
        return null;
    }

    @Override
    public IElement getFEElement(long offset) {
        return null;
    }

    @Override
    public IElement getParagraph(long offset) {
        return this.section.getParaCollection().getElement(offset);
    }

    @Override
    public IElement getParagraphForIndex(int index, long area) {
        return this.section.getParaCollection().getElementForIndex(index);
    }

    @Override
    public void appendParagraph(IElement element, long offset) {
        this.section.appendParagraph(element, offset);
    }

    @Override
    public void insertString(String str, IAttributeSet attr, long offset) {
    }

    @Override
    public IElement getLeaf(long offset) {
        IElement para = this.getParagraph(offset);
        if (para != null) {
            return ((ParagraphElement)para).getLeaf(offset);
        }
        return null;
    }

    @Override
    public void setSectionAttr(long start, int len, IAttributeSet attr) {
        this.section.getAttribute().mergeAttribute(attr);
    }

    @Override
    public void setParagraphAttr(long start, int len, IAttributeSet attr) {
        long end = start + (long)len;
        while (start < end) {
            IElement para = this.section.getParaCollection().getElement(start);
            para.getAttribute().mergeAttribute(attr);
            start = para.getEndOffset();
        }
    }

    @Override
    public void setLeafAttr(long start, int len, IAttributeSet attr) {
        long end = start + (long)len;
        while (start < end) {
            IElement leaf = this.getLeaf(start);
            leaf.getAttribute().mergeAttribute(attr);
            start = leaf.getEndOffset();
        }
    }

    @Override
    public int getParaCount(long area) {
        return this.section.getParaCollection().size();
    }

    @Override
    public String getText(long start, long end) {
        String str = "";
        long len = end - start;
        if (len == 0L || this.getArea(start) != this.getArea(end)) {
            return str;
        }
        IElement leaf = this.getLeaf(start);
        String t = leaf.getText(null);
        int sIndex = (int)(start - leaf.getStartOffset());
        int eIndex = (int)(end >= leaf.getEndOffset() ? (long)t.length() : end - leaf.getStartOffset());
        str = t.substring(sIndex, eIndex);
        start = leaf.getEndOffset();
        while (start < end) {
            leaf = this.getLeaf(start);
            t = leaf.getText(null);
            eIndex = (int)(end >= leaf.getEndOffset() ? (long)t.length() : end - leaf.getStartOffset());
            str = t.substring(0, eIndex);
            start = leaf.getEndOffset();
        }
        return str;
    }

    @Override
    public void dispose() {
        if (this.section != null) {
            this.section.dispose();
            this.section = null;
        }
    }
}

