/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.pg.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.GroupShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.IShape;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Dimension;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.Animation;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.AnimationManager;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.EmphanceAnimation;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.FadeAnimation;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.IAnimation;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.ShapeAnimation;
import com.ahmadullahpk.alldocumentreader.xs.pg.control.Presentation;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGSlide;
import com.ahmadullahpk.alldocumentreader.xs.pg.view.SlideDrawKit;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.CalloutView.CalloutView;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SlideShowView {
    private Paint paint;
    private Rect bgRect;
    private Presentation presentation;
    private PGSlide slide;
    private int slideshowStep = 0;
    private AnimationManager animationMgr;
    private Map<Integer, Map<Integer, IAnimation>> shapeVisible;
    private Rect animShapeArea;
    private IAnimation pageAnimation;
    private int animDuration = 1200;

    public SlideShowView(Presentation presentation, PGSlide slide) {
        this.presentation = presentation;
        this.slide = slide;
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setTypeface(Typeface.SANS_SERIF);
        this.paint.setTextSize(24.0f);
        this.bgRect = new Rect();
    }

    private void removeAnimation() {
        if (this.shapeVisible == null) {
            this.shapeVisible = new HashMap<Integer, Map<Integer, IAnimation>>();
        } else {
            this.shapeVisible.clear();
            this.slideshowStep = 0;
        }
        if (this.animationMgr != null) {
            this.animationMgr.stopAnimation();
        }
        if (this.presentation.getEditor() != null) {
            this.presentation.getEditor().clearAnimation();
        }
        if (this.slide != null) {
            int count = this.slide.getShapeCount();
            for (int i = 0; i < count; ++i) {
                this.removeShapeAnimation(this.slide.getShape(i));
            }
        }
    }

    private void removeShapeAnimation(IShape shape) {
        if (shape instanceof GroupShape) {
            IShape[] shapes;
            for (IShape item : shapes = ((GroupShape)shape).getShapes()) {
                this.removeShapeAnimation(item);
            }
        } else {
            IAnimation anim2 = shape.getAnimation();
            if (anim2 != null) {
                shape.setAnimation(null);
                anim2.dispose();
                Object var2_3 = null;
            }
        }
    }

    public void initSlideShow(PGSlide slide, boolean showAnimation) {
        this.removeAnimation();
        this.slide = slide;
        if (slide == null) {
            return;
        }
        List<ShapeAnimation> shapeAnimLst = slide.getSlideShowAnimation();
        if (shapeAnimLst != null) {
            int count = shapeAnimLst.size();
            block0: for (int i = 0; i < count; ++i) {
                ShapeAnimation shapeAnim = shapeAnimLst.get(i);
                Map<Integer, IAnimation> animMap = this.shapeVisible.get(shapeAnim.getShapeID());
                if (animMap == null) {
                    animMap = new HashMap<Integer, IAnimation>();
                    this.shapeVisible.put(shapeAnim.getShapeID(), animMap);
                }
                for (int para = shapeAnim.getParagraphBegin(); para <= shapeAnim.getParagraphEnd(); ++para) {
                    IAnimation animation = animMap.get(para);
                    if (animation != null) continue;
                    animation = new FadeAnimation(shapeAnim, this.animDuration);
                    for (para = shapeAnim.getParagraphBegin(); para <= shapeAnim.getParagraphEnd(); ++para) {
                        animMap.put(para, animation);
                    }
                    this.setShapeAnimation(shapeAnim.getShapeID(), animation);
                    continue block0;
                }
            }
        }
        if (this.animationMgr == null) {
            this.animationMgr = this.presentation.getControl().getSysKit().getAnimationManager();
        }
        if (slide.hasTransition()) {
            if (this.pageAnimation == null) {
                this.pageAnimation = new FadeAnimation(new ShapeAnimation(-3, 0), this.animDuration);
            } else {
                this.pageAnimation.setDuration(this.animDuration);
            }
            this.animationMgr.setAnimation(this.pageAnimation);
            if (showAnimation) {
                this.animationMgr.beginAnimation(1000 / this.pageAnimation.getFPS());
            } else {
                this.animationMgr.stopAnimation();
            }
        }
    }

    private void setShapeAnimation(int shapeID, IAnimation animation) {
        int count = this.slide.getShapeCount();
        for (int i = 0; i < count; ++i) {
            IShape shape = this.slide.getShape(i);
            if (shape.getShapeID() != shapeID && shape.getGroupShapeID() != shapeID || shape.getAnimation() != null) continue;
            this.setShapeAnimation(shape, animation);
        }
    }

    private void setShapeAnimation(IShape shape, IAnimation animation) {
        if (shape instanceof GroupShape) {
            IShape[] shapes;
            for (IShape item : shapes = ((GroupShape)shape).getShapes()) {
                this.setShapeAnimation(item, animation);
            }
        } else {
            shape.setAnimation(animation);
        }
    }

    public void endSlideShow() {
        this.removeAnimation();
    }

    public boolean isExitSlideShow() {
        return this.slide == null;
    }

    public boolean gotopreviousSlide() {
        List<ShapeAnimation> shapeAnimLst = this.slide.getSlideShowAnimation();
        if (shapeAnimLst != null) {
            return this.slideshowStep <= 0;
        }
        return true;
    }

    public boolean gotoNextSlide() {
        List<ShapeAnimation> shapeAnimLst = this.slide.getSlideShowAnimation();
        if (shapeAnimLst != null) {
            return this.slideshowStep >= shapeAnimLst.size();
        }
        return true;
    }

    public void previousActionSlideShow() {
        int oldSlideshowStep = this.slideshowStep - 1;
        this.initSlideShow(this.slide, false);
        while (this.slideshowStep < oldSlideshowStep) {
            ++this.slideshowStep;
            this.updateShapeAnimation(this.slideshowStep, false);
        }
    }

    public void nextActionSlideShow() {
        ++this.slideshowStep;
        this.updateShapeAnimation(this.slideshowStep, true);
    }

    public void gotoLastAction() {
        while (!this.gotoNextSlide()) {
            ++this.slideshowStep;
            this.updateShapeAnimation(this.slideshowStep, false);
        }
    }

    private void updateShapeAnimation(int curSlideShowStep, boolean showAnimation) {
        List<ShapeAnimation> shapeAnimLst = this.slide.getSlideShowAnimation();
        if (shapeAnimLst != null) {
            ShapeAnimation shapeAnim = shapeAnimLst.get(curSlideShowStep - 1);
            this.updateShapeArea(shapeAnim.getShapeID(), this.presentation.getZoom());
            Animation animation = shapeAnim.getAnimationType() != 1 ? new FadeAnimation(shapeAnim, this.animDuration) : new EmphanceAnimation(shapeAnim, this.animDuration);
            Map<Integer, IAnimation> animMap = this.shapeVisible.get(shapeAnim.getShapeID());
            animMap.put(shapeAnim.getParagraphBegin(), animation);
            this.updateShapeAnimation(shapeAnim.getShapeID(), animation, showAnimation);
        }
    }

    private void updateShapeAnimation(int shapeID, IAnimation animation, boolean showAnimation) {
        this.animationMgr.setAnimation(animation);
        int count = this.slide.getShapeCount();
        for (int i = 0; i < count; ++i) {
            IShape shape = this.slide.getShape(i);
            if (shape.getShapeID() != shapeID && shape.getGroupShapeID() != shapeID) continue;
            this.setShapeAnimation(shape, animation);
        }
        if (showAnimation) {
            this.animationMgr.beginAnimation(1000 / animation.getFPS());
        } else {
            this.animationMgr.stopAnimation();
        }
    }

    private void updateShapeArea(int shapeID, float zoom) {
        int count = this.slide.getShapeCount();
        for (int i = 0; i < count; ++i) {
            Rectangle shapeRect;
            IShape shape = this.slide.getShape(i);
            if (shape.getShapeID() != shapeID || (shapeRect = shape.getBounds()) == null) continue;
            int left = Math.round((float)shapeRect.x * zoom);
            int top = Math.round((float)shapeRect.y * zoom);
            int width = Math.round((float)shapeRect.width * zoom);
            int height = Math.round((float)shapeRect.height * zoom);
            if (this.animShapeArea == null) {
                this.animShapeArea = new Rect(left, top, left + width, top + height);
            } else {
                this.animShapeArea.set(left, top, left + width, top + height);
            }
            return;
        }
        this.animShapeArea = null;
    }

    public void changeSlide(PGSlide slide) {
        this.slide = slide;
    }

    public Rect getDrawingRect() {
        return this.bgRect;
    }

    public void drawSlide(Canvas canvas, float zoom, CalloutView callouts) {
        if (this.pageAnimation != null && this.pageAnimation.getAnimationStatus() != 2 && (zoom *= this.pageAnimation.getCurrentAnimationInfor().getProgress()) <= 0.001f) {
            return;
        }
        Dimension d = this.presentation.getPageSize();
        int w = (int)((float)d.width * zoom);
        int h = (int)((float)d.height * zoom);
        int x = (this.presentation.getmWidth() - w) / 2;
        int y = (this.presentation.getmHeight() - h) / 2;
        canvas.save();
        canvas.translate((float)x, (float)y);
        canvas.clipRect(0, 0, w, h);
        this.bgRect.set(0, 0, w, h);
        SlideDrawKit.instance().drawSlide(canvas, this.presentation.getPGModel(), this.presentation.getEditor(), this.slide, zoom, this.shapeVisible);
        canvas.restore();
        if (callouts != null) {
            if (this.pageAnimation != null && this.pageAnimation.getAnimationStatus() != 2) {
                callouts.setVisibility(4);
            } else {
                callouts.setZoom(zoom);
                callouts.layout(x, y, x + w, y + h);
                callouts.setVisibility(0);
            }
        }
    }

    public void drawSlideForToPicture(Canvas canvas, float zoom, int originBitmapW, int originBitmapH) {
        Rect rect = canvas.getClipBounds();
        if (rect.width() != originBitmapW || rect.height() != originBitmapH) {
            zoom *= Math.min((float)rect.width() / (float)originBitmapW, (float)rect.height() / (float)originBitmapH);
        }
        SlideDrawKit.instance().drawSlide(canvas, this.presentation.getPGModel(), this.presentation.getEditor(), this.slide, zoom, this.shapeVisible);
    }

    public boolean animationStoped() {
        if (this.animationMgr != null) {
            return this.animationMgr.hasStoped();
        }
        return true;
    }

    public void setAnimationDuration(int duration) {
        this.animDuration = duration;
    }

    public Bitmap getSlideshowToImage(PGSlide slide, int step) {
        this.slide = slide;
        this.initSlideShow(slide, false);
        while (this.slideshowStep < step - 1) {
            ++this.slideshowStep;
            this.updateShapeAnimation(this.slideshowStep, false);
        }
        Bitmap image = SlideDrawKit.instance().slideToImage(this.presentation.getPGModel(), this.presentation.getEditor(), slide, this.shapeVisible);
        this.removeAnimation();
        return image;
    }

    public void dispose() {
        this.paint = null;
        this.presentation = null;
        this.slide = null;
        if (this.animationMgr != null) {
            this.animationMgr.dispose();
            this.animationMgr = null;
        }
        if (this.shapeVisible != null) {
            this.shapeVisible.clear();
            this.shapeVisible = null;
        }
    }
}

