/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.pg.control;

import com.ahmadullahpk.alldocumentreader.xs.common.shape.IShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.pg.control.Presentation;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGSlide;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.SectionElement;
import com.ahmadullahpk.alldocumentreader.xs.system.IFind;

public class PGFind
implements IFind {
    private boolean isSetPointToVisible;
    private Presentation presentation;
    private String query;
    private int shapeIndex = -1;
    private int slideIndex = -1;
    private int startOffset = -1;
    protected Rectangle rect;

    public PGFind(Presentation presentation) {
        this.presentation = presentation;
        this.rect = new Rectangle();
    }

    @Override
    public boolean find(String query) {
        if (query == null) {
            return false;
        }
        this.query = query;
        this.startOffset = -1;
        this.shapeIndex = -1;
        int slideIndex = this.presentation.getCurrentIndex();
        do {
            if (this.findSlideForward(slideIndex)) {
                return true;
            }
            if (++slideIndex != this.presentation.getRealSlideCount()) continue;
            slideIndex = 0;
        } while (slideIndex != this.presentation.getCurrentIndex());
        return false;
    }

    @Override
    public boolean findBackward() {
        if (this.query == null) {
            return false;
        }
        int slideIndex = this.presentation.getCurrentIndex();
        do {
            if (this.findSlideBackward(slideIndex)) {
                return true;
            }
            this.startOffset = -1;
            this.shapeIndex = -1;
        } while (--slideIndex >= 0);
        return false;
    }

    @Override
    public boolean findForward() {
        if (this.query == null) {
            return false;
        }
        int slideIndex = this.presentation.getCurrentIndex();
        do {
            if (this.findSlideForward(slideIndex)) {
                return true;
            }
            this.startOffset = -1;
            this.shapeIndex = -1;
        } while (++slideIndex != this.presentation.getRealSlideCount());
        return false;
    }

    private boolean findSlideBackward(int slideIndex) {
        int i;
        PGSlide slide = this.presentation.getSlide(slideIndex);
        int n = i = this.shapeIndex >= 0 ? this.shapeIndex : slide.getShapeCountForFind() - 1;
        while (i >= 0) {
            IShape shape = slide.getShapeForFind(i);
            if (shape != null && shape.getType() == 1) {
                int offset = this.shapeIndex == i && this.presentation.getCurrentIndex() == slideIndex ? this.startOffset : -1;
                SectionElement elem = ((TextBox)shape).getElement();
                if (elem != null && (offset < 0 || offset >= this.query.length()) && elem.getEndOffset() - elem.getStartOffset() != 0L && (offset = offset >= 0 ? elem.getText(this.presentation.getRenderersDoc()).lastIndexOf(this.query, Math.max(this.startOffset - this.query.length(), 0)) : elem.getText(this.presentation.getRenderersDoc()).lastIndexOf(this.query)) >= 0) {
                    this.startOffset = offset;
                    this.shapeIndex = i;
                    this.addHighlight(slideIndex, (TextBox)shape);
                    return true;
                }
            }
            --i;
        }
        return false;
    }

    private boolean findSlideForward(int slideIndex) {
        PGSlide slide = this.presentation.getSlide(slideIndex);
        for (int i = Math.max(0, this.shapeIndex); i < slide.getShapeCountForFind(); ++i) {
            SectionElement elem;
            IShape shape = slide.getShapeForFind(i);
            if (shape == null || shape.getType() != 1 || (elem = ((TextBox)shape).getElement()) == null || elem.getEndOffset() - elem.getStartOffset() == 0L) continue;
            int offset = this.shapeIndex == i && this.presentation.getCurrentIndex() == slideIndex ? this.startOffset : -1;
            if ((offset = offset >= 0 ? elem.getText(this.presentation.getRenderersDoc()).indexOf(this.query, this.startOffset + this.query.length()) : elem.getText(this.presentation.getRenderersDoc()).indexOf(this.query)) < 0) continue;
            this.startOffset = offset;
            this.shapeIndex = i;
            this.addHighlight(slideIndex, (TextBox)shape);
            return true;
        }
        return false;
    }

    public void addHighlight(int slideIndex, TextBox textBox) {
        boolean invalidate = true;
        if (slideIndex != this.presentation.getCurrentIndex()) {
            this.presentation.showSlide(slideIndex, true);
            this.isSetPointToVisible = true;
            invalidate = false;
        } else {
            this.rect.setBounds(0, 0, 0, 0);
            this.presentation.getEditor().modelToView(this.startOffset, this.rect, false);
            if (!this.presentation.getPrintMode().getListView().isPointVisibleOnScreen(this.rect.x, this.rect.y)) {
                this.presentation.getPrintMode().getListView().setItemPointVisibleOnScreen(this.rect.x, this.rect.y);
                invalidate = false;
            } else {
                this.presentation.getPrintMode().exportImage(this.presentation.getPrintMode().getListView().getCurrentPageView(), null);
            }
        }
        if (invalidate) {
            this.presentation.postInvalidate();
        }
        this.slideIndex = slideIndex;
        this.presentation.getEditor().setEditorTextBox(textBox);
        this.presentation.getEditor().getHighlight().addHighlight(this.startOffset, this.startOffset + this.query.length());
        this.presentation.getControl().actionEvent(20, null);
    }

    public void onConfigurationChanged() {
        PGSlide slide = this.presentation.getCurrentSlide();
        if (this.shapeIndex >= 0 && this.shapeIndex < slide.getShapeCountForFind()) {
            this.presentation.getEditor().getHighlight().addHighlight(this.startOffset, this.startOffset + this.query.length());
            this.presentation.postInvalidate();
        }
    }

    public boolean isSetPointToVisible() {
        return this.isSetPointToVisible;
    }

    public void setSetPointToVisible(boolean isSetPointToVisible) {
        this.isSetPointToVisible = isSetPointToVisible;
    }

    @Override
    public int getPageIndex() {
        return this.slideIndex;
    }

    @Override
    public void resetSearchResult() {
    }

    @Override
    public void dispose() {
        this.presentation = null;
        this.query = null;
    }
}

