/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.officereader.filelist;

import com.ahmadullahpk.alldocumentreader.xs.officereader.filelist.FileItem;
import java.io.File;
import java.util.Comparator;

public class FileSort
implements Comparator<FileItem> {
    public static final int FILESORT_TYPE_NULL = -1;
    public static final int FILESORT_TYPE_DIR = 0;
    public static final int FILESORT_TYPE_MODIFIED_DATE = 1;
    public static final int FILESORT_TYPE_SIZE = 2;
    public static final int FILESORT_TYPE_NAME = 3;
    public static final int FILESORT_ASCENDING = 0;
    public static final int FILESORT_TYPE_DESCENDING = 1;
    public static final int FILE_TYPE_DOC = 0;
    public static final int FILE_TYPE_DOCX = 1;
    public static final int FILE_TYPE_XLS = 2;
    public static final int FILE_TYPE_XLSX = 3;
    public static final int FILE_TYPE_PPT = 4;
    public static final int FILE_TYPE_PPTX = 5;
    public static final int FILE_TYPE_TXT = 6;
    public static final int FILE_TYPE_PDF = 7;
    private static FileSort mt = new FileSort();
    private int sortType;
    private int ascending;

    private FileSort() {
    }

    public static FileSort instance() {
        return mt;
    }

    @Override
    public int compare(FileItem object1, FileItem object2) {
        int result = 0;
        switch (this.sortType) {
            case 0: {
                if (this.ascending == 0) {
                    result = this.compareByDirUp(object1, object2);
                    break;
                }
                result = this.compareByDirDown(object1, object2);
                break;
            }
            case 1: {
                if (this.ascending == 0) {
                    result = this.compareByModifiedDateUp(object1, object2);
                    break;
                }
                result = this.compareByModifiedDateDown(object1, object2);
                break;
            }
            case 2: {
                if (this.ascending == 0) {
                    result = this.compareBySizeUp(object1, object2);
                    break;
                }
                result = this.compareBySizeDown(object1, object2);
                break;
            }
            case 3: {
                if (this.ascending == 0) {
                    result = this.comparaByNameUp(object1, object2);
                    break;
                }
                result = this.comparaByNameDown(object1, object2);
                break;
            }
        }
        return result;
    }

    private int comparaByNameDown(FileItem object1, FileItem object2) {
        String fileName2;
        File file1 = object1.getFile();
        File file2 = object2.getFile();
        if (file1.isDirectory() && file2.isFile()) {
            return 1;
        }
        if (file1.isFile() && file2.isDirectory()) {
            return -1;
        }
        String fileName1 = object1.getFileName();
        if (fileName1.compareToIgnoreCase(fileName2 = object2.getFileName()) < 0) {
            return 1;
        }
        if (fileName1.compareToIgnoreCase(fileName2) > 0) {
            return -1;
        }
        return 0;
    }

    private int comparaByNameUp(FileItem object1, FileItem object2) {
        String fileName2;
        File file1 = object1.getFile();
        File file2 = object2.getFile();
        if (file1.isDirectory() && file2.isFile()) {
            return -1;
        }
        if (file1.isFile() && file2.isDirectory()) {
            return 1;
        }
        String fileName1 = object1.getFileName();
        if (fileName1.compareToIgnoreCase(fileName2 = object2.getFileName()) > 0) {
            return 1;
        }
        if (fileName1.compareToIgnoreCase(fileName2) < 0) {
            return -1;
        }
        return 0;
    }

    private int compareByModifiedDateDown(FileItem object1, FileItem object2) {
        long d2;
        File file1 = object1.getFile();
        File file2 = object2.getFile();
        if (file1.isDirectory() && file2.isFile()) {
            return 1;
        }
        if (file1.isFile() && file2.isDirectory()) {
            return -1;
        }
        long d1 = object1.getFile().lastModified();
        if (d1 == (d2 = object2.getFile().lastModified())) {
            return this.comparaByNameDown(object1, object2);
        }
        return d1 < d2 ? 1 : -1;
    }

    private int compareByModifiedDateUp(FileItem object1, FileItem object2) {
        long d2;
        File file1 = object1.getFile();
        File file2 = object2.getFile();
        if (file1.isDirectory() && file2.isFile()) {
            return -1;
        }
        if (file1.isFile() && file2.isDirectory()) {
            return 1;
        }
        long d1 = object1.getFile().lastModified();
        if (d1 == (d2 = object2.getFile().lastModified())) {
            return this.comparaByNameUp(object1, object2);
        }
        return d1 > d2 ? 1 : -1;
    }

    private int compareBySizeDown(FileItem object1, FileItem object2) {
        long s2;
        File file1 = object1.getFile();
        File file2 = object2.getFile();
        if (file1.isDirectory() && file2.isFile()) {
            return 1;
        }
        if (file1.isDirectory() && file2.isDirectory()) {
            return this.comparaByNameDown(object1, object2);
        }
        if (file1.isFile() && file2.isDirectory()) {
            return -1;
        }
        long s1 = file1.length();
        if (s1 == (s2 = file2.length())) {
            return this.comparaByNameDown(object1, object2);
        }
        return s1 < s2 ? 1 : -1;
    }

    private int compareBySizeUp(FileItem object1, FileItem object2) {
        long s2;
        File file1 = object1.getFile();
        File file2 = object2.getFile();
        if (file1.isDirectory() && file2.isFile()) {
            return -1;
        }
        if (file1.isDirectory() && file2.isDirectory()) {
            return this.comparaByNameUp(object1, object2);
        }
        if (file1.isFile() && file2.isDirectory()) {
            return 1;
        }
        long s1 = file1.length();
        if (s1 == (s2 = file2.length())) {
            return this.comparaByNameUp(object1, object2);
        }
        return s1 > s2 ? 1 : -1;
    }

    private int compareByDirDown(FileItem object1, FileItem object2) {
        int type2;
        File file1 = object1.getFile();
        File file2 = object2.getFile();
        if (file1.isDirectory() && file2.isFile()) {
            return 1;
        }
        if (file1.isDirectory() && file2.isDirectory()) {
            return this.comparaByNameDown(object1, object2);
        }
        if (file1.isFile() && file2.isDirectory()) {
            return -1;
        }
        int type1 = this.getFileType(object1.getFileName());
        if (type1 == (type2 = this.getFileType(object2.getFileName()))) {
            return this.comparaByNameDown(object1, object2);
        }
        return type1 < type2 ? 1 : -1;
    }

    private int compareByDirUp(FileItem object1, FileItem object2) {
        int type2;
        File file1 = object1.getFile();
        File file2 = object2.getFile();
        if (file1.isDirectory() && file2.isFile()) {
            return -1;
        }
        if (file1.isDirectory() && file2.isDirectory()) {
            return this.comparaByNameUp(object1, object2);
        }
        if (file1.isFile() && file2.isDirectory()) {
            return 1;
        }
        int type1 = this.getFileType(object1.getFileName());
        if (type1 == (type2 = this.getFileType(object2.getFileName()))) {
            return this.comparaByNameUp(object1, object2);
        }
        return type1 > type2 ? 1 : -1;
    }

    public int getFileType(String fileName) {
        if ((fileName = fileName.toLowerCase()).endsWith("doc") || fileName.endsWith("dot")) {
            return 0;
        }
        if (fileName.endsWith("docx") || fileName.endsWith("dotx") || fileName.endsWith("dotm")) {
            return 1;
        }
        if (fileName.endsWith("xls") || fileName.endsWith("xlt")) {
            return 2;
        }
        if (fileName.endsWith("xlsx") || fileName.endsWith("xltx") || fileName.endsWith("xltm") || fileName.endsWith("xlsm")) {
            return 3;
        }
        if (fileName.endsWith("ppt") || fileName.endsWith("pot")) {
            return 4;
        }
        if (fileName.endsWith("pptx") || fileName.endsWith("pptm") || fileName.endsWith("potx") || fileName.endsWith("potm")) {
            return 5;
        }
        if (fileName.endsWith("pdf")) {
            return 7;
        }
        return 6;
    }

    public void setType(int type, int ascending) {
        this.sortType = type;
        this.ascending = ascending;
    }

    public void dispose() {
    }
}

