/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.officereader.filelist;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import com.ahmadullahpk.alldocumentreader.R;
import com.ahmadullahpk.alldocumentreader.xs.officereader.filelist.FileNameDialog;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.IDialogAction;
import com.ahmadullahpk.alldocumentreader.xs.system.dialog.MessageDialog;
import java.io.File;
import java.util.Vector;

public class FileRenameDialog
extends FileNameDialog {
    private TextWatcher watcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            FileRenameDialog.this.ok.setEnabled(FileRenameDialog.this.checkFileName(s.toString()));
        }

        public void afterTextChanged(Editable s) {
        }
    };

    public FileRenameDialog(IControl control, Context context, IDialogAction action, Vector<Object> model, int dialogID, int titleResID) {
        super(control, context, action, model, dialogID, titleResID);
        this.initDialog();
    }

    public void initDialog() {
        if (this.model != null) {
            File file = (File)this.model.get(0);
            String name = file.getName();
            if (file.isFile()) {
                this.textView.setText(R.string.dialog_file_name);
                name = name.substring(0, name.lastIndexOf(46));
            } else {
                this.textView.setText(R.string.dialog_folder_name);
            }
            this.editText.setText((CharSequence)name);
            this.editText.addTextChangedListener(this.watcher);
        }
    }

    @Override
    public void onClick(View v) {
        if (v == this.ok) {
            if (this.model == null) {
                this.dismiss();
                return;
            }
            File file = (File)this.model.get(0);
            String exe = "";
            if (file.isFile()) {
                exe = file.getName();
                exe = exe.substring(exe.lastIndexOf(46));
            }
            String filePath = file.getParent();
            String name = this.editText.getText().toString().trim();
            File newFile = filePath.endsWith(File.separator) ? new File(filePath + name + exe) : new File(filePath + File.separator + name + exe);
            Vector<Object> vector = new Vector<Object>();
            vector.add(file);
            vector.add(newFile);
            if (!newFile.exists()) {
                this.action.doAction(this.dialogID, vector);
                this.dismiss();
            } else {
                CharSequence text = this.getContext().getResources().getText(R.string.dialog_name_error);
                String message = text.toString().replace("%s", name);
                new MessageDialog(this.control, this.getContext(), this.action, null, 0, R.string.dialog_file_rename_error, message).show();
            }
        } else {
            this.dismiss();
        }
    }

    public boolean checkFileName(String fileName) {
        if (this.model != null && ((File)this.model.get(0)).getName().equals(fileName)) {
            return false;
        }
        return this.isFileNameOK(fileName);
    }
}

