/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.macro;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.macro.DialogListener;
import com.ahmadullahpk.alldocumentreader.xs.macro.ErrorListener;
import com.ahmadullahpk.alldocumentreader.xs.macro.MacroCustomDialog;
import com.ahmadullahpk.alldocumentreader.xs.macro.MacroFrame;
import com.ahmadullahpk.alldocumentreader.xs.macro.MacroOfficeToPicture;
import com.ahmadullahpk.alldocumentreader.xs.macro.MacroSlideShow;
import com.ahmadullahpk.alldocumentreader.xs.macro.OfficeToPictureListener;
import com.ahmadullahpk.alldocumentreader.xs.macro.OpenFileFinishListener;
import com.ahmadullahpk.alldocumentreader.xs.macro.SlideShowListener;
import com.ahmadullahpk.alldocumentreader.xs.macro.TouchEventListener;
import com.ahmadullahpk.alldocumentreader.xs.macro.UpdateStatusListener;
import com.ahmadullahpk.alldocumentreader.xs.system.FileKit;
import com.ahmadullahpk.alldocumentreader.xs.system.MainControl;
import java.util.Vector;

public class Application {
    public static final byte APPLICATION_TYPE_WP = 0;
    public static final byte APPLICATION_TYPE_SS = 1;
    public static final byte APPLICATION_TYPE_PPT = 2;
    public static final byte APPLICATION_TYPE_PDF = 3;
    public static final byte APPLICATION_TYPE_TXT = 0;
    public static final int STANDARD_RATE = 10000;
    public static final int MAXZOOM = 30000;
    public static final int MAXZOOM_THUMBNAIL = 5000;
    public static final int DRAWMODE_NORMAL = 0;
    public static final int DRAWMODE_CALLOUTDRAW = 1;
    public static final int DRAWMODE_CALLOUTERASE = 2;
    public static final byte MOVING_HORIZONTAL = 0;
    public static final byte MOVING_VERTICAL = 1;
    public static final int THUMBNAILSIZE = 1000;
    private byte applicationType = (byte)-1;
    private ViewGroup parent;
    private MacroFrame frame;
    private MainControl mainControl;
    protected Toast toast;

    public Application(Activity activity, ViewGroup parent) {
        this.frame = new MacroFrame(this, activity);
        this.mainControl = new MainControl(this.frame);
        this.parent = parent;
    }

    public void setViewBackground(Object bg) {
        if (this.frame != null && bg != null && (bg instanceof Integer || bg instanceof Drawable)) {
            this.frame.setViewBackground(bg);
        }
    }

    public void addOfficeToPictureListener(OfficeToPictureListener listener) {
        if (listener != null) {
            this.mainControl.setOffictToPicture(new MacroOfficeToPicture(listener));
        }
    }

    public void addDialogListener(DialogListener dlgListener) {
        if (dlgListener != null) {
            this.mainControl.setCustomDialog(new MacroCustomDialog(dlgListener));
        }
    }

    public void addSlideShowListener(SlideShowListener listener) {
        if (listener != null) {
            this.mainControl.setSlideShow(new MacroSlideShow(listener));
        }
    }

    public void addOpenFileFinishListener(OpenFileFinishListener listener) {
        this.frame.addOpenFileFinishListener(listener);
    }

    public void addTouchEventListener(TouchEventListener listener) {
        this.frame.addTouchEventListener(listener);
    }

    public void addUpdateStatusListener(UpdateStatusListener listener) {
        this.frame.addUpdateStatusListener(listener);
    }

    public void addErrorListener(ErrorListener listener) {
        this.frame.addErrorListener(listener);
    }

    public boolean openFile(String filePath) {
        String file = filePath.toLowerCase();
        if (file.endsWith("doc") || file.endsWith("docx") || file.endsWith("dot") || file.endsWith("dotx") || file.endsWith("dotm")) {
            this.applicationType = 0;
        } else if (file.endsWith("xls") || file.endsWith("xlsx") || file.endsWith("xlt") || file.endsWith("xltx") || file.endsWith("xltm") || file.endsWith("xlsm")) {
            this.applicationType = 1;
        } else if (file.endsWith("ppt") || file.endsWith("pptx") || file.endsWith("pot") || file.endsWith("pptm") || file.endsWith("potx") || file.endsWith("potm")) {
            this.applicationType = (byte)2;
        } else if (file.endsWith("pdf")) {
            this.applicationType = (byte)3;
        } else {
            if (this.frame != null && this.frame.isThumbnail()) {
                this.setDefaultViewMode(0);
            } else {
                this.setDefaultViewMode(1);
            }
            this.applicationType = 0;
        }
        this.mainControl.openFile(filePath);
        return true;
    }

    protected void openFileFinish() {
        View app = this.getView();
        if (this.parent != null) {
            this.parent.addView(app, new ViewGroup.LayoutParams(-1, -1));
        }
    }

    public byte getApplicationType() {
        return this.applicationType;
    }

    public View getView() {
        if (this.mainControl == null) {
            return null;
        }
        return this.mainControl.getView();
    }

    public void pageDown() {
        if (this.mainControl == null) {
            return;
        }
        this.mainControl.actionEvent(0x2000000E, null);
    }

    public void pageUp() {
        if (this.mainControl == null) {
            return;
        }
        this.mainControl.actionEvent(0x2000000D, null);
    }

    public boolean find(String str) {
        if (this.mainControl == null || str == null || str.trim().length() == 0 || this.isSlideShowMode()) {
            return false;
        }
        boolean finded = this.mainControl.getFind().find(str);
        if (!finded && this.mainControl.getMainFrame().isShowFindDlg()) {
            if (this.applicationType == 3) {
                return finded;
            }
            if (this.toast == null) {
                this.toast = Toast.makeText((Context)this.mainControl.getView().getContext(), (CharSequence)"", (int)0);
            }
            this.toast.setText((CharSequence)this.mainControl.getMainFrame().getLocalString("DIALOG_FIND_NOT_FOUND"));
            this.toast.show();
        }
        return finded;
    }

    public boolean findBackward() {
        if (this.mainControl == null || this.isSlideShowMode()) {
            return false;
        }
        boolean finded = this.mainControl.getFind().findBackward();
        if (!finded && this.mainControl.getMainFrame().isShowFindDlg()) {
            if (this.applicationType == 3) {
                return finded;
            }
            if (this.toast == null) {
                this.toast = Toast.makeText((Context)this.mainControl.getView().getContext(), (CharSequence)"", (int)0);
            }
            this.toast.setText((CharSequence)this.mainControl.getMainFrame().getLocalString("DIALOG_FIND_TO_BEGIN"));
            this.toast.show();
        }
        return finded;
    }

    public boolean findForward() {
        if (this.mainControl == null || this.isSlideShowMode()) {
            return false;
        }
        boolean finded = this.mainControl.getFind().findForward();
        if (!finded && this.mainControl.getMainFrame().isShowFindDlg()) {
            if (this.applicationType == 3) {
                return finded;
            }
            if (this.toast == null) {
                this.toast = Toast.makeText((Context)this.mainControl.getView().getContext(), (CharSequence)"", (int)0);
            }
            this.toast.setText((CharSequence)this.mainControl.getMainFrame().getLocalString("DIALOG_FIND_TO_END"));
            this.toast.show();
        }
        return finded;
    }

    public void setTouchZoom(boolean value) {
        if (this.frame == null) {
            return;
        }
        this.frame.setTouchZoom(value);
    }

    public void setDrawPageNumber(boolean value) {
        if (this.frame == null) {
            return;
        }
        this.frame.setDrawPageNumber(value);
    }

    public void setShowZoomingMsg(boolean showZoomingMsg) {
        if (this.frame == null) {
            return;
        }
        this.frame.setShowZoomingMsg(showZoomingMsg);
    }

    public void setPopUpErrorDlg(boolean popupErrorDlg) {
        if (this.frame == null) {
            return;
        }
        this.frame.setPopUpErrorDlg(popupErrorDlg);
    }

    public void setShowPasswordDlg(boolean showPasswordDlg) {
        if (this.frame != null) {
            this.frame.setShowPasswordDlg(showPasswordDlg);
        }
    }

    public void setShowFindDlg(boolean b) {
        if (this.frame != null) {
            this.frame.setShowFindDlg(b);
        }
    }

    public void setShowProgressBar(boolean showProgressbarDlg) {
        if (this.frame != null) {
            this.frame.setShowProgressBar(showProgressbarDlg);
        }
    }

    public void setShowTXTEncodeDlg(boolean showTXTEncodeDlg) {
        if (this.frame != null) {
            this.frame.setShowTXTEncodeDlg(showTXTEncodeDlg);
        }
    }

    public void setTXTDefaultEncode(String enode) {
        if (this.frame != null) {
            this.frame.setTXTDefaultEncode(enode);
        }
    }

    public void setAppName(String name) {
        if (this.frame == null) {
            return;
        }
        this.frame.setAppName(name);
    }

    public void setTopBarHeight(int value) {
        if (this.frame == null || this.parent == null) {
            return;
        }
        if (value >= this.parent.getContext().getResources().getDisplayMetrics().heightPixels / 2) {
            return;
        }
        this.frame.setTopBarHeight(value);
    }

    public void setBottomBarHeight(int value) {
        if (this.frame == null || this.parent == null) {
            return;
        }
        if (value >= this.parent.getContext().getResources().getDisplayMetrics().heightPixels / 2) {
            return;
        }
        this.frame.setBottomBarHeight(value);
    }

    public void setChangePage(boolean b) {
        if (this.frame != null) {
            this.frame.setChangePage(b);
        }
    }

    public int getZoom() {
        if (this.mainControl == null) {
            return 10000;
        }
        Object obj = this.mainControl.getActionValue(0x20000005, null);
        return obj == null ? 10000 : Math.round(((Float)obj).floatValue() * 10000.0f);
    }

    public int getFitZoom() {
        if (this.mainControl == null) {
            return 10000;
        }
        Object obj = this.mainControl.getActionValue(0x20000006, null);
        return obj == null ? 10000 : Math.round(((Float)obj).floatValue() * 10000.0f);
    }

    public void setZoom(int value, int pointX, int pointY) {
        if (this.mainControl == null || this.getView() == null || value > 30000 || value < this.getFitZoom() || value == this.getZoom() || this.isSlideShowMode()) {
            return;
        }
        if (pointX < 0 || pointY < 0 || pointX > this.getView().getWidth() || pointY > this.getView().getHeight()) {
            pointX = Integer.MIN_VALUE;
            pointY = Integer.MIN_VALUE;
        }
        this.mainControl.actionEvent(0x20000005, new int[]{value, pointX, pointY});
        this.getView().postInvalidate();
        if (this.parent != null) {
            this.parent.post(new Runnable(){

                @Override
                public void run() {
                    if (Application.this.mainControl != null) {
                        try {
                            if (Application.this.applicationType == 1) {
                                Application.this.mainControl.actionEvent(0x2000000A, null);
                            } else if (Application.this.applicationType == 0 && Application.this.getViewMode() != 2) {
                                Application.this.mainControl.actionEvent(0x2000000A, null);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            if (this.applicationType == 0 && this.frame.isZoomAfterLayoutForWord()) {
                this.mainControl.actionEvent(0x30000005, null);
            }
        }
    }

    public void setFitSize(int value) {
        if (this.mainControl == null) {
            return;
        }
        this.mainControl.actionEvent(536870933, value);
    }

    public int getFitSizeState() {
        if (this.mainControl == null || this.applicationType == 1 || this.applicationType == 0 && this.getViewMode() != 2) {
            return 0;
        }
        Object obj = this.mainControl.getActionValue(536870934, null);
        return obj == null ? 3 : (Integer)obj;
    }

    public Bitmap getSnapshot(Bitmap destBitmap) {
        if (this.mainControl == null || destBitmap == null) {
            return null;
        }
        Object obj = this.mainControl.getActionValue(536870936, destBitmap);
        return obj == null ? null : (Bitmap)obj;
    }

    public int getPagesCount() {
        if (this.mainControl == null) {
            return -1;
        }
        Object obj = this.mainControl.getActionValue(0x2000000B, null);
        return obj == null ? -1 : (Integer)obj;
    }

    public int getCurrentPageNumber() {
        if (this.mainControl == null) {
            return -1;
        }
        Object obj = this.mainControl.getActionValue(0x2000000C, null);
        return obj == null ? -1 : (Integer)obj;
    }

    public Bitmap getPageToImage(int pageNumber) {
        if (this.mainControl == null || pageNumber < 1) {
            return null;
        }
        Object obj = this.mainControl.getActionValue(0x30000003, pageNumber);
        return obj == null ? null : (Bitmap)obj;
    }

    private Bitmap getAreaToImage(int pageNumber, int srcLeft, int srcTop, int srcWidth, int srcHeight, int desWidth, int desHeight) {
        if (this.mainControl == null || pageNumber < 1) {
            return null;
        }
        Object obj = this.mainControl.getActionValue(536870931, new int[]{pageNumber, srcLeft, srcTop, srcWidth, srcHeight, desWidth, desHeight});
        return obj == null ? null : (Bitmap)obj;
    }

    public Bitmap getPageAreaToImage(int pageNumber, int srcLeft, int srcTop, int srcWidth, int srcHeight, int desWidth, int desHeight) {
        if (this.applicationType != 0) {
            return null;
        }
        return this.getAreaToImage(pageNumber, srcLeft, srcTop, srcWidth, srcHeight, desWidth, desHeight);
    }

    public Rectangle getPageSize(int pageNumber) {
        if (this.mainControl == null) {
            return null;
        }
        Object obj = this.mainControl.getActionValue(0x30000004, pageNumber);
        return obj == null ? null : (Rectangle)obj;
    }

    public int getViewMode() {
        if (this.mainControl == null) {
            return -1;
        }
        Object obj = this.mainControl.getActionValue(0x30000006, null);
        return obj == null ? 0 : (Integer)obj;
    }

    public void setDefaultViewMode(int viewMode) {
        if (this.frame == null) {
            return;
        }
        if (viewMode < 0 || viewMode > 2) {
            viewMode = 0;
        }
        this.frame.setWordDefaultView((byte)viewMode);
    }

    public void setZoomAfterLayoutForNormalView(boolean value) {
        if (this.frame == null) {
            return;
        }
        this.frame.setZoomAfterLayoutForWord(value);
    }

    public void showPage(int index) {
        if (this.mainControl == null || index < 0) {
            return;
        }
        this.mainControl.actionEvent(0x30000002, index);
    }

    public void switchViewMode(int viewMode) {
        if (this.mainControl == null) {
            return;
        }
        if (viewMode < 0 || viewMode > 2) {
            viewMode = 0;
        }
        this.mainControl.actionEvent(0x30000001, viewMode);
    }

    public Vector<String> getAllSheetName() {
        if (this.mainControl == null) {
            return null;
        }
        Object obj = this.mainControl.getActionValue(0x40000002, null);
        return obj == null ? null : (Vector)obj;
    }

    public String getSheetName(int sheetNumber) {
        if (this.mainControl == null || sheetNumber < 1) {
            return null;
        }
        Object obj = this.mainControl.getActionValue(0x40000003, sheetNumber);
        return obj == null ? null : (String)obj;
    }

    public int getCurrentSheetNumber() {
        if (this.mainControl == null) {
            return -1;
        }
        Object obj = this.mainControl.getActionValue(0x2000000C, null);
        return obj == null ? -1 : (Integer)obj;
    }

    public int getSheetsCount() {
        if (this.mainControl == null) {
            return -1;
        }
        Object obj = this.mainControl.getActionValue(0x2000000B, null);
        return obj == null ? -1 : (Integer)obj;
    }

    public void showSheet(int index) {
        if (this.mainControl == null || index < 0) {
            return;
        }
        this.mainControl.actionEvent(0x40000001, index);
    }

    public void removeDefaultSheetBarForExcel() {
        this.mainControl.actionEvent(0x40000005, null);
    }

    public void previousSlide() {
        if (this.mainControl == null) {
            return;
        }
        this.mainControl.actionEvent(0x2000000D, null);
    }

    public void nextSlide() {
        if (this.mainControl == null) {
            return;
        }
        this.mainControl.actionEvent(0x2000000E, null);
    }

    public int getSlidesCount() {
        if (this.mainControl == null) {
            return -1;
        }
        Object obj = this.mainControl.getActionValue(0x2000000B, null);
        return obj == null ? -1 : (Integer)obj;
    }

    public int getLoadSlidesCount() {
        if (this.mainControl == null) {
            return -1;
        }
        Object obj = this.mainControl.getActionValue(536870935, null);
        return obj == null ? -1 : (Integer)obj;
    }

    public int getCurrentSlideNumber() {
        if (this.mainControl == null) {
            return -1;
        }
        Object obj = this.mainControl.getActionValue(0x2000000C, null);
        return obj == null ? -1 : (Integer)obj;
    }

    public String getSlideNote(int slideNumber) {
        if (this.mainControl == null || slideNumber < 1) {
            return null;
        }
        Object obj = this.mainControl.getActionValue(0x50000004, slideNumber);
        return obj == null ? null : (String)obj;
    }

    public Rectangle getSlideSize(int slideNumber) {
        if (this.mainControl == null) {
            return null;
        }
        Object obj = this.mainControl.getActionValue(0x50000005, slideNumber);
        return obj == null ? null : (Rectangle)obj;
    }

    public void showSlide(int index) {
        if (this.mainControl == null || index < 0) {
            return;
        }
        this.mainControl.actionEvent(0x50000002, index);
    }

    public Bitmap getSlideToImage(int slideNumber) {
        if (this.mainControl == null || slideNumber < 1) {
            return null;
        }
        Object obj = this.mainControl.getActionValue(0x50000003, slideNumber);
        return obj == null ? null : (Bitmap)obj;
    }

    public Bitmap getSlideAreaToImage(int slideNumber, int srcLeft, int srcTop, int srcWidth, int srcHeight, int desWidth, int desHeight) {
        if (this.applicationType != 2) {
            return null;
        }
        return this.getAreaToImage(slideNumber, srcLeft, srcTop, srcWidth, srcHeight, desWidth, desHeight);
    }

    public Bitmap getSlideThumbnail(int slideNumber, int zoomValue) {
        if (this.applicationType != 2 || this.mainControl == null || slideNumber < 1 || zoomValue <= 0 || zoomValue > 5000) {
            return null;
        }
        Object obj = this.mainControl.getActionValue(0x20000010, new int[]{slideNumber, zoomValue});
        return obj == null ? null : (Bitmap)obj;
    }

    public void showPDFPage(int index) {
        if (this.mainControl == null || index < 0) {
            return;
        }
        this.mainControl.actionEvent(0x60000000, index);
    }

    public Bitmap getPDFPageToImage(int pageNumber) {
        if (this.mainControl == null || pageNumber < 1) {
            return null;
        }
        Object obj = this.mainControl.getActionValue(0x60000001, pageNumber);
        return obj == null ? null : (Bitmap)obj;
    }

    public Bitmap getPDFPageAreaToImage(int pageNumber, int srcLeft, int srcTop, int srcWidth, int srcHeight, int desWidth, int desHeight) {
        if (this.applicationType != 3) {
            return null;
        }
        return this.getAreaToImage(pageNumber, srcLeft, srcTop, srcWidth, srcHeight, desWidth, desHeight);
    }

    public Bitmap getPDFPageThumbnail(int pageNumber, int zoomValue) {
        if (this.applicationType != 3 || this.mainControl == null || pageNumber < 1 || zoomValue <= 0 || zoomValue > 5000) {
            return null;
        }
        Object obj = this.mainControl.getActionValue(0x20000010, new int[]{pageNumber, zoomValue});
        return obj == null ? null : (Bitmap)obj;
    }

    public String[] getPDFHyperlinkURL(int pageNumber) {
        if (this.mainControl == null || pageNumber < 1) {
            return null;
        }
        Object obj = this.mainControl.getActionValue(536870932, pageNumber);
        return obj == null ? null : (String[])obj;
    }

    public Rectangle getPDFPageSize(int pageNumber) {
        if (this.mainControl == null) {
            return null;
        }
        Object obj = this.mainControl.getActionValue(0x60000002, pageNumber);
        return obj == null ? null : (Rectangle)obj;
    }

    public void addI18NResID(String resName, int resID) {
        this.frame.addI18NResID(resName, resID);
    }

    public boolean authenticatePassword(String password) {
        if (this.mainControl == null || password == null || password.trim().length() == 0) {
            return false;
        }
        Object obj = this.mainControl.getActionValue(0x20000011, password);
        return obj == null ? false : (Boolean)obj;
    }

    public void passwordVerified(String password) {
        if (this.mainControl == null) {
            return;
        }
        if (!this.authenticatePassword(password)) {
            this.mainControl.getSysKit().getErrorKit().writerLog(new Throwable("Password is incorrect"));
        } else {
            this.mainControl.actionEvent(0x20000012, password);
        }
    }

    public void txtEncodeDialogFinished(String encode) {
        if (this.mainControl == null || encode == null) {
            return;
        }
        this.mainControl.actionEvent(0x7000000, encode);
    }

    public void reopenTXT(String filePath, String encode) {
        if (this.mainControl == null || filePath == null || encode == null) {
            return;
        }
        if (filePath.toLowerCase().endsWith("txt")) {
            this.setDefaultViewMode(1);
            this.applicationType = 0;
            this.mainControl.actionEvent(0x7000001, new String[]{filePath, encode});
        }
    }

    public boolean isSupport(String fileName) {
        return FileKit.instance().isSupport(fileName);
    }

    public void setAnimationDuration(int duration) {
        if (this.mainControl != null && !this.isSlideShowMode()) {
            duration = Math.min(1200, Math.max(duration, 100));
            this.mainControl.actionEvent(1358954503, duration);
        }
    }

    public void beginSlideShow(int slideIndex) {
        if (this.mainControl != null) {
            if (slideIndex < 1 || slideIndex > this.getSlidesCount()) {
                slideIndex = 1;
            }
            this.mainControl.actionEvent(0x51000001, slideIndex >= 1 ? slideIndex : 1);
        }
    }

    public void exitSlideShow() {
        if (this.mainControl != null) {
            this.mainControl.actionEvent(1358954498, null);
        }
    }

    public boolean hasNextSlide_Slideshow() {
        if (this.mainControl == null) {
            return false;
        }
        Object obj = this.mainControl.getActionValue(0x2000000E, null);
        return obj == null ? false : (Boolean)obj;
    }

    public boolean hasPreviousSlide_Slideshow() {
        if (this.mainControl == null) {
            return false;
        }
        Object obj = this.mainControl.getActionValue(0x2000000D, null);
        return obj == null ? false : (Boolean)obj;
    }

    public boolean hasNextAction_Slideshow() {
        if (this.mainControl == null) {
            return false;
        }
        Object obj = this.mainControl.getActionValue(1358954502, null);
        return obj == null ? false : (Boolean)obj;
    }

    public void nextAction_Slideshow() {
        if (this.mainControl != null) {
            this.mainControl.actionEvent(1358954500, null);
        }
    }

    public boolean hasPreviousAction_Slideshow() {
        if (this.mainControl == null) {
            return false;
        }
        Object obj = this.mainControl.getActionValue(0x51000005, null);
        return obj == null ? false : (Boolean)obj;
    }

    public void previousAction_Slideshow() {
        if (this.mainControl != null) {
            this.mainControl.actionEvent(1358954499, null);
        }
    }

    private boolean isSlideShowMode() {
        if (this.mainControl == null || this.applicationType != 2) {
            return false;
        }
        Object obj = this.mainControl.getActionValue(0x51000000, null);
        return obj == null ? false : (Boolean)obj;
    }

    public boolean isSlideExist(int slideIndex) {
        if (this.mainControl != null && this.applicationType == 2 && slideIndex > 0) {
            Object obj = this.mainControl.getActionValue(1358954504, slideIndex);
            return obj == null ? false : (Boolean)obj;
        }
        return false;
    }

    public int getSlideAnimationSteps(int slideIndex) {
        if (this.isSlideExist(slideIndex)) {
            Object obj = this.mainControl.getActionValue(1358954505, slideIndex);
            return obj == null ? -1 : (Integer)obj;
        }
        return -1;
    }

    public Bitmap getSlideshowToImage(int slideIndex, int step) {
        if (!this.isSlideShowMode() && step > 0 && step <= this.getSlideAnimationSteps(slideIndex)) {
            Object obj = this.mainControl.getActionValue(1358954506, new int[]{slideIndex, step});
            return obj == null ? null : (Bitmap)obj;
        }
        return null;
    }

    public String getTemporaryDirectoryPath() {
        if (this.mainControl == null) {
            return null;
        }
        return this.mainControl.getSysKit().getPictureManage().getPicTempPath();
    }

    public void setWriteLog(boolean writeLog) {
        if (this.frame == null) {
            return;
        }
        this.frame.setWriteLog(writeLog);
    }

    public void setThumbnail(boolean isThumbnail) {
        if (this.frame == null) {
            return;
        }
        this.frame.setThumbnail(isThumbnail);
    }

    public Bitmap getDocThumbnail(int zoomValue) {
        if (this.applicationType != 0 || this.mainControl == null || zoomValue <= 0 || zoomValue > 5000) {
            return null;
        }
        Object obj = this.mainControl.getActionValue(0x20000010, zoomValue);
        return obj == null ? null : (Bitmap)obj;
    }

    public Bitmap getTxtThumbnail(int zoomValue) {
        if (this.applicationType != 0 || this.mainControl == null || zoomValue <= 0 || zoomValue > 5000) {
            return null;
        }
        Object obj = this.mainControl.getActionValue(0x20000010, zoomValue);
        return obj == null ? null : (Bitmap)obj;
    }

    public Bitmap getXlsThumbnail(int width, int height, int zoomValue) {
        if (this.applicationType != 1 || this.mainControl == null || width < 1 || width > 1000 || height < 1 || height > 1000 || zoomValue <= 0 || zoomValue > 5000) {
            return null;
        }
        Object obj = this.mainControl.getActionValue(0x20000010, new int[]{width, height, zoomValue});
        return obj == null ? null : (Bitmap)obj;
    }

    public void dispose() {
        if (this.parent != null && this.getView() != null) {
            this.parent.removeView(this.getView());
        }
        if (this.mainControl.getReader() != null) {
            this.mainControl.getReader().abortReader();
        }
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
        if (this.mainControl != null) {
            this.mainControl.dispose();
            this.mainControl = null;
        }
        this.parent = null;
    }

    public int getCalloutLineWidth() {
        if (this.mainControl == null) {
            return 1;
        }
        return this.mainControl.getSysKit().getCalloutManager().getWidth();
    }

    public void setCalloutLineWidth(int width) {
        if (width < 1 || width > 10) {
            return;
        }
        if (this.mainControl != null) {
            this.mainControl.getSysKit().getCalloutManager().setWidth(width);
        }
    }

    public int getCalloutColor() {
        if (this.mainControl == null) {
            return -65536;
        }
        return this.mainControl.getSysKit().getCalloutManager().getColor();
    }

    public void setCalloutColor(byte alpha, byte red, byte green, byte blue) {
        if (this.mainControl != null) {
            int color2 = alpha << 24 | red << 16 & 0xFF0000 | green << 8 & 0xFF00 | blue & 0xFF;
            this.mainControl.getSysKit().getCalloutManager().setColor(color2);
        }
    }

    public int getDrawingMode() {
        if (this.mainControl == null) {
            return 0;
        }
        return this.mainControl.getSysKit().getCalloutManager().getDrawingMode();
    }

    public void setDrawingMode(int mode) {
        if (this.mainControl == null || mode < 0 || mode > 2) {
            return;
        }
        this.mainControl.getSysKit().getCalloutManager().setDrawingMode(mode);
        if (mode == 1) {
            this.parent.post(new Runnable(){

                @Override
                public void run() {
                    Application.this.mainControl.actionEvent(536870942, null);
                }
            });
        }
    }

    public boolean hasConvertingVectorgraph(int viewIndex) {
        return this.mainControl.getSysKit().getPictureManage().hasConvertingVectorgraph(viewIndex);
    }

    public void setIgnoreOriginalSize(boolean ignoreOriginalSize) {
        if (this.frame != null) {
            this.frame.setIgnoreOriginalSize(ignoreOriginalSize);
        }
    }

    public boolean isIgnoreOriginalSize() {
        if (this.frame != null) {
            return this.frame.isIgnoreOriginalSize();
        }
        return false;
    }

    public void setPageListViewMovingPosition(byte position) {
        if (this.frame != null) {
            this.frame.setPageListViewMovingPosition(position);
        }
    }

    public byte getPageListViewMovingPosition() {
        if (this.frame != null) {
            return this.frame.getPageListViewMovingPosition();
        }
        return 0;
    }
}

