/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.java.awt.geom;

import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.CubicCurve2D;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.PathIterator;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.QuadCurve2D;
import java.util.NoSuchElementException;

public class FlatteningPathIterator
implements PathIterator {
    static final int GROW_SIZE = 24;
    PathIterator src;
    double squareflat;
    int limit;
    double[] hold = new double[14];
    double curx;
    double cury;
    double movx;
    double movy;
    int holdType;
    int holdEnd;
    int holdIndex;
    int[] levels;
    int levelIndex;
    boolean done;

    public FlatteningPathIterator(PathIterator src, double flatness) {
        this(src, flatness, 10);
    }

    public FlatteningPathIterator(PathIterator src, double flatness, int limit) {
        if (flatness < 0.0) {
            throw new IllegalArgumentException("flatness must be >= 0");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit must be >= 0");
        }
        this.src = src;
        this.squareflat = flatness * flatness;
        this.limit = limit;
        this.levels = new int[limit + 1];
        this.next(false);
    }

    public double getFlatness() {
        return Math.sqrt(this.squareflat);
    }

    public int getRecursionLimit() {
        return this.limit;
    }

    @Override
    public int getWindingRule() {
        return this.src.getWindingRule();
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    void ensureHoldCapacity(int want) {
        if (this.holdIndex - want < 0) {
            int have = this.hold.length - this.holdIndex;
            int newsize = this.hold.length + 24;
            double[] newhold = new double[newsize];
            System.arraycopy(this.hold, this.holdIndex, newhold, this.holdIndex + 24, have);
            this.hold = newhold;
            this.holdIndex += 24;
            this.holdEnd += 24;
        }
    }

    @Override
    public void next() {
        this.next(true);
    }

    private void next(boolean doNext) {
        if (this.holdIndex >= this.holdEnd) {
            if (doNext) {
                this.src.next();
            }
            if (this.src.isDone()) {
                this.done = true;
                return;
            }
            this.holdType = this.src.currentSegment(this.hold);
            this.levelIndex = 0;
            this.levels[0] = 0;
        }
        switch (this.holdType) {
            case 0: 
            case 1: {
                this.curx = this.hold[0];
                this.cury = this.hold[1];
                if (this.holdType == 0) {
                    this.movx = this.curx;
                    this.movy = this.cury;
                }
                this.holdIndex = 0;
                this.holdEnd = 0;
                break;
            }
            case 4: {
                this.curx = this.movx;
                this.cury = this.movy;
                this.holdIndex = 0;
                this.holdEnd = 0;
                break;
            }
            case 2: {
                if (this.holdIndex >= this.holdEnd) {
                    this.holdIndex = this.hold.length - 6;
                    this.holdEnd = this.hold.length - 2;
                    this.hold[this.holdIndex + 0] = this.curx;
                    this.hold[this.holdIndex + 1] = this.cury;
                    this.hold[this.holdIndex + 2] = this.hold[0];
                    this.hold[this.holdIndex + 3] = this.hold[1];
                    this.hold[this.holdIndex + 4] = this.curx = this.hold[2];
                    this.hold[this.holdIndex + 5] = this.cury = this.hold[3];
                }
                int level = this.levels[this.levelIndex];
                while (level < this.limit && !(QuadCurve2D.getFlatnessSq(this.hold, this.holdIndex) < this.squareflat)) {
                    this.ensureHoldCapacity(4);
                    QuadCurve2D.subdivide(this.hold, this.holdIndex, this.hold, this.holdIndex - 4, this.hold, this.holdIndex);
                    this.holdIndex -= 4;
                    this.levels[this.levelIndex] = ++level;
                    ++this.levelIndex;
                    this.levels[this.levelIndex] = level;
                }
                this.holdIndex += 4;
                --this.levelIndex;
                break;
            }
            case 3: {
                if (this.holdIndex >= this.holdEnd) {
                    this.holdIndex = this.hold.length - 8;
                    this.holdEnd = this.hold.length - 2;
                    this.hold[this.holdIndex + 0] = this.curx;
                    this.hold[this.holdIndex + 1] = this.cury;
                    this.hold[this.holdIndex + 2] = this.hold[0];
                    this.hold[this.holdIndex + 3] = this.hold[1];
                    this.hold[this.holdIndex + 4] = this.hold[2];
                    this.hold[this.holdIndex + 5] = this.hold[3];
                    this.hold[this.holdIndex + 6] = this.curx = this.hold[4];
                    this.hold[this.holdIndex + 7] = this.cury = this.hold[5];
                }
                int level = this.levels[this.levelIndex];
                while (level < this.limit && !(CubicCurve2D.getFlatnessSq(this.hold, this.holdIndex) < this.squareflat)) {
                    this.ensureHoldCapacity(6);
                    CubicCurve2D.subdivide(this.hold, this.holdIndex, this.hold, this.holdIndex - 6, this.hold, this.holdIndex);
                    this.holdIndex -= 6;
                    this.levels[this.levelIndex] = ++level;
                    ++this.levelIndex;
                    this.levels[this.levelIndex] = level;
                }
                this.holdIndex += 6;
                --this.levelIndex;
            }
        }
    }

    @Override
    public int currentSegment(float[] coords) {
        if (this.isDone()) {
            throw new NoSuchElementException("flattening iterator out of bounds");
        }
        int type = this.holdType;
        if (type != 4) {
            coords[0] = (float)this.hold[this.holdIndex + 0];
            coords[1] = (float)this.hold[this.holdIndex + 1];
            if (type != 0) {
                type = 1;
            }
        }
        return type;
    }

    @Override
    public int currentSegment(double[] coords) {
        if (this.isDone()) {
            throw new NoSuchElementException("flattening iterator out of bounds");
        }
        int type = this.holdType;
        if (type != 4) {
            coords[0] = this.hold[this.holdIndex + 0];
            coords[1] = this.hold[this.holdIndex + 1];
            if (type != 0) {
                type = 1;
            }
        }
        return type;
    }
}

