/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.xls;

import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.ElementHandler;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.ElementPath;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.io.SAXReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationship;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationshipCollection;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.ZipPackage;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader.WorkbookReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader.shared.StyleReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader.shared.ThemeColorReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.SSReader;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.sheetProperty.Palette;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ColorUtil;
import com.ahmadullahpk.alldocumentreader.xs.system.AbortReaderError;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.StopReaderError;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;

public class XLSXReader
extends SSReader {
    private String filePath;
    private ZipPackage zipPackage;
    private Workbook book;
    private PackagePart packagePart;
    private int sharedStringIndex;
    private String key;
    private boolean searched;

    public XLSXReader(IControl control, String filePath) {
        this.control = control;
        this.filePath = filePath;
    }

    @Override
    public Object getModel() throws Exception {
        this.book = new Workbook(false);
        this.zipPackage = new ZipPackage(this.filePath);
        this.initPackagePart();
        this.processWorkbook();
        return this.book;
    }

    private void initPackagePart() throws Exception {
        PackageRelationship coreRel = this.zipPackage.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").getRelationship(0);
        if (!coreRel.getTargetURI().toString().equals("/xl/workbook.xml")) {
            throw new Exception("Format error");
        }
        this.packagePart = this.zipPackage.getPart(coreRel);
    }

    private void processWorkbook() throws Exception {
        this.getWorkBookSharedObjects();
        WorkbookReader.instance().read(this.zipPackage, this.packagePart, this.book, this);
    }

    private void getWorkBookSharedObjects() throws Exception {
        this.getPaletteColor();
        this.getThemeColor(this.packagePart);
        this.getStyles(this.packagePart);
        this.getSharedString(this.packagePart);
    }

    private void getPaletteColor() {
        Palette palette = new Palette();
        int index = 8;
        byte[] rgb = palette.getColor(index);
        while (rgb != null) {
            this.book.addColor(index++, ColorUtil.rgb(rgb[0], rgb[1], rgb[2]));
            rgb = palette.getColor(index);
        }
        palette.dispose();
        palette = null;
    }

    private void getThemeColor(PackagePart documentPart) throws Exception {
        if (documentPart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme").size() <= 0) {
            return;
        }
        PackageRelationship styleRel = documentPart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme").getRelationship(0);
        PackagePart themeParts = this.zipPackage.getPart(styleRel.getTargetURI());
        ThemeColorReader.instance().getThemeColor(themeParts, this.book);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSharedString(PackagePart documentPart) throws Exception {
        PackageRelationshipCollection sharedStringsRelCollection = documentPart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings");
        if (sharedStringsRelCollection.size() <= 0) {
            return;
        }
        PackageRelationship sharedStringsRel = sharedStringsRelCollection.getRelationship(0);
        PackagePart sharedStringsParts = this.zipPackage.getPart(sharedStringsRel.getTargetURI());
        this.sharedStringIndex = 0;
        SAXReader saxreader = new SAXReader();
        try {
            saxreader.addHandler("/sst/si", new SharedStringSaxHandler());
            InputStream in = sharedStringsParts.getInputStream();
            saxreader.read(in);
            in.close();
        }
        finally {
            saxreader.resetHandlers();
        }
    }

    private void getStyles(PackagePart documentPart) throws Exception {
        if (documentPart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles").size() <= 0) {
            return;
        }
        PackageRelationship styleRel = documentPart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles").getRelationship(0);
        PackagePart styleParts = this.zipPackage.getPart(styleRel.getTargetURI());
        StyleReader.instance().getWorkBookStyle(styleParts, this.book, this);
    }

    @Override
    public boolean searchContent(File file, String key) throws Exception {
        key = key.toLowerCase();
        this.zipPackage = new ZipPackage(file.getAbsolutePath());
        PackageRelationship coreRel = this.zipPackage.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").getRelationship(0);
        this.packagePart = this.zipPackage.getPart(coreRel);
        boolean hasSearched = this.searchContent_SharedString(this.packagePart, key) ? true : WorkbookReader.instance().searchContent(this.zipPackage, this, this.packagePart, key);
        this.dispose();
        return hasSearched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean searchContent_SharedString(PackagePart documentPart, String key) throws Exception {
        PackageRelationshipCollection sharedStringsRelCollection = documentPart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings");
        if (sharedStringsRelCollection.size() <= 0) {
            return false;
        }
        PackageRelationship sharedStringsRel = sharedStringsRelCollection.getRelationship(0);
        PackagePart sharedStringsParts = this.zipPackage.getPart(sharedStringsRel.getTargetURI());
        this.key = key;
        this.searched = false;
        SAXReader saxreader = new SAXReader();
        try {
            saxreader.addHandler("/sst/si", new SearchSharedStringSaxHandler());
            InputStream in = sharedStringsParts.getInputStream();
            saxreader.read(in);
            in.close();
        }
        catch (StopReaderError e) {
            boolean bl = true;
            return bl;
        }
        finally {
            saxreader.resetHandlers();
        }
        return this.searched;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.filePath = null;
        this.book = null;
        this.zipPackage = null;
        this.packagePart = null;
        this.key = null;
    }

    class SharedStringSaxHandler
    implements ElementHandler {
        SharedStringSaxHandler() {
        }

        @Override
        public void onStart(ElementPath elementPath) {
        }

        @Override
        public void onEnd(ElementPath elementPath) {
            if (XLSXReader.this.abortReader) {
                throw new AbortReaderError("abort Reader");
            }
            Element elem = elementPath.getCurrent();
            String name = elem.getName();
            if (name.equals("si")) {
                Element ele = elem.element("t");
                if (ele != null) {
                    XLSXReader.this.book.addSharedString(XLSXReader.this.sharedStringIndex, ele.getText());
                } else {
                    XLSXReader.this.book.addSharedString(XLSXReader.this.sharedStringIndex, elem);
                }
                ++XLSXReader.this.sharedStringIndex;
            }
            elem.detach();
        }
    }

    class SearchSharedStringSaxHandler
    implements ElementHandler {
        SearchSharedStringSaxHandler() {
        }

        @Override
        public void onStart(ElementPath elementPath) {
        }

        @Override
        public void onEnd(ElementPath elementPath) {
            if (XLSXReader.this.abortReader) {
                throw new AbortReaderError("abort Reader");
            }
            Element stringItem = elementPath.getCurrent();
            String name = stringItem.getName();
            if (name.equals("si")) {
                Element ele = stringItem.element("t");
                if (ele != null) {
                    if (ele.getText().toLowerCase().contains(XLSXReader.this.key)) {
                        XLSXReader.this.searched = true;
                    }
                } else {
                    Iterator iter1 = stringItem.elementIterator("r");
                    String str = "";
                    while (iter1.hasNext()) {
                        ele = (Element)iter1.next();
                        str = str + ele.element("t").getText();
                    }
                    if (str.toLowerCase().contains(XLSXReader.this.key)) {
                        XLSXReader.this.searched = true;
                    }
                }
            }
            stringItem.detach();
            if (XLSXReader.this.searched) {
                throw new StopReaderError("stop");
            }
        }
    }
}

