/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader.drawing;

import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.AutoShapeDataKit;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Line;
import com.ahmadullahpk.alldocumentreader.xs.fc.LineKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Document;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.io.SAXReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.ZipPackage;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader.drawing.DrawingReader;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.drawing.TextParagraph;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ColorUtil;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.ChartFactory;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.AbstractChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.ColumnBarChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.PointStyle;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.RoundChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.XYChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.CategorySeries;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.XYMultipleSeriesDataset;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.XYSeries;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.DefaultRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.SimpleSeriesRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.XYMultipleSeriesRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.XYSeriesRenderer;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ChartReader {
    private static final short AxisPosition_Bottom = 0;
    private static final short AxisPosition_Left = 1;
    private static final short AxisPosition_Right = 2;
    private static final short AxisPosition_Top = 3;
    private static final String[] themeIndex = new String[]{"accent1", "accent2", "accent3", "accent4", "accent5", "accent6"};
    private static final double[] tints = new double[]{-0.25, 0.0, 0.4, 0.6, 0.8, -0.5};
    private static ChartReader reader = new ChartReader();
    private Map<String, Integer> schemeColor;
    private short type;
    private Element chart;
    private boolean hasMaxX;
    private boolean hasMinX;
    private boolean hasMaxY;
    private boolean hasMinY;
    private double maxX;
    private double minX;
    private double maxY;
    private double minY;

    public static ChartReader instance() {
        return reader;
    }

    public AbstractChart read(IControl control, ZipPackage zipPackage, PackagePart chartPart, Map<String, Integer> schemeColor, byte appType) throws Exception {
        this.schemeColor = schemeColor;
        this.type = (short)10;
        this.chart = null;
        this.maxX = Double.MIN_VALUE;
        this.minX = Double.MAX_VALUE;
        this.maxY = Double.MIN_VALUE;
        this.minY = Double.MAX_VALUE;
        this.hasMaxX = false;
        this.hasMinX = false;
        this.hasMaxY = false;
        this.hasMinY = false;
        SAXReader saxreader = new SAXReader();
        InputStream in = chartPart.getInputStream();
        Document chartDoc = saxreader.read(in);
        in.close();
        Element root = chartDoc.getRootElement();
        BackgroundAndFill fill = null;
        Line line = null;
        Element spPr = root.element("spPr");
        if (spPr != null) {
            if (spPr.element("noFill") == null && (fill = AutoShapeDataKit.processBackground(control, zipPackage, chartPart, spPr, schemeColor)) == null) {
                fill = new BackgroundAndFill();
                fill.setFillType((byte)0);
                fill.setForegroundColor(-1);
            }
            if (spPr.element("ln") != null) {
                line = LineKit.createChartLine(control, zipPackage, chartPart, spPr.element("ln"), schemeColor);
            } else {
                line = new Line();
                lineFill = new BackgroundAndFill();
                lineFill.setFillType((byte)0);
                lineFill.setForegroundColor(-9145228);
                line.setBackgroundAndFill(lineFill);
                line.setLineWidth(1);
            }
        } else {
            fill = new BackgroundAndFill();
            fill.setFillType((byte)0);
            fill.setForegroundColor(-1);
            line = new Line();
            lineFill = new BackgroundAndFill();
            lineFill.setFillType((byte)0);
            lineFill.setForegroundColor(-9145228);
            line.setBackgroundAndFill(lineFill);
            line.setLineWidth(1);
        }
        float defaultFontSize = this.getTextSize(root.element("txPr"));
        AbstractChart abstractChart = this.buildAChart(root.element("chart"), defaultFontSize, appType);
        DefaultRenderer renderer = null;
        if (abstractChart instanceof XYChart) {
            Element plotArea = root.element("chart").element("plotArea");
            BackgroundAndFill plotAreaFill = null;
            Line plotAreaFrame = null;
            spPr = plotArea.element("spPr");
            if (spPr != null) {
                if (spPr.element("noFill") == null) {
                    plotAreaFill = AutoShapeDataKit.processBackground(control, zipPackage, chartPart, spPr, schemeColor);
                }
                plotAreaFrame = LineKit.createChartLine(control, zipPackage, chartPart, spPr.element("ln"), schemeColor);
            }
            renderer = ((XYChart)abstractChart).getRenderer();
            ((XYMultipleSeriesRenderer)renderer).setSeriesBackgroundColor(plotAreaFill);
            ((XYMultipleSeriesRenderer)renderer).setSeriesFrame(plotAreaFrame);
        } else if (abstractChart instanceof RoundChart) {
            renderer = ((RoundChart)abstractChart).getRenderer();
        }
        if (renderer != null) {
            renderer.setDefaultFontSize(defaultFontSize);
            renderer.setBackgroundAndFill(fill);
            renderer.setChartFrame(line);
        }
        this.dispose();
        return abstractChart;
    }

    private float getTextSize(Element txPr) {
        String sz;
        float fontSize = 12.0f;
        Element ele = txPr;
        if (ele != null && (ele = ele.element("p")) != null && (ele = ele.element("pPr")) != null && (ele = ele.element("defRPr")) != null && (sz = ele.attributeValue("sz")) != null && sz.length() > 0) {
            fontSize = (float)Integer.parseInt(sz) / 100.0f;
        }
        return fontSize;
    }

    private void processLegend(Element legend, DefaultRenderer renderer, AbstractChart abstractChart) {
        if (legend != null && renderer != null) {
            renderer.setShowLegend(true);
            int legendPos = 2;
            if (legend.element("legendPos") != null) {
                String val = legend.element("legendPos").attributeValue("val");
                if ("l".equalsIgnoreCase(val)) {
                    legendPos = 0;
                } else if ("t".equalsIgnoreCase(val)) {
                    legendPos = 1;
                } else if ("b".equalsIgnoreCase(val)) {
                    legendPos = 3;
                }
            }
            abstractChart.setLegendPosition((byte)legendPos);
            float fontSize = renderer.getDefaultFontSize();
            if (legend.element("txPr") != null) {
                fontSize = this.getTextSize(legend.element("txPr"));
            }
            renderer.setLegendTextSize(fontSize);
        }
    }

    private AbstractChart buildAChart(Element chartElement, float defaultFontSize, byte appType) {
        Element plotArea = chartElement.element("plotArea");
        DefaultRenderer renderer = null;
        XYMultipleSeriesDataset dataset = null;
        CategorySeries pieDataset = null;
        PointStyle[] styles = new PointStyle[]{PointStyle.DIAMOND, PointStyle.SQUARE, PointStyle.TRIANGLE, PointStyle.X, PointStyle.CIRCLE};
        this.getChartInfo(plotArea);
        AbstractChart abstractChart = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                renderer = this.buildXYMultipleSeriesRenderer(plotArea, defaultFontSize, appType);
                dataset = this.getXYMultipleSeriesDataset(this.chart, this.type, (XYMultipleSeriesRenderer)renderer);
                abstractChart = ChartFactory.getColumnBarChart(dataset, (XYMultipleSeriesRenderer)renderer, ColumnBarChart.Type.DEFAULT);
                break;
            }
            case 2: {
                renderer = this.buildXYMultipleSeriesRenderer(plotArea, defaultFontSize, appType);
                dataset = this.getXYMultipleSeriesDataset(this.chart, this.type, (XYMultipleSeriesRenderer)renderer, styles);
                ((XYMultipleSeriesRenderer)renderer).setYLabels(10);
                abstractChart = ChartFactory.getLineChart(dataset, (XYMultipleSeriesRenderer)renderer);
                break;
            }
            case 3: {
                renderer = this.buildDefaultRenderer();
                renderer.setZoomEnabled(true);
                pieDataset = this.buildCategoryDataset(this.chart, renderer);
                abstractChart = ChartFactory.getPieChart(pieDataset, renderer);
                break;
            }
            case 4: {
                renderer = this.buildXYMultipleSeriesRenderer(plotArea, defaultFontSize, appType);
                dataset = this.getXYMultipleSeriesDataset(this.chart, this.type, (XYMultipleSeriesRenderer)renderer, styles);
                ((XYMultipleSeriesRenderer)renderer).setXLabels(10);
                ((XYMultipleSeriesRenderer)renderer).setYLabels(10);
                for (int i = 0; i < renderer.getSeriesRendererCount(); ++i) {
                    ((XYSeriesRenderer)renderer.getSeriesRendererAt(i)).setFillPoints(true);
                }
                abstractChart = ChartFactory.getScatterChart(dataset, (XYMultipleSeriesRenderer)renderer);
                break;
            }
        }
        Element titleElement = chartElement.element("title");
        if (titleElement != null) {
            List<TextParagraph> title = this.getTitle(titleElement);
            String chartTitle = "";
            float fontSize = 0.0f;
            if (title != null && title.size() > 0) {
                for (int i = 0; i < title.size(); ++i) {
                    chartTitle = chartTitle + title.get(i).getTextRun();
                    if (title.get(i).getFont() == null) continue;
                    fontSize = Math.max(fontSize, (float)((int)title.get(i).getFont().getFontSize()));
                }
            }
            renderer.setShowChartTitle(true);
            if (fontSize == 0.0f) {
                fontSize = defaultFontSize;
            }
            renderer.setChartTitleTextSize(fontSize);
            if (chartTitle.length() == 0) {
                if (dataset != null) {
                    chartTitle = dataset != null && dataset.getSeriesCount() == 1 ? dataset.getSeriesAt(0).getTitle() : "Chart Title";
                } else if (pieDataset != null) {
                    chartTitle = pieDataset.getTitle();
                }
            }
            renderer.setChartTitle(chartTitle);
        } else {
            renderer.setShowChartTitle(false);
        }
        Element legend = chartElement.element("legend");
        if (legend != null) {
            this.processLegend(chartElement.element("legend"), renderer, abstractChart);
        } else {
            renderer.setShowLegend(false);
        }
        if (abstractChart != null) {
            abstractChart.setCategoryAxisTextColor(this.schemeColor.get("tx1"));
        }
        return abstractChart;
    }

    private List<TextParagraph> getTitle(Element titleElement) {
        if (titleElement != null && titleElement.element("tx") != null && titleElement.element("tx").element("rich") != null) {
            Element rich = titleElement.element("tx").element("rich");
            Element bodyPr = rich.element("bodyPr");
            short vertical = -1;
            if (bodyPr != null) {
                vertical = DrawingReader.getVerticalByString(bodyPr.attributeValue("anchor"));
            }
            Iterator iter = rich.elements("p").iterator();
            ArrayList<TextParagraph> paragraphs = new ArrayList<TextParagraph>();
            while (iter.hasNext()) {
                TextParagraph textParagraph = DrawingReader.getTextParagraph((Element)iter.next());
                if (textParagraph == null) continue;
                if (vertical > -1) {
                    textParagraph.setVerticalAlign(vertical);
                }
                paragraphs.add(textParagraph);
            }
            return paragraphs;
        }
        return null;
    }

    private int getColor(Element solidFillElement) {
        int color2 = -1;
        if (solidFillElement.element("srgbClr") != null) {
            Element clr = solidFillElement.element("srgbClr");
            String val = clr.attributeValue("val");
            if (val.length() > 6) {
                val = val.substring(val.length() - 6);
            }
            color2 = Integer.parseInt(val, 16);
            color2 = 0xFF000000 | color2;
        } else if (solidFillElement.element("schemeClr") != null) {
            Element clr = solidFillElement.element("schemeClr");
            color2 = this.schemeColor.get(clr.attributeValue("val"));
            if (clr.element("lumMod") != null) {
                double tint = (double)Integer.parseInt(clr.element("lumMod").attributeValue("val")) / 100000.0;
                tint = clr.element("lumOff") != null ? (double)Integer.parseInt(clr.element("lumOff").attributeValue("val")) / 100000.0 : (tint -= 1.0);
                color2 = ColorUtil.instance().getColorWithTint(color2, tint);
            }
        } else if (solidFillElement.element("sysClr") != null) {
            Element clr = solidFillElement.element("sysClr");
            color2 = Integer.parseInt(clr.attributeValue("lastClr"), 16);
            color2 = 0xFF000000 | color2;
        }
        return color2;
    }

    private void getChartInfo(Element plotArea) {
        if (plotArea.element("barChart") != null) {
            this.chart = plotArea.element("barChart");
            this.type = 1;
        } else if (plotArea.element("bar3DChart") != null) {
            this.chart = plotArea.element("bar3DChart");
            this.type = 1;
        } else if (plotArea.element("pieChart") != null) {
            this.chart = plotArea.element("pieChart");
            this.type = (short)3;
        } else if (plotArea.element("pie3DChart") != null) {
            this.chart = plotArea.element("pie3DChart");
            this.type = (short)3;
        } else if (plotArea.element("ofPieChart") != null) {
            this.chart = plotArea.element("ofPieChart");
            this.type = (short)3;
        } else if (plotArea.element("lineChart") != null) {
            this.chart = plotArea.element("lineChart");
            this.type = (short)2;
        } else if (plotArea.element("line3DChart") != null) {
            this.chart = plotArea.element("line3DChart");
            this.type = (short)2;
        } else if (plotArea.element("scatterChart") != null) {
            this.chart = plotArea.element("scatterChart");
            this.type = (short)4;
        } else if (plotArea.element("areaChart") != null) {
            this.chart = plotArea.element("areaChart");
            this.type = 0;
        } else if (plotArea.element("area3DChart") != null) {
            this.chart = plotArea.element("area3DChart");
            this.type = 0;
        } else if (plotArea.element("stockChart") != null) {
            this.chart = plotArea.element("stockChart");
            this.type = (short)5;
        } else if (plotArea.element("surfaceChart") != null) {
            this.chart = plotArea.element("surfaceChart");
            this.type = (short)6;
        } else if (plotArea.element("surface3DChart") != null) {
            this.chart = plotArea.element("surface3DChart");
            this.type = (short)6;
        } else if (plotArea.element("doughnutChart") != null) {
            this.chart = plotArea.element("doughnutChart");
            this.type = (short)7;
        } else if (plotArea.element("bubbleChart") != null) {
            this.chart = plotArea.element("bubbleChart");
            this.type = (short)4;
        } else if (plotArea.element("radarChart") != null) {
            this.chart = plotArea.element("radarChart");
            this.type = (short)9;
        }
    }

    private XYMultipleSeriesRenderer buildXYMultipleSeriesRenderer(Element plotArea, float defaultFontSize, byte appType) {
        int i;
        XYMultipleSeriesRenderer renderer = new XYMultipleSeriesRenderer();
        renderer.setXTitleTextSize(defaultFontSize);
        renderer.setYTitleTextSize(defaultFontSize);
        renderer.setLabelsTextSize(defaultFontSize);
        List<TextParagraph> xLabel = null;
        List<TextParagraph> yLabel = null;
        List valAxs = plotArea.elements("valAx");
        List catAxs = plotArea.elements("catAx");
        ArrayList<Element> eles = new ArrayList<Element>();
        for (i = 0; i < valAxs.size(); ++i) {
            eles.add((Element)valAxs.get(i));
        }
        for (i = 0; i < catAxs.size(); ++i) {
            eles.add((Element)catAxs.get(i));
        }
        for (i = 0; i < eles.size(); ++i) {
            Element axPos = ((Element)eles.get(i)).element("axPos");
            if (axPos == null) continue;
            short sAxpos = this.getAxisPosition(axPos);
            switch (sAxpos) {
                case 1: 
                case 2: {
                    yLabel = this.getTitle(((Element)eles.get(i)).element("title"));
                    if (((Element)eles.get(i)).element("majorGridlines") == null && ((Element)eles.get(i)).element("minorGridlines") == null) break;
                    renderer.setShowGridH(true);
                    break;
                }
                case 0: 
                case 3: {
                    xLabel = this.getTitle(((Element)eles.get(i)).element("title"));
                    if (((Element)eles.get(i)).element("majorGridlines") == null && ((Element)eles.get(i)).element("minorGridlines") == null) break;
                    renderer.setShowGridV(true);
                }
            }
            this.getMaxMinValue(((Element)eles.get(i)).element("scaling"), sAxpos);
        }
        if (xLabel != null && xLabel.size() > 0) {
            renderer.setXTitle(((TextParagraph)xLabel.get(0)).getTextRun());
        }
        if (yLabel != null && yLabel.size() > 0) {
            renderer.setYTitle(((TextParagraph)yLabel.get(0)).getTextRun());
        }
        renderer.setLabelsColor(this.schemeColor.get("tx1"));
        renderer.setGridColor(this.schemeColor.get("tx1"));
        renderer.setAxesColor(this.schemeColor.get("tx1"));
        return renderer;
    }

    private short getAxisPosition(Element axPos) {
        String val = null;
        if (axPos != null && (val = axPos.attributeValue("val")) != null) {
            if ("b".equalsIgnoreCase(val)) {
                return 0;
            }
            if ("l".equalsIgnoreCase(val)) {
                return 1;
            }
            if ("r".equalsIgnoreCase(val)) {
                return 2;
            }
            if ("t".equalsIgnoreCase(val)) {
                return 3;
            }
        }
        return 1;
    }

    private void getMaxMinValue(Element scaling, short axPos) {
        switch (axPos) {
            case 1: 
            case 2: {
                if (scaling.element("max") != null) {
                    this.hasMaxY = true;
                    this.maxY = Double.parseDouble(scaling.element("max").attributeValue("val"));
                }
                if (scaling.element("min") == null) break;
                this.hasMinY = true;
                this.minY = Double.parseDouble(scaling.element("min").attributeValue("val"));
                break;
            }
            case 0: 
            case 3: {
                if (scaling.element("max") != null) {
                    this.hasMaxX = true;
                    this.maxX = Double.parseDouble(scaling.element("max").attributeValue("val"));
                }
                if (scaling.element("min") == null) break;
                this.hasMinX = true;
                this.minX = Double.parseDouble(scaling.element("min").attributeValue("val"));
            }
        }
    }

    private String getSeriesTitle(Element seriesTextElement) {
        if (seriesTextElement == null) {
            return null;
        }
        if (seriesTextElement.element("strRef") != null) {
            Element stringCache = seriesTextElement.element("strRef").element("strCache");
            if (stringCache.element("pt") != null) {
                Element text = stringCache.element("pt").element("v");
                return text.getText();
            }
        } else if (seriesTextElement.element("v") != null) {
            return seriesTextElement.element("v").getText();
        }
        return null;
    }

    private void setSeriesRendererProp(XYMultipleSeriesRenderer renderer, Element series, PointStyle[] styles) {
        int seriesOrder = Integer.parseInt(series.element("order").attributeValue("val"));
        XYSeriesRenderer r = new XYSeriesRenderer();
        int index = seriesOrder % themeIndex.length;
        index = this.schemeColor.get(themeIndex[index]);
        index = ColorUtil.instance().getColorWithTint(index, tints[seriesOrder / themeIndex.length]);
        r.setColor(index);
        if (styles != null && styles.length > 0) {
            index = seriesOrder % (styles.length - 1);
            r.setPointStyle(styles[index]);
        }
        renderer.addSeriesRenderer(r);
        Element cache = null;
        boolean isNumCache = false;
        if (series.element("cat") != null) {
            if (series.element("cat").element("numRef") != null) {
                cache = series.element("cat").element("numRef").element("numCache");
                isNumCache = true;
            } else if (series.element("cat").element("strRef") != null) {
                cache = series.element("cat").element("strRef").element("strCache");
            }
        } else if (series.element("xVal") != null && series.element("xVal").element("strRef") != null) {
            cache = series.element("xVal").element("strRef").element("strCache");
        }
        if (cache != null) {
            Iterator iter = cache.elements("pt").iterator();
            index = 1;
            while (iter.hasNext()) {
                Element pt = (Element)iter.next();
                renderer.addXTextLabel(index++, pt.element("v").getText());
            }
        }
    }

    private Object getSeries(Element series, short chartType) {
        String seriesName = null;
        seriesName = this.getSeriesTitle(series.element("tx")) != null ? this.getSeriesTitle(series.element("tx")) : "Series " + (Integer.parseInt(series.element("order").attributeValue("val")) + 1);
        if (chartType != 4) {
            if (series.element("val") != null) {
                CategorySeries aSeries = new CategorySeries(seriesName);
                Element number = null;
                if (series.element("val").element("numRef") != null) {
                    number = series.element("val").element("numRef").element("numCache");
                } else if (series.element("val").element("numLit") != null) {
                    number = series.element("val").element("numLit");
                }
                for (Element numPoint : number.elements("pt")) {
                    double value = Double.parseDouble(numPoint.element("v").getText());
                    aSeries.add(value);
                }
                return aSeries;
            }
        } else {
            Element xNumber = null;
            Element yNumber = null;
            if (series.element("xVal") != null && series.element("xVal").element("numRef") != null) {
                xNumber = series.element("xVal").element("numRef").element("numCache");
            }
            if (series.element("yVal") != null) {
                if (series.element("yVal").element("numRef") != null) {
                    yNumber = series.element("yVal").element("numRef").element("numCache");
                } else if (series.element("yVal").element("numLit") != null) {
                    yNumber = series.element("yVal").element("numLit");
                }
            }
            if (xNumber != null && yNumber != null) {
                XYSeries aSeries = new XYSeries(seriesName);
                Iterator iterX = xNumber.elements("pt").iterator();
                Iterator iterY = yNumber.elements("pt").iterator();
                while (iterX.hasNext() && iterY.hasNext()) {
                    Element xNumPoint = (Element)iterX.next();
                    Element yNumPoint = (Element)iterY.next();
                    double valueX = Double.parseDouble(xNumPoint.element("v").getText());
                    double valueY = Double.parseDouble(yNumPoint.element("v").getText());
                    aSeries.add(valueX, valueY);
                }
                return aSeries;
            }
            if (yNumber != null) {
                CategorySeries aSeries = new CategorySeries(seriesName);
                for (Element yNumPoint : yNumber.elements("pt")) {
                    double valueY = Double.parseDouble(yNumPoint.element("v").getText());
                    aSeries.add(valueY);
                }
                return aSeries;
            }
        }
        return null;
    }

    private XYMultipleSeriesDataset getXYMultipleSeriesDataset(Element chart, short chartType, XYMultipleSeriesRenderer renderer) {
        return this.getXYMultipleSeriesDataset(chart, chartType, renderer, null);
    }

    private XYMultipleSeriesDataset getXYMultipleSeriesDataset(Element chart, short chartType, XYMultipleSeriesRenderer renderer, PointStyle[] styles) {
        XYMultipleSeriesDataset dataset = new XYMultipleSeriesDataset();
        List seriesList = chart.elements("ser");
        int seriesCount = seriesList.size();
        for (int i = 0; i < seriesCount; ++i) {
            this.setSeriesRendererProp(renderer, (Element)seriesList.get(i), styles);
            Object series = this.getSeries((Element)seriesList.get(i), chartType);
            if (series == null) {
                return null;
            }
            if (series instanceof CategorySeries) {
                dataset.addSeries(((CategorySeries)series).toXYSeries());
            } else if (series instanceof XYSeries) {
                dataset.addSeries((XYSeries)series);
            }
            if (!this.hasMaxY) {
                this.maxY = Math.max(this.maxY, dataset.getSeriesAt(i).getMaxY());
            }
            if (this.hasMinY) continue;
            this.minY = Math.min(this.minY, dataset.getSeriesAt(i).getMinY());
        }
        double xAxisMin = 2.147483647E9;
        double xAxisMax = -2.147483648E9;
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            xAxisMin = Math.min(xAxisMin, dataset.getSeriesAt(i).getMinX());
            xAxisMax = Math.max(xAxisMax, dataset.getSeriesAt(i).getMaxX());
        }
        if (this.hasMinX) {
            renderer.setXAxisMin(this.minX);
        } else if (chartType != 4) {
            renderer.setXAxisMin(0.5);
        } else {
            renderer.setXAxisMin(xAxisMin);
        }
        if (this.hasMaxX) {
            renderer.setXAxisMax(this.maxX);
        } else if (chartType != 4) {
            renderer.setXAxisMax(xAxisMax + 0.5);
        } else {
            renderer.setXAxisMax(xAxisMax);
        }
        if (Math.abs(this.minY - Double.MAX_VALUE) < (double)0.1f) {
            this.minY = 0.0;
        }
        if (Math.abs(this.maxY - Double.MIN_VALUE) < (double)0.1f) {
            this.maxY = 0.0;
        }
        renderer.setYAxisMin(this.minY);
        renderer.setYAxisMax(this.maxY);
        return dataset;
    }

    protected DefaultRenderer buildDefaultRenderer() {
        DefaultRenderer renderer = new DefaultRenderer();
        renderer.setShowGridH(true);
        renderer.setLabelsColor(this.schemeColor.get("tx1"));
        renderer.setAxesColor(this.schemeColor.get("tx1"));
        return renderer;
    }

    protected CategorySeries buildCategoryDataset(Element chart, DefaultRenderer renderer) {
        if (chart.element("ser") != null) {
            CategorySeries aSeries = new CategorySeries("");
            Element series = chart.element("ser");
            aSeries = series.element("tx") != null ? new CategorySeries(this.getSeriesTitle(series.element("tx"))) : new CategorySeries("");
            ArrayList<String> catList = new ArrayList<String>(10);
            if (series.element("cat") != null) {
                for (Element pt : series.element("cat").element("strRef").element("strCache").elements("pt")) {
                    catList.add(pt.element("v").getText());
                }
            }
            ArrayList<Double> valList = new ArrayList<Double>(10);
            if (series.element("val") != null) {
                for (Element pt : series.element("val").element("numRef").element("numCache").elements("pt")) {
                    valList.add(Double.parseDouble(pt.element("v").getText()));
                }
            }
            if (catList.size() > 0 && catList.size() == valList.size()) {
                for (int i = 0; i < catList.size(); ++i) {
                    r = new SimpleSeriesRenderer();
                    int color2 = i % themeIndex.length;
                    color2 = this.schemeColor.get(themeIndex[color2]);
                    color2 = ColorUtil.instance().getColorWithTint(color2, tints[i / themeIndex.length]);
                    r.setColor(color2);
                    renderer.addSeriesRenderer(r);
                    aSeries.add((String)catList.get(i), (Double)valList.get(i));
                }
            } else {
                for (int i = 0; i < valList.size(); ++i) {
                    r = new SimpleSeriesRenderer();
                    int color3 = i % themeIndex.length;
                    color3 = this.schemeColor.get(themeIndex[color3]);
                    color3 = ColorUtil.instance().getColorWithTint(color3, tints[i / themeIndex.length]);
                    r.setColor(color3);
                    renderer.addSeriesRenderer(r);
                    aSeries.add((Double)valList.get(i));
                }
            }
            return aSeries;
        }
        return null;
    }

    private void dispose() {
        this.schemeColor = null;
        this.chart = null;
    }
}

