/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ss.util;

import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.ICell;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.ICellStyle;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.IFont;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.IRow;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.Workbook;
import java.util.HashMap;
import java.util.Map;

public final class CellUtil {
    public static final String ALIGNMENT = "alignment";
    public static final String BORDER_BOTTOM = "borderBottom";
    public static final String BORDER_LEFT = "borderLeft";
    public static final String BORDER_RIGHT = "borderRight";
    public static final String BORDER_TOP = "borderTop";
    public static final String BOTTOM_BORDER_COLOR = "bottomBorderColor";
    public static final String DATA_FORMAT = "dataFormat";
    public static final String FILL_BACKGROUND_COLOR = "fillBackgroundColor";
    public static final String FILL_FOREGROUND_COLOR = "fillForegroundColor";
    public static final String FILL_PATTERN = "fillPattern";
    public static final String FONT = "font";
    public static final String HIDDEN = "hidden";
    public static final String INDENTION = "indention";
    public static final String LEFT_BORDER_COLOR = "leftBorderColor";
    public static final String LOCKED = "locked";
    public static final String RIGHT_BORDER_COLOR = "rightBorderColor";
    public static final String ROTATION = "rotation";
    public static final String TOP_BORDER_COLOR = "topBorderColor";
    public static final String VERTICAL_ALIGNMENT = "verticalAlignment";
    public static final String WRAP_TEXT = "wrapText";
    private static UnicodeMapping[] unicodeMappings = new UnicodeMapping[]{CellUtil.um("alpha", "\u03b1"), CellUtil.um("beta", "\u03b2"), CellUtil.um("gamma", "\u03b3"), CellUtil.um("delta", "\u03b4"), CellUtil.um("epsilon", "\u03b5"), CellUtil.um("zeta", "\u03b6"), CellUtil.um("eta", "\u03b7"), CellUtil.um("theta", "\u03b8"), CellUtil.um("iota", "\u03b9"), CellUtil.um("kappa", "\u03ba"), CellUtil.um("lambda", "\u03bb"), CellUtil.um("mu", "\u03bc"), CellUtil.um("nu", "\u03bd"), CellUtil.um("xi", "\u03be"), CellUtil.um("omicron", "\u03bf")};

    private CellUtil() {
    }

    public static IRow getRow(int rowIndex, Sheet sheet) {
        return null;
    }

    public static ICell getCell(IRow row, int columnIndex) {
        ICell cell = row.getCell(columnIndex);
        if (cell == null) {
            cell = row.createCell(columnIndex);
        }
        return cell;
    }

    public static ICell createCell(IRow row, int column, String value, ICellStyle style2) {
        return null;
    }

    public static ICell createCell(IRow row, int column, String value) {
        return CellUtil.createCell(row, column, value, null);
    }

    public static void setAlignment(ICell cell, Workbook workbook, short align) {
        CellUtil.setCellStyleProperty(cell, workbook, ALIGNMENT, align);
    }

    public static void setFont(ICell cell, Workbook workbook, IFont font) {
        CellUtil.setCellStyleProperty(cell, workbook, FONT, font.getIndex());
    }

    public static void setCellStyleProperty(ICell cell, Workbook workbook, String propertyName, Object propertyValue) {
    }

    private static Map<String, Object> getFormatProperties(ICellStyle style2) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        CellUtil.putShort(properties, ALIGNMENT, style2.getAlignment());
        CellUtil.putShort(properties, BORDER_BOTTOM, style2.getBorderBottom());
        CellUtil.putShort(properties, BORDER_LEFT, style2.getBorderLeft());
        CellUtil.putShort(properties, BORDER_RIGHT, style2.getBorderRight());
        CellUtil.putShort(properties, BORDER_TOP, style2.getBorderTop());
        CellUtil.putShort(properties, BOTTOM_BORDER_COLOR, style2.getBottomBorderColor());
        CellUtil.putShort(properties, DATA_FORMAT, style2.getDataFormat());
        CellUtil.putShort(properties, FILL_BACKGROUND_COLOR, style2.getFillBackgroundColor());
        CellUtil.putShort(properties, FILL_FOREGROUND_COLOR, style2.getFillForegroundColor());
        CellUtil.putShort(properties, FILL_PATTERN, style2.getFillPattern());
        CellUtil.putShort(properties, FONT, style2.getFontIndex());
        CellUtil.putBoolean(properties, HIDDEN, style2.getHidden());
        CellUtil.putShort(properties, INDENTION, style2.getIndention());
        CellUtil.putShort(properties, LEFT_BORDER_COLOR, style2.getLeftBorderColor());
        CellUtil.putBoolean(properties, LOCKED, style2.getLocked());
        CellUtil.putShort(properties, RIGHT_BORDER_COLOR, style2.getRightBorderColor());
        CellUtil.putShort(properties, ROTATION, style2.getRotation());
        CellUtil.putShort(properties, TOP_BORDER_COLOR, style2.getTopBorderColor());
        CellUtil.putShort(properties, VERTICAL_ALIGNMENT, style2.getVerticalAlignment());
        CellUtil.putBoolean(properties, WRAP_TEXT, style2.getWrapText());
        return properties;
    }

    private static void setFormatProperties(ICellStyle style2, Workbook workbook, Map<String, Object> properties) {
    }

    private static short getShort(Map<String, Object> properties, String name) {
        Object value = properties.get(name);
        if (value instanceof Short) {
            return (Short)value;
        }
        return 0;
    }

    private static boolean getBoolean(Map<String, Object> properties, String name) {
        Object value = properties.get(name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    private static void putShort(Map<String, Object> properties, String name, short value) {
        properties.put(name, value);
    }

    private static void putBoolean(Map<String, Object> properties, String name, boolean value) {
        properties.put(name, value);
    }

    public static ICell translateUnicodeValues(ICell cell) {
        String s = cell.getRichStringCellValue().getString();
        boolean foundUnicode = false;
        String lowerCaseStr = s.toLowerCase();
        for (int i = 0; i < unicodeMappings.length; ++i) {
            UnicodeMapping entry = unicodeMappings[i];
            String key = entry.entityName;
            if (lowerCaseStr.indexOf(key) == -1) continue;
            s = s.replaceAll(key, entry.resolvedValue);
            foundUnicode = true;
        }
        if (foundUnicode) {
            // empty if block
        }
        return cell;
    }

    private static UnicodeMapping um(String entityName, String resolvedValue) {
        return new UnicodeMapping(entityName, resolvedValue);
    }

    private static final class UnicodeMapping {
        public final String entityName;
        public final String resolvedValue;

        public UnicodeMapping(String pEntityName, String pResolvedValue) {
            this.entityName = "&" + pEntityName + ";";
            this.resolvedValue = pResolvedValue;
        }
    }
}

