/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ss.format;

import com.ahmadullahpk.alldocumentreader.xs.fc.ss.format.CellDateFormatter;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.format.CellElapsedFormatter;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.format.CellFormatter;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.format.CellGeneralFormatter;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.format.CellNumberFormatter;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.format.CellTextFormatter;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CellFormatType {
    GENERAL{

        @Override
        CellFormatter formatter(String pattern) {
            return new CellGeneralFormatter();
        }

        @Override
        boolean isSpecial(char ch) {
            return false;
        }
    }
    ,
    NUMBER{

        @Override
        boolean isSpecial(char ch) {
            return false;
        }

        @Override
        CellFormatter formatter(String pattern) {
            return new CellNumberFormatter(pattern);
        }
    }
    ,
    DATE{

        @Override
        boolean isSpecial(char ch) {
            return ch == '\'' || ch <= '\u007f' && Character.isLetter(ch);
        }

        @Override
        CellFormatter formatter(String pattern) {
            return new CellDateFormatter(pattern);
        }
    }
    ,
    ELAPSED{

        @Override
        boolean isSpecial(char ch) {
            return false;
        }

        @Override
        CellFormatter formatter(String pattern) {
            return new CellElapsedFormatter(pattern);
        }
    }
    ,
    TEXT{

        @Override
        boolean isSpecial(char ch) {
            return false;
        }

        @Override
        CellFormatter formatter(String pattern) {
            return new CellTextFormatter(pattern);
        }
    };


    abstract boolean isSpecial(char var1);

    abstract CellFormatter formatter(String var1);
}

