/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader;

import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Line;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.TableCell;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.TableShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.ZipPackage;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute.ParaAttr;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute.RunAttr;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute.SectionAttr;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.BackgroundReader;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectanglef;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGMaster;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGModel;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.tableStyle.TableCellBorders;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.tableStyle.TableCellStyle;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.tableStyle.TableStyle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IAttributeSet;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.ParagraphElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.SectionElement;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import java.util.List;

public class TableReader {
    public static final int DEFAULT_CELL_WIDTH = 100;
    public static final int DEFAULT_CELL_HEIGHT = 40;
    private static TableReader kit = new TableReader();

    public static TableReader instance() {
        return kit;
    }

    public TableShape getTable(IControl control, ZipPackage zipPackage, PackagePart packagePart, PGModel pgModel, PGMaster master, Element tbl, Rectangle rect) throws Exception {
        RunAttr.instance().setTable(true);
        TableShape table = null;
        Element tblGrid = tbl.element("tblGrid");
        if (tblGrid != null) {
            int t = 0;
            List gridCols = tblGrid.elements("gridCol");
            int[] colWidths = new int[gridCols.size()];
            for (Element gridCol : gridCols) {
                int colWidth = (int)((float)Integer.parseInt(gridCol.attributeValue("w")) * 96.0f / 914400.0f);
                if (colWidth > 0) {
                    colWidths[t++] = colWidth;
                    continue;
                }
                colWidths[t++] = 133;
            }
            t = 0;
            List trs = tbl.elements("tr");
            int[] rowHeights = new int[trs.size()];
            for (Element tr : trs) {
                int rowHeight = (int)((float)Integer.parseInt(tr.attributeValue("h")) * 96.0f / 914400.0f);
                if (rowHeight > 0) {
                    rowHeights[t++] = rowHeight;
                    continue;
                }
                rowHeights[t++] = 53;
            }
            table = new TableShape(rowHeights.length, colWidths.length);
            Element tblPr = tbl.element("tblPr");
            Element tableStyleId = tblPr.element("tableStyleId");
            TableStyle tableStyle = null;
            if (tableStyleId != null) {
                tableStyle = pgModel.getTableStyle(tableStyleId.getText());
                table.setFirstRow("1".equalsIgnoreCase(tblPr.attributeValue("firstRow")));
                table.setLastRow("1".equalsIgnoreCase(tblPr.attributeValue("lastRow")));
                table.setFirstCol("1".equalsIgnoreCase(tblPr.attributeValue("firstCol")));
                table.setLastCol("1".equalsIgnoreCase(tblPr.attributeValue("lastCol")));
                table.setBandRow("1".equalsIgnoreCase(tblPr.attributeValue("bandRow")));
                table.setBandCol("1".equalsIgnoreCase(tblPr.attributeValue("bandCol")));
            }
            this.processTable(control, zipPackage, packagePart, master, trs, rect, table, colWidths, rowHeights, tableStyle);
        }
        RunAttr.instance().setTable(false);
        return table;
    }

    private Line processLine(IControl control, ZipPackage zipPackage, PackagePart packagePart, PGMaster master, TableStyle tableStyle, Element ln, int styleColor) {
        try {
            BackgroundAndFill lineFill = null;
            int lineWidth = 1;
            boolean dash = false;
            if (ln != null && ln.element("noFill") == null) {
                Element prstDash;
                if (ln.attributeValue("w") != null) {
                    lineWidth = Math.round((float)Integer.parseInt(ln.attributeValue("w")) * 96.0f / 914400.0f);
                }
                if ((prstDash = ln.element("prstDash")) != null && !"solid".equalsIgnoreCase(prstDash.attributeValue("val"))) {
                    dash = true;
                }
                lineFill = BackgroundReader.instance().processBackground(control, zipPackage, packagePart, master, ln);
            } else {
                lineFill = new BackgroundAndFill();
                lineFill.setForegroundColor(styleColor);
            }
            Line line = new Line();
            line.setBackgroundAndFill(lineFill);
            line.setLineWidth(lineWidth);
            line.setDash(dash);
            return line;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void processTable(IControl control, ZipPackage zipPackage, PackagePart packagePart, PGMaster master, List<Element> trs, Rectangle rect, TableShape table, int[] colWidths, int[] rowHeights, TableStyle tableStyle) throws Exception {
        int i = 0;
        for (Element tr : trs) {
            int j = 0;
            List tcs = tr.elements("tc");
            for (Element tc : tcs) {
                if (tc.attribute("hMerge") == null && tc.attribute("vMerge") == null) {
                    int t;
                    int t2;
                    TableCell cell = new TableCell();
                    Rectanglef anchor = new Rectanglef(rect.x, rect.y, 0.0f, 0.0f);
                    for (t2 = 0; t2 < j; ++t2) {
                        anchor.setX(anchor.getX() + (float)colWidths[t2]);
                    }
                    for (t2 = 0; t2 < i; ++t2) {
                        anchor.setY(anchor.getY() + (float)rowHeights[t2]);
                    }
                    int w = colWidths[j];
                    int h = rowHeights[i];
                    if (tc.attribute("rowSpan") != null) {
                        int rowSpan = Integer.parseInt(tc.attributeValue("rowSpan"));
                        for (t = 1; t < rowSpan; ++t) {
                            h += rowHeights[i + t];
                        }
                    }
                    if (tc.attribute("gridSpan") != null) {
                        int gridSpan = Integer.parseInt(tc.attributeValue("gridSpan"));
                        for (t = 1; t < gridSpan; ++t) {
                            w += colWidths[j + t];
                        }
                    }
                    anchor.setWidth(w);
                    anchor.setHeight(h);
                    cell.setBounds(anchor);
                    TableCellStyle cellStyle = this.getTableCellBorders(tableStyle, i, j, table);
                    Element tcPr = tc.element("tcPr");
                    if (tcPr != null) {
                        Element temp = tcPr.element("lnL");
                        cell.setLeftLine(this.processLine(control, zipPackage, packagePart, master, tableStyle, temp, this.getTableCellLeftBorderColor(zipPackage, packagePart, master, tableStyle, cellStyle)));
                        temp = tcPr.element("lnR");
                        cell.setRightLine(this.processLine(control, zipPackage, packagePart, master, tableStyle, temp, this.getTableCellRightBorderColor(zipPackage, packagePart, master, tableStyle, cellStyle)));
                        temp = tcPr.element("lnT");
                        cell.setTopLine(this.processLine(control, zipPackage, packagePart, master, tableStyle, temp, this.getTableCellTopBorderColor(zipPackage, packagePart, master, tableStyle, cellStyle)));
                        temp = tcPr.element("lnB");
                        cell.setBottomLine(this.processLine(control, zipPackage, packagePart, master, tableStyle, temp, this.getTableCellBottomBorderColor(zipPackage, packagePart, master, tableStyle, cellStyle)));
                    } else if (cellStyle != null) {
                        cell.setLeftLine(this.processLine(control, zipPackage, packagePart, master, tableStyle, null, this.getTableCellLeftBorderColor(zipPackage, packagePart, master, tableStyle, cellStyle)));
                        cell.setRightLine(this.processLine(control, zipPackage, packagePart, master, tableStyle, null, this.getTableCellRightBorderColor(zipPackage, packagePart, master, tableStyle, cellStyle)));
                        cell.setTopLine(this.processLine(control, zipPackage, packagePart, master, tableStyle, null, this.getTableCellTopBorderColor(zipPackage, packagePart, master, tableStyle, cellStyle)));
                        cell.setBottomLine(this.processLine(control, zipPackage, packagePart, master, tableStyle, null, this.getTableCellBottomBorderColor(zipPackage, packagePart, master, tableStyle, cellStyle)));
                    } else {
                        Line line = this.processLine(control, zipPackage, packagePart, master, tableStyle, null, -16777216);
                        cell.setLeftLine(line);
                        cell.setRightLine(line);
                        cell.setTopLine(line);
                        cell.setBottomLine(line);
                    }
                    BackgroundAndFill fill = BackgroundReader.instance().processBackground(control, zipPackage, packagePart, master, tcPr);
                    if (fill == null && cellStyle != null) {
                        fill = this.getTableCellFill(control, zipPackage, packagePart, master, tableStyle, cellStyle);
                    }
                    cell.setBackgroundAndFill(fill);
                    TextBox textBox = new TextBox();
                    Rectangle r = new Rectangle((int)anchor.getX(), (int)anchor.getY(), (int)anchor.getWidth(), (int)anchor.getHeight());
                    textBox.setBounds(r);
                    if (tableStyle != null && (cellStyle == null || cellStyle.getFontAttributeSet() == null)) {
                        cellStyle = tableStyle.getWholeTable();
                    }
                    this.processCellSection(control, master, textBox, r, tc, cellStyle);
                    cell.setText(textBox);
                    table.addCell(i * colWidths.length + j, cell);
                }
                ++j;
            }
            ++i;
        }
    }

    private BackgroundAndFill getTableCellFill(IControl control, ZipPackage zipPackage, PackagePart packagePart, PGMaster master, TableStyle tableStyle, TableCellStyle cellStyle) {
        try {
            Element fill = cellStyle.getTableCellBgFill();
            if (fill == null) {
                fill = tableStyle.getWholeTable().getTableCellBgFill();
            }
            return BackgroundReader.instance().processBackground(control, zipPackage, packagePart, master, fill, true);
        }
        catch (Exception e) {
            return null;
        }
    }

    private int getTableCellLeftBorderColor(ZipPackage zipPackage, PackagePart packagePart, PGMaster master, TableStyle tableStyle, TableCellStyle cellStyle) {
        try {
            Element left = null;
            TableCellBorders borders = cellStyle.getTableCellBorders();
            if (borders == null) {
                borders = tableStyle.getWholeTable().getTableCellBorders();
                left = borders.getLeftBorder();
            } else {
                left = borders.getLeftBorder();
                if (left == null) {
                    left = tableStyle.getWholeTable().getTableCellBorders().getLeftBorder();
                }
            }
            return BackgroundReader.instance().getBackgroundColor(zipPackage, packagePart, master, left, true);
        }
        catch (Exception e) {
            return -16777216;
        }
    }

    private int getTableCellRightBorderColor(ZipPackage zipPackage, PackagePart packagePart, PGMaster master, TableStyle tableStyle, TableCellStyle cellStyle) {
        try {
            Element right = null;
            TableCellBorders borders = cellStyle.getTableCellBorders();
            if (borders == null) {
                borders = tableStyle.getWholeTable().getTableCellBorders();
                right = borders.getRightBorder();
            } else {
                right = borders.getRightBorder();
                if (right == null) {
                    right = tableStyle.getWholeTable().getTableCellBorders().getRightBorder();
                }
            }
            return BackgroundReader.instance().getBackgroundColor(zipPackage, packagePart, master, right, true);
        }
        catch (Exception e) {
            return -16777216;
        }
    }

    private int getTableCellTopBorderColor(ZipPackage zipPackage, PackagePart packagePart, PGMaster master, TableStyle tableStyle, TableCellStyle cellStyle) {
        try {
            Element top = null;
            TableCellBorders borders = cellStyle.getTableCellBorders();
            if (borders == null) {
                borders = tableStyle.getWholeTable().getTableCellBorders();
                top = borders.getTopBorder();
            } else {
                top = borders.getTopBorder();
                if (top == null) {
                    top = tableStyle.getWholeTable().getTableCellBorders().getTopBorder();
                }
            }
            return BackgroundReader.instance().getBackgroundColor(zipPackage, packagePart, master, top, true);
        }
        catch (Exception e) {
            return -16777216;
        }
    }

    private int getTableCellBottomBorderColor(ZipPackage zipPackage, PackagePart packagePart, PGMaster master, TableStyle tableStyle, TableCellStyle cellStyle) {
        try {
            Element bottom = null;
            TableCellBorders borders = cellStyle.getTableCellBorders();
            if (borders == null) {
                borders = tableStyle.getWholeTable().getTableCellBorders();
                bottom = borders.getBottomBorder();
            } else {
                bottom = borders.getBottomBorder();
                if (bottom == null) {
                    bottom = tableStyle.getWholeTable().getTableCellBorders().getBottomBorder();
                }
            }
            return BackgroundReader.instance().getBackgroundColor(zipPackage, packagePart, master, bottom, true);
        }
        catch (Exception e) {
            return -16777216;
        }
    }

    private TableCellStyle getTableCellBorders(TableStyle tableStyle, int row, int col, TableShape table) {
        TableCellStyle cellStyle = null;
        if (tableStyle == null) {
            return null;
        }
        if (table.isFirstRow() && table.isFirstCol()) {
            cellStyle = this.getTableCellBorders_FirstRowFirstColumn(tableStyle, row, col, table);
        } else if (table.isFirstRow() && !table.isFirstCol()) {
            cellStyle = this.getTableCellBorders_FirstRow(tableStyle, row, col, table);
        } else if (!table.isFirstRow() && table.isFirstCol()) {
            cellStyle = this.getTableCellBorders_FirstColumn(tableStyle, row, col, table);
        } else if (!table.isFirstRow() && !table.isFirstCol()) {
            cellStyle = this.getTableCellBorders_NotFirstRowFirstColumn(tableStyle, row, col, table);
        }
        return cellStyle;
    }

    private TableCellStyle getTableCellBorders_FirstRowFirstColumn(TableStyle tableStyle, int row, int col, TableShape table) {
        TableCellStyle cellStyle = null;
        if (row == 0) {
            cellStyle = tableStyle.getFirstRow();
        } else if (table.isLastRow() && row == table.getRowCount() - 1) {
            cellStyle = tableStyle.getLastRow();
        } else if (col == 0) {
            cellStyle = tableStyle.getFirstCol();
        } else if (table.isLastCol() && col == table.getColumnCount() - 1) {
            cellStyle = tableStyle.getLastCol();
        } else if (table.isBandRow()) {
            if (row % 2 != 0) {
                cellStyle = tableStyle.getBand1H();
            } else if (table.isBandCol() && col % 2 != 0) {
                cellStyle = tableStyle.getBand1V();
            }
        } else if (table.isBandCol() && col % 2 != 0) {
            cellStyle = tableStyle.getBand1V();
        }
        if (cellStyle == null) {
            cellStyle = tableStyle.getWholeTable();
        }
        return cellStyle;
    }

    private TableCellStyle getTableCellBorders_FirstRow(TableStyle tableStyle, int row, int col, TableShape table) {
        TableCellStyle cellStyle = null;
        if (row == 0) {
            cellStyle = tableStyle.getFirstRow();
        } else if (table.isLastRow() && row == table.getRowCount() - 1) {
            cellStyle = tableStyle.getLastRow();
        } else if (table.isLastCol() && col == table.getColumnCount() - 1) {
            cellStyle = tableStyle.getLastCol();
        } else if (table.isBandRow()) {
            if (row % 2 != 0) {
                cellStyle = tableStyle.getBand1H();
            } else if (table.isBandCol() && col % 2 == 0) {
                cellStyle = tableStyle.getBand1V();
            }
        } else if (table.isBandCol() && col % 2 == 0) {
            cellStyle = tableStyle.getBand1V();
        }
        if (cellStyle == null) {
            cellStyle = tableStyle.getWholeTable();
        }
        return cellStyle;
    }

    private TableCellStyle getTableCellBorders_FirstColumn(TableStyle tableStyle, int row, int col, TableShape table) {
        TableCellStyle cellStyle = null;
        if (table.isLastRow() && row == table.getRowCount() - 1) {
            cellStyle = tableStyle.getLastRow();
        } else if (col == 0) {
            cellStyle = tableStyle.getFirstCol();
        } else if (table.isLastCol() && col == table.getColumnCount() - 1) {
            cellStyle = tableStyle.getLastCol();
        } else if (table.isBandRow()) {
            if (row % 2 == 0) {
                cellStyle = tableStyle.getBand1H();
            } else if (table.isBandCol() && col % 2 != 0) {
                cellStyle = tableStyle.getBand1V();
            }
        } else if (table.isBandCol() && col % 2 != 0) {
            cellStyle = tableStyle.getBand1V();
        }
        if (cellStyle == null) {
            cellStyle = tableStyle.getWholeTable();
        }
        return cellStyle;
    }

    private TableCellStyle getTableCellBorders_NotFirstRowFirstColumn(TableStyle tableStyle, int row, int col, TableShape table) {
        TableCellStyle cellStyle = null;
        if (table.isLastRow() && row == table.getRowCount() - 1) {
            cellStyle = tableStyle.getLastRow();
        } else if (table.isLastCol() && col == table.getColumnCount() - 1) {
            cellStyle = tableStyle.getLastCol();
        } else if (table.isBandRow()) {
            if (row % 2 == 0) {
                cellStyle = tableStyle.getBand1H();
            } else if (table.isBandCol() && col % 2 == 0) {
                cellStyle = tableStyle.getBand1V();
            }
        } else if (table.isBandCol() && col % 2 == 0) {
            cellStyle = tableStyle.getBand1V();
        }
        if (cellStyle == null) {
            cellStyle = tableStyle.getWholeTable();
        }
        return cellStyle;
    }

    public void processCellSection(IControl control, PGMaster master, TextBox tb, Rectangle rect, Element tc, TableCellStyle cellStyle) {
        SectionElement secElem = new SectionElement();
        secElem.setStartOffset(0L);
        tb.setElement(secElem);
        IAttributeSet attr = secElem.getAttribute();
        AttrManage.instance().setPageWidth(attr, (int)((float)rect.width * 15.0f));
        AttrManage.instance().setPageHeight(attr, (int)((float)rect.height * 15.0f));
        int leftMargin = 144;
        int topMargin = 72;
        int rightMargin = 144;
        int bottomMargin = 72;
        Element temp = tc.element("txBody");
        if (temp != null) {
            Element wrap;
            SectionAttr.instance().setSectionAttribute(temp.element("bodyPr"), attr, null, null, true);
            String val = "";
            int verAlign = 0;
            boolean horAlign = false;
            Element tcPr = tc.element("tcPr");
            if (tcPr != null) {
                if (tcPr.attributeValue("marL") != null) {
                    leftMargin = (int)((float)Integer.parseInt(tcPr.attributeValue("marL")) * 96.0f / 914400.0f * 15.0f);
                }
                if (tcPr.attributeValue("marT") != null) {
                    topMargin = (int)((float)Integer.parseInt(tcPr.attributeValue("marT")) * 96.0f / 914400.0f * 15.0f);
                }
                if (tcPr.attributeValue("marR") != null) {
                    rightMargin = (int)((float)Integer.parseInt(tcPr.attributeValue("marR")) * 96.0f / 914400.0f * 15.0f);
                }
                if (tcPr.attributeValue("marB") != null) {
                    bottomMargin = (int)((float)Integer.parseInt(tcPr.attributeValue("marB")) * 96.0f / 914400.0f * 15.0f);
                }
                AttrManage.instance().setPageMarginTop(attr, topMargin);
                AttrManage.instance().setPageMarginBottom(attr, bottomMargin);
                AttrManage.instance().setPageMarginLeft(attr, leftMargin);
                AttrManage.instance().setPageMarginRight(attr, rightMargin);
                val = tcPr.attributeValue("anchor");
                if (val != null) {
                    if (val.equals("t")) {
                        verAlign = 0;
                    } else if (val.equals("ctr")) {
                        verAlign = 1;
                    } else if (val.equals("b")) {
                        verAlign = 2;
                    } else if (val.equals("just")) {
                        verAlign = 1;
                    } else if (val.equals("dist")) {
                        verAlign = 1;
                    }
                    AttrManage.instance().setPageVerticalAlign(attr, (byte)verAlign);
                }
                if ((val = tcPr.attributeValue("anchorCtr")) != null && val.equals("1")) {
                    AttrManage.instance().setPageHorizontalAlign(attr, (byte)1);
                }
            }
            if ((wrap = temp.element("bodyPr")) != null) {
                String value = wrap.attributeValue("wrap");
                tb.setWrapLine(value == null || "square".equalsIgnoreCase(value));
            }
            int offset = this.processParagraph(control, master, secElem, temp, cellStyle);
            secElem.setEndOffset(offset);
        }
    }

    public int processParagraph(IControl control, PGMaster master, SectionElement secElem, Element txBody, TableCellStyle cellStyle) {
        String val;
        Element normAutofit;
        int offset = 0;
        int lnSpcReduction = 0;
        Element bodyPr = txBody.element("bodyPr");
        if (bodyPr != null && (normAutofit = bodyPr.element("normAutofit")) != null && normAutofit.attribute("lnSpcReduction") != null && (val = normAutofit.attributeValue("lnSpcReduction")) != null && val.length() > 0) {
            lnSpcReduction = Integer.parseInt(val);
        }
        List ps = txBody.elements("p");
        for (int i = 0; i < ps.size(); ++i) {
            Element p = (Element)ps.get(i);
            ParagraphElement paraElem = new ParagraphElement();
            paraElem.setStartOffset(offset);
            ParaAttr.instance().setParaAttribute(control, p.element("pPr"), paraElem.getAttribute(), null, -1, -1, lnSpcReduction, true, false);
            IAttributeSet attrLayout = null;
            if (cellStyle != null) {
                attrLayout = cellStyle.getFontAttributeSet();
            }
            offset = RunAttr.instance().processRun(master, paraElem, p, attrLayout, offset, 100, -1);
            ParaAttr.instance().processParaWithPct(p.element("pPr"), paraElem.getAttribute());
            if (i == 0) {
                AttrManage.instance().setParaBefore(paraElem.getAttribute(), 0);
            } else if (i == ps.size() - 1) {
                AttrManage.instance().setParaAfter(paraElem.getAttribute(), 0);
            }
            paraElem.setEndOffset(offset);
            secElem.appendParagraph(paraElem, 0L);
        }
        return offset;
    }
}

