/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader;

import android.graphics.Color;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.IShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGMaster;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ColorUtil;
import java.util.List;

public class ReaderKit {
    private static ReaderKit kit = new ReaderKit();

    public static ReaderKit instance() {
        return kit;
    }

    public String getPlaceholderName(Element sp) {
        if (sp != null) {
            Element cNvPr;
            Element temp = null;
            String name = sp.getName();
            if (name.equals("sp")) {
                temp = sp.element("nvSpPr");
            } else if (name.equals("pic")) {
                temp = sp.element("nvPicPr");
            } else if (name.equals("graphicFrame")) {
                temp = sp.element("nvGraphicFramePr");
            } else if (name.equals("grpSp")) {
                temp = sp.element("nvGrpSpPr");
            }
            if (temp != null && (cNvPr = temp.element("cNvPr")) != null && cNvPr.attribute("name") != null) {
                return cNvPr.attributeValue("name");
            }
        }
        return null;
    }

    public String getPlaceholderType(Element sp) {
        if (sp != null) {
            Element ph;
            Element nvPr;
            Element temp = null;
            String name = sp.getName();
            if (name.equals("sp")) {
                temp = sp.element("nvSpPr");
            } else if (name.equals("pic")) {
                temp = sp.element("nvPicPr");
            } else if (name.equals("graphicFrame")) {
                temp = sp.element("nvGraphicFramePr");
            } else if (name.equals("grpSp")) {
                temp = sp.element("nvGrpSpPr");
            }
            if (temp != null && (nvPr = temp.element("nvPr")) != null && (ph = nvPr.element("ph")) != null && ph.attribute("type") != null) {
                return ph.attributeValue("type");
            }
        }
        return null;
    }

    public int getPlaceholderIdx(Element sp) {
        if (sp != null) {
            Element ph;
            Element nvPr;
            Element temp = null;
            String name = sp.getName();
            if (name.equals("sp")) {
                temp = sp.element("nvSpPr");
            } else if (name.equals("pic")) {
                temp = sp.element("nvPicPr");
            } else if (name.equals("graphicFrame")) {
                temp = sp.element("nvGraphicFramePr");
            } else if (name.equals("grpSp")) {
                temp = sp.element("nvGrpSpPr");
            }
            if (temp != null && (nvPr = temp.element("nvPr")) != null && (ph = nvPr.element("ph")) != null && ph.attributeValue("idx") != null) {
                return (int)Double.parseDouble(ph.attributeValue("idx"));
            }
        }
        return -1;
    }

    public Rectangle getShapeAnchor(Element xfrm, float zoomX, float zoomY) {
        if (xfrm != null) {
            Element ext;
            String val;
            Rectangle rect = new Rectangle();
            Element off = xfrm.element("off");
            if (off != null) {
                if (off.attribute("x") != null && (val = off.attributeValue("x")) != null && val.length() > 0) {
                    rect.x = this.isDecimal(val) ? (int)((float)Integer.parseInt(val) * zoomX * 96.0f / 914400.0f) : (int)((float)Integer.parseInt(val, 16) * zoomX * 96.0f / 914400.0f);
                }
                if (off.attribute("y") != null && (val = off.attributeValue("y")) != null && val.length() > 0) {
                    rect.y = this.isDecimal(val) ? (int)((float)Integer.parseInt(val) * zoomY * 96.0f / 914400.0f) : (int)((float)Integer.parseInt(val, 16) * zoomY * 96.0f / 914400.0f);
                }
            }
            if ((ext = xfrm.element("ext")) != null) {
                if (ext.attribute("cx") != null && (val = ext.attributeValue("cx")) != null && val.length() > 0) {
                    rect.width = this.isDecimal(val) ? (int)((float)Integer.parseInt(val) * zoomX * 96.0f / 914400.0f) : (int)((float)Integer.parseInt(val, 16) * zoomX * 96.0f / 914400.0f);
                }
                if (ext.attributeValue("cy") != null && (val = ext.attributeValue("cy")) != null && val.length() > 0) {
                    rect.height = this.isDecimal(val) ? (int)((float)Integer.parseInt(val) * zoomY * 96.0f / 914400.0f) : (int)((float)Integer.parseInt(val, 16) * zoomY * 96.0f / 914400.0f);
                }
            }
            return rect;
        }
        return null;
    }

    public Rectangle getChildShapeAnchor(Element xfrm, float zoomX, float zoomY) {
        if (xfrm != null) {
            Element ext;
            String val;
            Rectangle rect = new Rectangle();
            Element off = xfrm.element("chOff");
            if (off != null) {
                if (off.attribute("x") != null && (val = off.attributeValue("x")) != null && val.length() > 0) {
                    rect.x = this.isDecimal(val) ? (int)((float)Integer.parseInt(val) * zoomX * 96.0f / 914400.0f) : (int)((float)Integer.parseInt(val, 16) * zoomX * 96.0f / 914400.0f);
                }
                if (off.attribute("y") != null && (val = off.attributeValue("y")) != null && val.length() > 0) {
                    rect.y = this.isDecimal(val) ? (int)((float)Integer.parseInt(val) * zoomY * 96.0f / 914400.0f) : (int)((float)Integer.parseInt(val, 16) * zoomY * 96.0f / 914400.0f);
                }
            }
            if ((ext = xfrm.element("chExt")) != null) {
                if (ext.attribute("cx") != null && (val = ext.attributeValue("cx")) != null && val.length() > 0) {
                    rect.width = this.isDecimal(val) ? (int)((float)Integer.parseInt(val) * zoomX * 96.0f / 914400.0f) : (int)((float)Integer.parseInt(val, 16) * zoomX * 96.0f / 914400.0f);
                }
                if (ext.attributeValue("cy") != null && (val = ext.attributeValue("cy")) != null && val.length() > 0) {
                    rect.height = this.isDecimal(val) ? (int)((float)Integer.parseInt(val) * zoomY * 96.0f / 914400.0f) : (int)((float)Integer.parseInt(val, 16) * zoomY * 96.0f / 914400.0f);
                }
            }
            return rect;
        }
        return null;
    }

    public String getNotes(Element root) {
        Element spTree;
        Element cSld = root.element("cSld");
        if (cSld != null && (spTree = cSld.element("spTree")) != null) {
            List sps = spTree.elements("sp");
            for (Element sp : sps) {
                String txt;
                String type = this.getPlaceholderType(sp);
                if (!"body".equals(type)) continue;
                String notes = "";
                Element txBody = sp.element("txBody");
                if (txBody != null) {
                    List ps = txBody.elements("p");
                    for (Element p : ps) {
                        List rs = p.elements("r");
                        for (Element r : rs) {
                            Element t = r.element("t");
                            if (t == null) continue;
                            String text = t.getText();
                            notes = notes + text;
                        }
                        notes = notes + '\n';
                    }
                }
                if ((txt = notes.trim()).length() <= 0) continue;
                return txt;
            }
        }
        return null;
    }

    public int getColor(PGMaster master, Element solidFill) {
        return this.getColor(master, solidFill, false);
    }

    private int processColorAttribute(Element colorE, int color2, boolean isTableStyle) {
        String val;
        if (colorE.element("tint") != null) {
            color2 = isTableStyle ? ColorUtil.instance().getColorWithTint(color2, 1.0 - (double)Integer.parseInt(colorE.element("tint").attributeValue("val")) / 100000.0) : ColorUtil.instance().getColorWithTint(color2, (double)Integer.parseInt(colorE.element("tint").attributeValue("val")) / 100000.0);
        } else if (colorE.element("lumOff") != null) {
            color2 = ColorUtil.instance().getColorWithTint(color2, (double)Integer.parseInt(colorE.element("lumOff").attributeValue("val")) / 100000.0);
        } else if (colorE.element("lumMod") != null) {
            color2 = ColorUtil.instance().getColorWithTint(color2, (double)Integer.parseInt(colorE.element("lumMod").attributeValue("val")) / 100000.0 - 1.0);
        } else if (colorE.element("shade") != null) {
            color2 = ColorUtil.instance().getColorWithTint(color2, (double)(-Integer.parseInt(colorE.element("shade").attributeValue("val"))) / 200000.0);
        }
        if (colorE.element("alpha") != null && (val = colorE.element("alpha").attributeValue("val")) != null) {
            int alpha = (int)((float)Integer.parseInt(val) / 100000.0f * 255.0f);
            color2 = 0xFFFFFF & color2 | alpha << 24;
        }
        return color2;
    }

    public int getColor(PGMaster master, Element solidFill, boolean isTableStyle) {
        if (solidFill != null) {
            Element temp = solidFill.element("srgbClr");
            if (temp != null && temp.attribute("val") != null) {
                String val = temp.attributeValue("val");
                if (val != null && val.length() > 0) {
                    return this.processColorAttribute(temp, Color.parseColor((String)("#" + val)), isTableStyle);
                }
            } else {
                temp = solidFill.element("scrgbClr");
                if (temp != null) {
                    int r = Integer.parseInt(temp.attributeValue("r")) * 255 / 100;
                    int g = Integer.parseInt(temp.attributeValue("g")) * 255 / 100;
                    int b = Integer.parseInt(temp.attributeValue("b")) * 255 / 100;
                    return this.processColorAttribute(temp, ColorUtil.rgb(r, g, b), isTableStyle);
                }
                temp = solidFill.element("schemeClr");
                if (temp != null && temp.attribute("val") != null) {
                    String val = temp.attributeValue("val");
                    if (val != null && val.length() > 0) {
                        int color2 = -1;
                        if (master != null) {
                            color2 = master.getColor(val);
                        }
                        return this.processColorAttribute(temp, color2, isTableStyle);
                    }
                } else {
                    temp = solidFill.element("sysClr");
                    if (temp != null) {
                        String val = temp.attributeValue("lastClr");
                        if (val != null && val.length() > 0) {
                            return Color.parseColor((String)("#" + val));
                        }
                    } else {
                        temp = solidFill.element("prstClr");
                        if (temp != null) {
                            String val = temp.attributeValue("val");
                            if (val.contains("gray")) {
                                return -7829368;
                            }
                            if (val.contains("white")) {
                                return -1;
                            }
                            if (val.contains("red")) {
                                return -65536;
                            }
                            if (val.contains("green")) {
                                return -16711936;
                            }
                            if (val.contains("blue")) {
                                return -16776961;
                            }
                            if (val.contains("yellow")) {
                                return -256;
                            }
                            if (val.contains("cyan")) {
                                return -16711681;
                            }
                            return -16777216;
                        }
                    }
                }
            }
        }
        return -1;
    }

    public boolean isDecimal(String num) {
        String hexChars = "abcdefABCDEF";
        int len = hexChars.length();
        for (int index = 0; index < len; ++index) {
            if (num.indexOf(hexChars.charAt(index)) <= -1) continue;
            return false;
        }
        return true;
    }

    public boolean isUserDrawn(Element sp) {
        Element nvPr;
        Element temp = null;
        String name = sp.getName();
        if (name.equals("sp")) {
            temp = sp.element("nvSpPr");
        } else if (name.equals("pic")) {
            temp = sp.element("nvPicPr");
        } else if (name.equals("graphicFrame")) {
            temp = sp.element("nvGraphicFramePr");
        } else if (name.equals("grpSp")) {
            temp = sp.element("nvGrpSpPr");
        }
        if (temp != null && (nvPr = temp.element("nvPr")) != null) {
            String val;
            Element ph = nvPr.element("ph");
            if (ph == null) {
                return true;
            }
            if (nvPr.attribute("userDrawn") != null && (val = nvPr.attributeValue("userDrawn")) != null && val.length() > 0 && Integer.parseInt(val) > 0) {
                return true;
            }
        }
        return false;
    }

    public float[] getAnchorFitZoom(Element xfrm) {
        float[] zoom = new float[]{1.0f, 1.0f};
        if (xfrm != null) {
            String val;
            float grpWidth = 0.0f;
            float grpHeight = 0.0f;
            float childWidth = 0.0f;
            float childHeight = 0.0f;
            Element ext = xfrm.element("ext");
            if (ext != null) {
                if (ext.attribute("cx") != null && (val = ext.attributeValue("cx")) != null && val.length() > 0) {
                    grpWidth = this.isDecimal(val) ? (float)Integer.parseInt(val) : (float)Integer.parseInt(val, 16);
                }
                if (ext.attributeValue("cy") != null && (val = ext.attributeValue("cy")) != null && val.length() > 0) {
                    grpHeight = this.isDecimal(val) ? (float)Integer.parseInt(val) : (float)Integer.parseInt(val, 16);
                }
            }
            if ((ext = xfrm.element("chExt")) != null) {
                if (ext.attribute("cx") != null && (val = ext.attributeValue("cx")) != null && val.length() > 0) {
                    childWidth = this.isDecimal(val) ? (float)Integer.parseInt(val) : (float)Integer.parseInt(val, 16);
                }
                if (ext.attributeValue("cy") != null && (val = ext.attributeValue("cy")) != null && val.length() > 0) {
                    childHeight = this.isDecimal(val) ? (float)Integer.parseInt(val) : (float)Integer.parseInt(val, 16);
                }
            }
            if (childWidth != 0.0f && childHeight != 0.0f) {
                zoom[0] = grpWidth / childWidth;
                zoom[1] = grpHeight / childHeight;
            }
        }
        return zoom;
    }

    public void processRotation(Element spPr, IShape shape) {
        if (spPr != null) {
            this.processRotation(shape, spPr.element("xfrm"));
        }
    }

    public void processRotation(IShape shape, Element xfrm) {
        if (xfrm != null) {
            String val;
            if (xfrm.attribute("flipH") != null && (val = xfrm.attributeValue("flipH")) != null && val.length() > 0 && Integer.parseInt(val) == 1) {
                shape.setFlipHorizontal(true);
            }
            if (xfrm.attribute("flipV") != null && (val = xfrm.attributeValue("flipV")) != null && val.length() > 0 && Integer.parseInt(val) == 1) {
                shape.setFlipVertical(true);
            }
            if (xfrm.attribute("rot") != null && (val = xfrm.attributeValue("rot")) != null && val.length() > 0) {
                shape.setRotation(Float.parseFloat(val) / 60000.0f);
            }
        }
    }

    public boolean isHidden(Element sp) {
        Element cNvPr;
        Element temp = null;
        String name = sp.getName();
        if (name.equals("sp")) {
            temp = sp.element("nvSpPr");
        } else if (name.equals("pic")) {
            temp = sp.element("nvPicPr");
        } else if (name.equals("graphicFrame")) {
            temp = sp.element("nvGraphicFramePr");
        } else if (name.equals("grpSp")) {
            temp = sp.element("nvGrpSpPr");
        }
        return temp != null && (cNvPr = temp.element("cNvPr")) != null && cNvPr.attribute("hidden") != null && Integer.parseInt(cNvPr.attributeValue("hidden")) > 0;
    }
}

