/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader;

import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.TileShader;
import com.ahmadullahpk.alldocumentreader.xs.common.pictureefftect.PictureStretchInfo;
import com.ahmadullahpk.alldocumentreader.xs.fc.ShaderKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationship;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.ZipPackage;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.ReaderKit;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGMaster;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;

public class BackgroundReader {
    private static BackgroundReader bgReader = new BackgroundReader();

    public static BackgroundReader instance() {
        return bgReader;
    }

    public BackgroundAndFill getBackground(IControl control, ZipPackage zipPackage, PackagePart packagePart, PGMaster master, Element bg) throws Exception {
        if (bg != null) {
            Element bgPr = bg.element("bgPr");
            Element bgRef = bg.element("bgRef");
            if (bgRef != null) {
                BackgroundAndFill bgFill = new BackgroundAndFill();
                bgFill.setFillType((byte)0);
                bgFill.setForegroundColor(ReaderKit.instance().getColor(master, bgRef));
                return bgFill;
            }
            return this.processBackground(control, zipPackage, packagePart, master, bgPr);
        }
        return null;
    }

    public BackgroundAndFill processBackground(IControl control, ZipPackage zipPackage, PackagePart packagePart, PGMaster master, Element bgPr) throws Exception {
        return this.processBackground(control, zipPackage, packagePart, master, bgPr, false);
    }

    public BackgroundAndFill processBackground(IControl control, ZipPackage zipPackage, PackagePart packagePart, PGMaster master, Element bgPr, boolean isTableStyle) throws Exception {
        if (bgPr != null) {
            BackgroundAndFill bgFill = new BackgroundAndFill();
            Element fill = bgPr.element("solidFill");
            if (fill != null) {
                bgFill.setFillType((byte)0);
                bgFill.setForegroundColor(ReaderKit.instance().getColor(master, fill, isTableStyle));
                return bgFill;
            }
            fill = bgPr.element("blipFill");
            if (fill != null) {
                PackagePart picPart;
                PackageRelationship imageShip;
                String id2;
                Element blip = fill.element("blip");
                if (blip != null && blip.attribute("embed") != null && (id2 = blip.attributeValue("embed")) != null && (imageShip = packagePart.getRelationship(id2)) != null && (picPart = zipPackage.getPart(imageShip.getTargetURI())) != null) {
                    Element tile = fill.element("tile");
                    if (tile == null) {
                        Element fillRect;
                        bgFill.setFillType((byte)3);
                        Element stretch = fill.element("stretch");
                        if (stretch != null && (fillRect = stretch.element("fillRect")) != null) {
                            PictureStretchInfo stretchInfo = new PictureStretchInfo();
                            boolean validate = false;
                            String str = fillRect.attributeValue("l");
                            if (str != null) {
                                validate = true;
                                stretchInfo.setLeftOffset(Float.parseFloat(str) / 100000.0f);
                            }
                            if ((str = fillRect.attributeValue("r")) != null) {
                                validate = true;
                                stretchInfo.setRightOffset(Float.parseFloat(str) / 100000.0f);
                            }
                            if ((str = fillRect.attributeValue("t")) != null) {
                                validate = true;
                                stretchInfo.setTopOffset(Float.parseFloat(str) / 100000.0f);
                            }
                            if ((str = fillRect.attributeValue("b")) != null) {
                                validate = true;
                                stretchInfo.setBottomOffset(Float.parseFloat(str) / 100000.0f);
                            }
                            if (validate) {
                                bgFill.setStretch(stretchInfo);
                            }
                        }
                        bgFill.setPictureIndex(control.getSysKit().getPictureManage().addPicture(picPart));
                    } else {
                        String amt;
                        int index = control.getSysKit().getPictureManage().addPicture(picPart);
                        bgFill.setFillType((byte)2);
                        TileShader tileShader = ShaderKit.readTile(control.getSysKit().getPictureManage().getPicture(index), tile);
                        Element alphaModFix = blip.element("alphaModFix");
                        if (alphaModFix != null && (amt = alphaModFix.attributeValue("amt")) != null) {
                            tileShader.setAlpha(Math.round((float)Integer.parseInt(amt) / 100000.0f * 255.0f));
                        }
                        bgFill.setShader(tileShader);
                    }
                    return bgFill;
                }
            } else {
                fill = bgPr.element("gradFill");
                if (fill != null) {
                    Element gsLst = fill.element("gsLst");
                    if (gsLst != null) {
                        bgFill.setFillType(ShaderKit.getGradientType(fill));
                        bgFill.setShader(ShaderKit.readGradient(master, fill));
                        return bgFill;
                    }
                } else {
                    fill = bgPr.element("fillRef");
                    if (fill != null) {
                        bgFill.setFillType((byte)0);
                        bgFill.setForegroundColor(ReaderKit.instance().getColor(master, fill));
                        return bgFill;
                    }
                    fill = bgPr.element("pattFill");
                    if (fill != null) {
                        Element bgClr = fill.element("bgClr");
                        bgFill.setFillType((byte)0);
                        bgFill.setForegroundColor(ReaderKit.instance().getColor(master, bgClr));
                        return bgFill;
                    }
                }
            }
        }
        return null;
    }

    public int getBackgroundColor(ZipPackage zipPackage, PackagePart packagePart, PGMaster master, Element bgPr, boolean isTableStyle) throws Exception {
        if (bgPr != null) {
            Element fill = bgPr.element("solidFill");
            if (fill != null) {
                return ReaderKit.instance().getColor(master, fill, isTableStyle);
            }
            fill = bgPr.element("gradFill");
            if (fill != null) {
                Element gsLst = fill.element("gsLst");
                if (gsLst != null) {
                    return ReaderKit.instance().getColor(master, gsLst.element("gs"));
                }
            } else {
                fill = bgPr.element("fillRef");
                if (fill != null) {
                    return ReaderKit.instance().getColor(master, fill);
                }
                fill = bgPr.element("pattFill");
                if (fill != null) {
                    Element bgClr = fill.element("bgClr");
                    return ReaderKit.instance().getColor(master, bgClr);
                }
            }
        }
        return 0;
    }
}

