/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.ShapeKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherChildAnchorRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherClientAnchorRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSpgrRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.HWPFShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.HWPFShapeFactory;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;

public class HWPFShapeGroup
extends HWPFShape {
    public HWPFShapeGroup(EscherContainerRecord escherRecord, HWPFShape parent) {
        super(escherRecord, parent);
    }

    public Rectangle getCoordinates(float zoomX, float zoomY) {
        EscherSpgrRecord spgr;
        Rectangle anchor = null;
        EscherContainerRecord spContainer = (EscherContainerRecord)this.getSpContainer().getChild(0);
        if (spContainer != null && (spgr = (EscherSpgrRecord)ShapeKit.getEscherChild(spContainer, -4087)) != null) {
            anchor = new Rectangle();
            anchor.x = (int)((float)spgr.getRectX1() * zoomX * 96.0f / 914400.0f);
            anchor.y = (int)((float)spgr.getRectY1() * zoomY * 96.0f / 914400.0f);
            anchor.width = (int)((float)(spgr.getRectX2() - spgr.getRectX1()) * zoomX * 96.0f / 914400.0f);
            anchor.height = (int)((float)(spgr.getRectY2() - spgr.getRectY1()) * zoomY * 96.0f / 914400.0f);
        }
        return anchor;
    }

    public Rectangle getAnchor(float zoomX, float zoomY) {
        Rectangle anchor = null;
        EscherContainerRecord spContainer = (EscherContainerRecord)this.getSpContainer().getChild(0);
        if (spContainer != null) {
            EscherClientAnchorRecord clrec = (EscherClientAnchorRecord)ShapeKit.getEscherChild(spContainer, -4080);
            if (clrec == null) {
                EscherChildAnchorRecord rec = (EscherChildAnchorRecord)ShapeKit.getEscherChild(spContainer, -4081);
                if (rec != null) {
                    anchor = new Rectangle();
                    anchor.x = (int)((float)rec.getDx1() * zoomX * 96.0f / 914400.0f);
                    anchor.y = (int)((float)rec.getDy1() * zoomY * 96.0f / 914400.0f);
                    anchor.width = (int)((float)(rec.getDx2() - rec.getDx1()) * zoomX * 96.0f / 914400.0f);
                    anchor.height = (int)((float)(rec.getDy2() - rec.getDy1()) * zoomY * 96.0f / 914400.0f);
                }
            } else {
                anchor = new Rectangle();
                anchor.x = (int)((float)clrec.getCol1() * zoomX * 96.0f / 914400.0f);
                anchor.y = (int)((float)clrec.getFlag() * zoomY * 96.0f / 914400.0f);
                anchor.width = (int)((float)(clrec.getDx1() - clrec.getCol1()) * zoomX * 96.0f / 914400.0f);
                anchor.height = (int)((float)(clrec.getRow1() - clrec.getFlag()) * zoomY * 96.0f / 914400.0f);
            }
        }
        return anchor;
    }

    public float[] getShapeAnchorFit(Rectangle rect, float zoomX, float zoomY) {
        EscherSpgrRecord spgr;
        float[] zoom = new float[]{1.0f, 1.0f};
        EscherContainerRecord spContainer = (EscherContainerRecord)this.getSpContainer().getChild(0);
        if (spContainer != null && (spgr = (EscherSpgrRecord)ShapeKit.getEscherChild(spContainer, -4087)) != null) {
            float w = spgr.getRectX2() - spgr.getRectX1();
            float h = spgr.getRectY2() - spgr.getRectY1();
            if (w != 0.0f && h != 0.0f) {
                zoom[0] = (float)(rect.width * 914400) / 96.0f / zoomX / w;
                zoom[1] = (float)(rect.height * 914400) / 96.0f / zoomY / h;
            }
        }
        return zoom;
    }

    @Override
    public boolean getFlipHorizontal() {
        return ShapeKit.getGroupFlipHorizontal(this.getSpContainer());
    }

    @Override
    public boolean getFlipVertical() {
        return ShapeKit.getGroupFlipVertical(this.getSpContainer());
    }

    public int getGroupRotation() {
        return ShapeKit.getGroupRotation(this.getSpContainer());
    }

    public HWPFShape[] getShapes() {
        Iterator<EscherRecord> iter = this.getSpContainer().getChildIterator();
        if (iter.hasNext()) {
            iter.next();
        }
        ArrayList<HWPFShape> shapeList = new ArrayList<HWPFShape>();
        while (iter.hasNext()) {
            EscherRecord r = iter.next();
            if (!(r instanceof EscherContainerRecord)) continue;
            EscherContainerRecord container = (EscherContainerRecord)r;
            HWPFShape shape = HWPFShapeFactory.createShape(container, this);
            shapeList.add(shape);
        }
        HWPFShape[] shapes = shapeList.toArray(new HWPFShape[shapeList.size()]);
        return shapes;
    }

    public String getShapeName() {
        return ShapeKit.getShapeName(this.escherContainer);
    }
}

