/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.util.BitField;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.BitFieldFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.Internal;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

@Internal
public final class ParagraphHeight {
    private short infoField;
    private BitField fSpare = BitFieldFactory.getInstance(1);
    private BitField fUnk = BitFieldFactory.getInstance(2);
    private BitField fDiffLines = BitFieldFactory.getInstance(4);
    private BitField clMac = BitFieldFactory.getInstance(65280);
    private short reserved;
    private int dxaCol;
    private int dymLineOrHeight;

    public ParagraphHeight(byte[] buf, int offset) {
        this.infoField = LittleEndian.getShort(buf, offset);
        this.reserved = LittleEndian.getShort(buf, offset += 2);
        this.dxaCol = LittleEndian.getInt(buf, offset += 2);
        this.dymLineOrHeight = LittleEndian.getInt(buf, offset += 4);
    }

    public ParagraphHeight() {
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.toByteArray());
    }

    protected byte[] toByteArray() {
        byte[] buf = new byte[12];
        int offset = 0;
        LittleEndian.putShort(buf, offset, this.infoField);
        LittleEndian.putShort(buf, offset += 2, this.reserved);
        LittleEndian.putInt(buf, offset += 2, this.dxaCol);
        LittleEndian.putInt(buf, offset += 4, this.dymLineOrHeight);
        return buf;
    }

    public boolean equals(Object o) {
        ParagraphHeight ph = (ParagraphHeight)o;
        return this.infoField == ph.infoField && this.reserved == ph.reserved && this.dxaCol == ph.dxaCol && this.dymLineOrHeight == ph.dymLineOrHeight;
    }
}

