/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.TextPieceTable;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.sprm.SprmBuffer;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.Internal;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.io.IOException;
import java.util.LinkedList;

@Internal
public final class ComplexFileTable {
    private static final byte GRPPRL_TYPE = 1;
    private static final byte TEXT_PIECE_TABLE_TYPE = 2;
    protected TextPieceTable _tpt;
    private SprmBuffer[] _grpprls;

    public ComplexFileTable() {
        this._tpt = new TextPieceTable();
    }

    public ComplexFileTable(byte[] documentStream, byte[] tableStream, int offset, int fcMin) throws IOException {
        LinkedList<SprmBuffer> sprmBuffers = new LinkedList<SprmBuffer>();
        while (tableStream[offset] == 1) {
            short size = LittleEndian.getShort(tableStream, ++offset);
            byte[] bs = LittleEndian.getByteArray(tableStream, offset += 2, size);
            offset += size;
            SprmBuffer sprmBuffer = new SprmBuffer(bs, false, 0);
            sprmBuffers.add(sprmBuffer);
        }
        this._grpprls = sprmBuffers.toArray(new SprmBuffer[sprmBuffers.size()]);
        if (tableStream[offset] != 2) {
            throw new IOException("The text piece table is corrupted");
        }
        int pieceTableSize = LittleEndian.getInt(tableStream, ++offset);
        this._tpt = new TextPieceTable(documentStream, tableStream, offset += 4, pieceTableSize, fcMin);
    }

    public TextPieceTable getTextPieceTable() {
        return this._tpt;
    }

    public SprmBuffer[] getGrpprls() {
        return this._grpprls;
    }
}

