/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherBlipRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.PictureData;

public class HSSFPictureData
implements PictureData {
    public static final short MSOBI_WMF = 8544;
    public static final short MSOBI_EMF = 15680;
    public static final short MSOBI_PICT = 21536;
    public static final short MSOBI_PNG = 28160;
    public static final short MSOBI_JPEG = 18080;
    public static final short MSOBI_DIB = 31360;
    public static final short FORMAT_MASK = -16;
    private EscherBlipRecord blip;

    public HSSFPictureData(EscherBlipRecord blip) {
        this.blip = blip;
    }

    @Override
    public byte[] getData() {
        return this.blip.getPicturedata();
    }

    public int getFormat() {
        return this.blip.getRecordId() - -4072;
    }

    @Override
    public String suggestFileExtension() {
        switch (this.blip.getRecordId()) {
            case -4069: {
                return "wmf";
            }
            case -4070: {
                return "emf";
            }
            case -4068: {
                return "pict";
            }
            case -4066: {
                return "png";
            }
            case -4067: {
                return "jpeg";
            }
            case -4065: {
                return "dib";
            }
        }
        return "";
    }

    @Override
    public String getMimeType() {
        switch (this.blip.getRecordId()) {
            case -4069: {
                return "image/x-wmf";
            }
            case -4070: {
                return "image/x-emf";
            }
            case -4068: {
                return "image/x-pict";
            }
            case -4066: {
                return "image/png";
            }
            case -4067: {
                return "image/jpeg";
            }
            case -4065: {
                return "image/bmp";
            }
        }
        return "image/unknown";
    }
}

