/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.ptg.Ptg;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.InternalWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.NameCommentRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.NameRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.Name;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.AWorkbook;

public final class HSSFName
implements Name {
    private AWorkbook _book;
    private NameRecord _definedNameRec;
    private NameCommentRecord _commentRec;

    HSSFName(AWorkbook book, NameRecord name) {
        this(book, name, null);
    }

    public HSSFName(AWorkbook book, NameRecord name, NameCommentRecord comment) {
        this._book = book;
        this._definedNameRec = name;
        this._commentRec = comment;
    }

    @Override
    public String getSheetName() {
        int indexToExternSheet = this._definedNameRec.getExternSheetNumber();
        return this._book.getInternalWorkbook().findSheetNameFromExternSheet(indexToExternSheet);
    }

    @Override
    public String getNameName() {
        return this._definedNameRec.getNameText();
    }

    @Override
    public void setNameName(String nameName) {
        HSSFName.validateName(nameName);
        InternalWorkbook wb = this._book.getInternalWorkbook();
        this._definedNameRec.setNameText(nameName);
        int sheetNumber = this._definedNameRec.getSheetNumber();
        for (int i = wb.getNumNames() - 1; i >= 0; --i) {
            NameRecord rec = wb.getNameRecord(i);
            if (rec == this._definedNameRec || !rec.getNameText().equalsIgnoreCase(nameName) || sheetNumber != rec.getSheetNumber()) continue;
            String msg = "The " + (sheetNumber == 0 ? "workbook" : "sheet") + " already contains this name: " + nameName;
            this._definedNameRec.setNameText(nameName + "(2)");
            throw new IllegalArgumentException(msg);
        }
        if (this._commentRec != null) {
            String oldName = this._commentRec.getNameText();
            this._commentRec.setNameText(nameName);
            this._book.getInternalWorkbook().updateNameCommentRecordCache(this._commentRec);
        }
    }

    private static void validateName(String name) {
        if (name.length() == 0) {
            throw new IllegalArgumentException("Name cannot be blank");
        }
        char c = name.charAt(0);
        if (c != '_' && !Character.isLetter(c) || name.indexOf(32) != -1) {
            throw new IllegalArgumentException("Invalid name: '" + name + "'; Names must begin with a letter or underscore and not contain spaces");
        }
    }

    public String getReference() {
        return this.getRefersToFormula();
    }

    public void setReference(String ref) {
        this.setRefersToFormula(ref);
    }

    @Override
    public void setRefersToFormula(String formulaText) {
    }

    @Override
    public String getRefersToFormula() {
        return null;
    }

    public Ptg[] getRefersToFormulaDefinition() {
        if (this._definedNameRec.isFunctionName()) {
            throw new IllegalStateException("Only applicable to named ranges");
        }
        return this._definedNameRec.getNameDefinition();
    }

    @Override
    public boolean isDeleted() {
        Ptg[] ptgs = this._definedNameRec.getNameDefinition();
        return Ptg.doesFormulaReferToDeletedCell(ptgs);
    }

    @Override
    public boolean isFunctionName() {
        return this._definedNameRec.isFunctionName();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getClass().getName()).append(" [");
        sb.append(this._definedNameRec.getNameText());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void setSheetIndex(int index) {
        int lastSheetIx = this._book.getNumberOfSheets() - 1;
        if (index < -1 || index > lastSheetIx) {
            throw new IllegalArgumentException("Sheet index (" + index + ") is out of range" + (lastSheetIx == -1 ? "" : " (0.." + lastSheetIx + ")"));
        }
        this._definedNameRec.setSheetNumber(index + 1);
    }

    @Override
    public int getSheetIndex() {
        return this._definedNameRec.getSheetNumber() - 1;
    }

    @Override
    public String getComment() {
        if (this._commentRec != null && this._commentRec.getCommentText() != null && this._commentRec.getCommentText().length() > 0) {
            return this._commentRec.getCommentText();
        }
        return this._definedNameRec.getDescriptionText();
    }

    @Override
    public void setComment(String comment) {
        this._definedNameRec.setDescriptionText(comment);
        if (this._commentRec != null) {
            this._commentRec.setCommentText(comment);
        }
    }

    @Override
    public void setFunction(boolean value) {
        this._definedNameRec.setFunction(value);
    }

    public void dispose() {
        this._book = null;
        this._definedNameRec = null;
        this._commentRec = null;
    }
}

