/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.NumericValueEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.StringValueEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.ptg.IntPtg;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.ptg.NumberPtg;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.ptg.Ptg;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.util.NumberToTextConverter;

public final class NumberEval
implements NumericValueEval,
StringValueEval {
    public static final NumberEval ZERO = new NumberEval(0.0);
    private final double _value;
    private String _stringValue;

    public NumberEval(Ptg ptg) {
        if (ptg == null) {
            throw new IllegalArgumentException("ptg must not be null");
        }
        if (ptg instanceof IntPtg) {
            this._value = ((IntPtg)ptg).getValue();
        } else if (ptg instanceof NumberPtg) {
            this._value = ((NumberPtg)ptg).getValue();
        } else {
            throw new IllegalArgumentException("bad argument type (" + ptg.getClass().getName() + ")");
        }
    }

    public NumberEval(double value) {
        this._value = value;
    }

    @Override
    public double getNumberValue() {
        return this._value;
    }

    @Override
    public String getStringValue() {
        if (this._stringValue == null) {
            this._stringValue = NumberToTextConverter.toText(this._value);
        }
        return this._stringValue;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getClass().getName()).append(" [");
        sb.append(this.getStringValue());
        sb.append("]");
        return sb.toString();
    }
}

