/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.eventusermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.eventusermodel.HSSFRequest;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.eventusermodel.HSSFUserException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.RecordFactoryInputStream;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.DirectoryNode;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.DocumentInputStream;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.POIFSFileSystem;
import java.io.IOException;
import java.io.InputStream;

public class HSSFEventFactory {
    public void processWorkbookEvents(HSSFRequest req, POIFSFileSystem fs) throws IOException {
        this.processWorkbookEvents(req, fs.getRoot());
    }

    public void processWorkbookEvents(HSSFRequest req, DirectoryNode dir) throws IOException {
        DocumentInputStream in = dir.createDocumentInputStream("Workbook");
        this.processEvents(req, in);
    }

    public short abortableProcessWorkbookEvents(HSSFRequest req, POIFSFileSystem fs) throws IOException, HSSFUserException {
        return this.abortableProcessWorkbookEvents(req, fs.getRoot());
    }

    public short abortableProcessWorkbookEvents(HSSFRequest req, DirectoryNode dir) throws IOException, HSSFUserException {
        DocumentInputStream in = dir.createDocumentInputStream("Workbook");
        return this.abortableProcessEvents(req, in);
    }

    public void processEvents(HSSFRequest req, InputStream in) {
        try {
            this.genericProcessEvents(req, in);
        }
        catch (HSSFUserException hSSFUserException) {
            // empty catch block
        }
    }

    public short abortableProcessEvents(HSSFRequest req, InputStream in) throws HSSFUserException {
        return this.genericProcessEvents(req, in);
    }

    private short genericProcessEvents(HSSFRequest req, InputStream in) throws HSSFUserException {
        Record r;
        short userCode = 0;
        RecordFactoryInputStream recordStream = new RecordFactoryInputStream(in, false);
        while ((r = recordStream.nextRecord()) != null && (userCode = req.processRecord(r)) == 0) {
        }
        return userCode;
    }
}

