/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record;

import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.DefaultEscherRecordFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherBoolProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherDgRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRGBProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSimpleProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSpRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSpgrRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherTextboxRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.EscherTextboxWrapper;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordTypes;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public final class PPDrawing
extends RecordAtom {
    private byte[] _header = new byte[8];
    private long _type;
    private EscherRecord[] childRecords;
    private EscherTextboxWrapper[] textboxWrappers;
    private EscherDgRecord dg;

    public EscherRecord[] getEscherRecords() {
        return this.childRecords;
    }

    public EscherTextboxWrapper[] getTextboxWrappers() {
        return this.textboxWrappers;
    }

    protected PPDrawing(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._type = LittleEndian.getUShort(this._header, 2);
        byte[] contents = new byte[len];
        System.arraycopy(source, start, contents, 0, len);
        DefaultEscherRecordFactory erf = new DefaultEscherRecordFactory();
        Vector escherChildren = new Vector();
        this.findEscherChildren(erf, contents, 8, len - 8, escherChildren);
        this.childRecords = new EscherRecord[escherChildren.size()];
        for (int i = 0; i < this.childRecords.length; ++i) {
            this.childRecords[i] = (EscherRecord)escherChildren.get(i);
        }
        Vector textboxes = new Vector();
        this.findEscherTextboxRecord(this.childRecords, textboxes);
        this.textboxWrappers = new EscherTextboxWrapper[textboxes.size()];
        for (int i = 0; i < this.textboxWrappers.length; ++i) {
            this.textboxWrappers[i] = (EscherTextboxWrapper)textboxes.get(i);
        }
    }

    public PPDrawing() {
        LittleEndian.putUShort(this._header, 0, 15);
        LittleEndian.putUShort(this._header, 2, RecordTypes.PPDrawing.typeID);
        LittleEndian.putInt(this._header, 4, 0);
        this.textboxWrappers = new EscherTextboxWrapper[0];
        this.create();
    }

    private void findEscherChildren(DefaultEscherRecordFactory erf, byte[] source, int startPos, int lenToGo, Vector found) {
        int escherBytes = LittleEndian.getInt(source, startPos + 4) + 8;
        EscherRecord r = erf.createRecord(source, startPos);
        r.fillFields(source, startPos, erf);
        found.add(r);
        int size = r.getRecordSize();
        if (size != escherBytes) {
            size = escherBytes;
        }
        startPos += size;
        if ((lenToGo -= size) >= 8) {
            this.findEscherChildren(erf, source, startPos, lenToGo, found);
        }
    }

    private void findEscherTextboxRecord(EscherRecord[] toSearch, Vector found) {
        block0: for (int i = 0; i < toSearch.length; ++i) {
            if (toSearch[i] instanceof EscherTextboxRecord) {
                EscherTextboxRecord tbr = (EscherTextboxRecord)toSearch[i];
                EscherTextboxWrapper w = new EscherTextboxWrapper(tbr);
                found.add(w);
                if ("BinaryTagData".equals(toSearch[i].getRecordName())) {
                    w.setShapeId(toSearch[i].getRecordId());
                    continue;
                }
                for (int j = i; j >= 0; --j) {
                    if (!(toSearch[j] instanceof EscherSpRecord)) continue;
                    EscherSpRecord sp = (EscherSpRecord)toSearch[j];
                    w.setShapeId(sp.getShapeId());
                    continue block0;
                }
                continue;
            }
            if (!toSearch[i].isContainerRecord()) continue;
            List<EscherRecord> childrenL = toSearch[i].getChildRecords();
            EscherRecord[] children = new EscherRecord[childrenL.size()];
            childrenL.toArray(children);
            this.findEscherTextboxRecord(children, found);
        }
    }

    @Override
    public long getRecordType() {
        return this._type;
    }

    @Override
    public Record[] getChildRecords() {
        return null;
    }

    public void writeOut(OutputStream out) throws IOException {
        for (int i = 0; i < this.textboxWrappers.length; ++i) {
        }
        int newSize = 0;
        for (int i = 0; i < this.childRecords.length; ++i) {
            newSize += this.childRecords[i].getRecordSize();
        }
        LittleEndian.putInt(this._header, 4, newSize);
        out.write(this._header);
        byte[] b = new byte[newSize];
        int done = 0;
        for (int i = 0; i < this.childRecords.length; ++i) {
            int written = this.childRecords[i].serialize(done, b);
            done += written;
        }
        out.write(b);
    }

    private void create() {
        EscherContainerRecord dgContainer = new EscherContainerRecord();
        dgContainer.setRecordId((short)-4094);
        dgContainer.setOptions((short)15);
        EscherDgRecord dg = new EscherDgRecord();
        dg.setOptions((short)16);
        dg.setNumShapes(1);
        dgContainer.addChildRecord(dg);
        EscherContainerRecord spgrContainer = new EscherContainerRecord();
        spgrContainer.setOptions((short)15);
        spgrContainer.setRecordId((short)-4093);
        EscherContainerRecord spContainer = new EscherContainerRecord();
        spContainer.setOptions((short)15);
        spContainer.setRecordId((short)-4092);
        EscherSpgrRecord spgr = new EscherSpgrRecord();
        spgr.setOptions((short)1);
        spContainer.addChildRecord(spgr);
        EscherSpRecord sp = new EscherSpRecord();
        sp.setOptions((short)2);
        sp.setFlags(5);
        spContainer.addChildRecord(sp);
        spgrContainer.addChildRecord(spContainer);
        dgContainer.addChildRecord(spgrContainer);
        spContainer = new EscherContainerRecord();
        spContainer.setOptions((short)15);
        spContainer.setRecordId((short)-4092);
        sp = new EscherSpRecord();
        sp.setOptions((short)18);
        sp.setFlags(3072);
        spContainer.addChildRecord(sp);
        EscherOptRecord opt = new EscherOptRecord();
        opt.setRecordId((short)-4085);
        opt.addEscherProperty(new EscherRGBProperty(385, 0x8000000));
        opt.addEscherProperty(new EscherRGBProperty(387, 0x8000005));
        opt.addEscherProperty(new EscherSimpleProperty(403, 10064750));
        opt.addEscherProperty(new EscherSimpleProperty(404, 7778750));
        opt.addEscherProperty(new EscherBoolProperty(447, 0x120012));
        opt.addEscherProperty(new EscherBoolProperty(511, 524288));
        opt.addEscherProperty(new EscherSimpleProperty(772, 9));
        opt.addEscherProperty(new EscherSimpleProperty(831, 65537));
        spContainer.addChildRecord(opt);
        dgContainer.addChildRecord(spContainer);
        this.childRecords = new EscherRecord[]{dgContainer};
    }

    public void addTextboxWrapper(EscherTextboxWrapper txtbox) {
        EscherTextboxWrapper[] tw = new EscherTextboxWrapper[this.textboxWrappers.length + 1];
        System.arraycopy(this.textboxWrappers, 0, tw, 0, this.textboxWrappers.length);
        tw[this.textboxWrappers.length] = txtbox;
        this.textboxWrappers = tw;
    }

    public EscherDgRecord getEscherDgRecord() {
        if (this.dg == null) {
            EscherContainerRecord dgContainer = (EscherContainerRecord)this.childRecords[0];
            Iterator<EscherRecord> it = dgContainer.getChildIterator();
            while (it.hasNext()) {
                EscherRecord r = it.next();
                if (!(r instanceof EscherDgRecord)) continue;
                this.dg = (EscherDgRecord)r;
                break;
            }
        }
        return this.dg;
    }

    @Override
    public void dispose() {
        this._header = null;
        if (this.childRecords != null) {
            for (EscherRecord er : this.childRecords) {
                er.dispose();
            }
            this.childRecords = null;
        }
        if (this.textboxWrappers != null) {
            for (EscherTextboxWrapper etw : this.textboxWrappers) {
                etw.dispose();
            }
            this.textboxWrappers = null;
        }
        if (this.dg != null) {
            this.dg.dispose();
            this.dg = null;
        }
    }
}

