/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record;

import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.textproperties.AutoNumberTextProp;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.textproperties.TextProp;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.util.LinkedList;

public final class ExtendedParagraphAtom
extends RecordAtom {
    private static long _type = 4012L;
    public static TextProp[] extendedParagraphPropTypes = new TextProp[]{new TextProp(2, 0x1000000, "NumberingType"), new TextProp(2, 0x800000, "Start")};
    private byte[] _header;
    private LinkedList<AutoNumberTextProp> autoNumberList = new LinkedList();

    public ExtendedParagraphAtom(byte[] source, int start, int len) {
        if (len < 8) {
            len = 8;
        }
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        for (int pos = start + 8; pos < start + len && len >= 28 && len - pos >= 4; pos += 8) {
            AutoNumberTextProp paraProp = new AutoNumberTextProp();
            int mask = LittleEndian.getInt(source, pos);
            if (mask == 0x3000000) {
                mask >>= 1;
            }
            pos += 4;
            if (mask != 0) {
                pos = mask == 0x1800000 ? (pos += 2) : (pos += 4);
                for (int i = 0; i < extendedParagraphPropTypes.length; ++i) {
                    short val = 0;
                    if ((mask & extendedParagraphPropTypes[i].getMask()) == 0) break;
                    val = LittleEndian.getShort(source, pos);
                    if ("NumberingType".equals(extendedParagraphPropTypes[i].getName())) {
                        paraProp.setNumberingType(val);
                    } else if ("Start".equals(extendedParagraphPropTypes[i].getName())) {
                        paraProp.setStart(val);
                    }
                    pos += extendedParagraphPropTypes[i].getSize();
                }
                if (mask == 0x1800000) {
                    pos += 2;
                }
            }
            this.autoNumberList.add(paraProp);
        }
    }

    protected ExtendedParagraphAtom() {
    }

    @Override
    public LinkedList<AutoNumberTextProp> getExtendedParagraphPropList() {
        return this.autoNumberList;
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void dispose() {
        this._header = null;
        if (this.autoNumberList != null) {
            for (AutoNumberTextProp an : this.autoNumberList) {
                an.dispose();
            }
            this.autoNumberList.clear();
            this.autoNumberList = null;
        }
    }
}

