/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record;

import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.StringUtil;

public final class DocumentEncryptionAtom
extends RecordAtom {
    private byte[] _header = new byte[8];
    private static long _type = 12052L;
    private byte[] data;
    private String encryptionProviderName;

    protected DocumentEncryptionAtom(byte[] source, int start, int len) {
        int pos;
        System.arraycopy(source, start, this._header, 0, 8);
        this.data = new byte[len - 8];
        System.arraycopy(source, start + 8, this.data, 0, len - 8);
        int endPos = -1;
        for (pos = start + 8 + 44; pos < start + len && endPos < 0; pos += 2) {
            if (source[pos] != 0 || source[pos + 1] != 0) continue;
            endPos = pos;
        }
        pos = start + 8 + 44;
        int stringLen = (endPos - pos) / 2;
        this.encryptionProviderName = StringUtil.getFromUnicodeLE(source, pos, stringLen);
    }

    public int getKeyLength() {
        return this.data[28];
    }

    public String getEncryptionProviderName() {
        return this.encryptionProviderName;
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void dispose() {
        this._header = null;
        this.data = null;
        this.encryptionProviderName = null;
    }
}

