/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.ShapeKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherDgRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherDggRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Background;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.MasterSheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Shape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.ShapeFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.TextRun;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.TextShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.CString;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ColorSchemeAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.EscherTextboxWrapper;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExtendedParagraphAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.OEPlaceholderAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.PPDrawing;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordTypes;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RoundTripHFPlaceholder12;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.SheetContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.StyleTextPropAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.TextBytesAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.TextCharsAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.TextHeaderAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.usermodel.SlideShow;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public abstract class Sheet {
    private int _sheetNo;
    private SlideShow _slideShow;
    private Background _background;
    private Shape[] _shapes;
    private SheetContainer _container;

    public Sheet(SheetContainer container, int sheetNo) {
        this._container = container;
        this._sheetNo = sheetNo;
    }

    public abstract TextRun[] getTextRuns();

    public int _getSheetRefId() {
        return this._container.getSheetId();
    }

    public int _getSheetNumber() {
        return this._sheetNo;
    }

    protected PPDrawing getPPDrawing() {
        return this._container.getPPDrawing();
    }

    public SlideShow getSlideShow() {
        return this._slideShow;
    }

    public SheetContainer getSheetContainer() {
        return this._container;
    }

    public void setSlideShow(SlideShow ss) {
        this._slideShow = ss;
        TextRun[] trs = this.getTextRuns();
        if (trs != null) {
            for (int i = 0; i < trs.length; ++i) {
                trs[i].supplySlideShow(this._slideShow);
            }
        }
    }

    public static TextRun[] findTextRuns(PPDrawing ppdrawing) {
        Vector runsV = new Vector();
        EscherTextboxWrapper[] wrappers = ppdrawing.getTextboxWrappers();
        block0: for (int i = 0; i < wrappers.length; ++i) {
            int s1 = runsV.size();
            RecordContainer.handleParentAwareRecords(wrappers[i]);
            Sheet.findTextRuns(wrappers[i].getChildRecords(), runsV);
            int s2 = runsV.size();
            if (s2 == s1) continue;
            TextRun t = (TextRun)runsV.get(runsV.size() - 1);
            t.setShapeId(wrappers[i].getShapeId());
            boolean find = false;
            for (int j = i - 1; j >= 0; --j) {
                if (wrappers[j].getShapeId() == 5003) {
                    Record[] records = wrappers[j].getChildRecords();
                    for (int n = 0; n < records.length; ++n) {
                        if (!(records[0] instanceof ExtendedParagraphAtom)) continue;
                        find = true;
                        t.setExtendedParagraphAtom((ExtendedParagraphAtom)records[n]);
                        break;
                    }
                }
                if (find) continue block0;
            }
        }
        TextRun[] runs = new TextRun[runsV.size()];
        for (int i = 0; i < runs.length; ++i) {
            runs[i] = (TextRun)runsV.get(i);
        }
        return runs;
    }

    protected static void findTextRuns(Record[] records, Vector found) {
        int slwtIndex = 0;
        for (int i = 0; i < records.length - 1; ++i) {
            if (!(records[i] instanceof TextHeaderAtom)) continue;
            TextRun trun = null;
            TextHeaderAtom tha = (TextHeaderAtom)records[i];
            StyleTextPropAtom stpa = null;
            if (i < records.length - 2 && records[i + 2] instanceof StyleTextPropAtom) {
                stpa = (StyleTextPropAtom)records[i + 2];
            }
            if (records[i + 1] instanceof TextCharsAtom) {
                TextCharsAtom tca = (TextCharsAtom)records[i + 1];
                trun = new TextRun(tha, tca, stpa);
            } else if (records[i + 1] instanceof TextBytesAtom) {
                TextBytesAtom tba = (TextBytesAtom)records[i + 1];
                trun = new TextRun(tha, tba, stpa);
            } else if (records[i + 1].getRecordType() != 4001L && records[i + 1].getRecordType() != 4010L) {
                System.err.println("Found a TextHeaderAtom not followed by a TextBytesAtom or TextCharsAtom: Followed by " + records[i + 1].getRecordType());
            }
            if (trun != null) {
                ArrayList<Record> lst = new ArrayList<Record>();
                for (int j = i; !(j >= records.length || j > i && records[j] instanceof TextHeaderAtom); ++j) {
                    lst.add(records[j]);
                }
                Record[] recs = new Record[lst.size()];
                lst.toArray(recs);
                trun._records = recs;
                trun.setIndex(slwtIndex);
                found.add(trun);
                ++i;
            }
            ++slwtIndex;
        }
    }

    public Shape[] getShapes() {
        if (this._shapes != null) {
            return this._shapes;
        }
        PPDrawing ppdrawing = this.getPPDrawing();
        EscherContainerRecord dg = (EscherContainerRecord)ppdrawing.getEscherRecords()[0];
        EscherContainerRecord spgr = null;
        Iterator<EscherRecord> it = dg.getChildIterator();
        while (it.hasNext()) {
            EscherRecord rec = it.next();
            if (rec.getRecordId() != -4093) continue;
            spgr = (EscherContainerRecord)rec;
            break;
        }
        if (spgr == null) {
            throw new IllegalStateException("spgr not found");
        }
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        Iterator<EscherRecord> it2 = spgr.getChildIterator();
        if (it2.hasNext()) {
            it2.next();
        }
        while (it2.hasNext()) {
            EscherContainerRecord sp = (EscherContainerRecord)it2.next();
            Shape sh = ShapeFactory.createShape(sp, null);
            sh.setSheet(this);
            shapes.add(sh);
        }
        this._shapes = new Shape[shapes.size()];
        shapes.toArray(this._shapes);
        return this._shapes;
    }

    public void addShape(Shape shape) {
        PPDrawing ppdrawing = this.getPPDrawing();
        EscherContainerRecord dgContainer = (EscherContainerRecord)ppdrawing.getEscherRecords()[0];
        EscherContainerRecord spgr = (EscherContainerRecord)ShapeKit.getEscherChild(dgContainer, -4093);
        spgr.addChildRecord(shape.getSpContainer());
        shape.setSheet(this);
        shape.setShapeId(this.allocateShapeId());
        shape.afterInsert(this);
    }

    public int allocateShapeId() {
        EscherDggRecord dgg = this._slideShow.getDocumentRecord().getPPDrawingGroup().getEscherDggRecord();
        EscherDgRecord dg = this._container.getPPDrawing().getEscherDgRecord();
        dgg.setNumShapesSaved(dgg.getNumShapesSaved() + 1);
        for (int i = 0; i < dgg.getFileIdClusters().length; ++i) {
            EscherDggRecord.FileIdCluster c = dgg.getFileIdClusters()[i];
            if (c.getDrawingGroupId() != dg.getDrawingGroupId() || c.getNumShapeIdsUsed() == 1024) continue;
            int result = c.getNumShapeIdsUsed() + 1024 * (i + 1);
            c.incrementShapeId();
            dg.setNumShapes(dg.getNumShapes() + 1);
            dg.setLastMSOSPID(result);
            if (result >= dgg.getShapeIdMax()) {
                dgg.setShapeIdMax(result + 1);
            }
            return result;
        }
        dgg.addCluster(dg.getDrawingGroupId(), 0, false);
        dgg.getFileIdClusters()[dgg.getFileIdClusters().length - 1].incrementShapeId();
        dg.setNumShapes(dg.getNumShapes() + 1);
        int result = 1024 * dgg.getFileIdClusters().length;
        dg.setLastMSOSPID(result);
        if (result >= dgg.getShapeIdMax()) {
            dgg.setShapeIdMax(result + 1);
        }
        return result;
    }

    public boolean removeShape(Shape shape) {
        PPDrawing ppdrawing = this.getPPDrawing();
        EscherContainerRecord dg = (EscherContainerRecord)ppdrawing.getEscherRecords()[0];
        EscherContainerRecord spgr = null;
        Iterator<EscherRecord> it = dg.getChildIterator();
        while (it.hasNext()) {
            EscherRecord rec = it.next();
            if (rec.getRecordId() != -4093) continue;
            spgr = (EscherContainerRecord)rec;
            break;
        }
        if (spgr == null) {
            return false;
        }
        List<EscherRecord> lst = spgr.getChildRecords();
        boolean result = lst.remove(shape.getSpContainer());
        spgr.setChildRecords(lst);
        return result;
    }

    public void onCreate() {
    }

    public abstract MasterSheet getMasterSheet();

    public ColorSchemeAtom getColorScheme() {
        return this._container.getColorScheme();
    }

    public Background getBackground() {
        if (this._background == null) {
            PPDrawing ppdrawing = this.getPPDrawing();
            EscherContainerRecord dg = (EscherContainerRecord)ppdrawing.getEscherRecords()[0];
            EscherContainerRecord spContainer = null;
            Iterator<EscherRecord> it = dg.getChildIterator();
            while (it.hasNext()) {
                EscherRecord rec = it.next();
                if (rec.getRecordId() != -4092) continue;
                spContainer = (EscherContainerRecord)rec;
                break;
            }
            if (spContainer != null) {
                this._background = new Background(spContainer, null);
                this._background.setSheet(this);
            }
        }
        return this._background;
    }

    protected void onAddTextShape(TextShape shape) {
    }

    public TextShape getPlaceholderByTextType(int type) {
        Shape[] shape = this.getShapes();
        for (int i = 0; i < shape.length; ++i) {
            TextShape tx;
            TextRun run;
            if (!(shape[i] instanceof TextShape) || (run = (tx = (TextShape)shape[i]).getTextRun()) == null || run.getRunType() != type) continue;
            return tx;
        }
        return null;
    }

    public TextShape getPlaceholder(int type) {
        Shape[] shape = this.getShapes();
        for (int i = 0; i < shape.length; ++i) {
            if (!(shape[i] instanceof TextShape)) continue;
            TextShape tx = (TextShape)shape[i];
            int placeholderId = 0;
            OEPlaceholderAtom oep = tx.getPlaceholderAtom();
            if (oep != null) {
                placeholderId = oep.getPlaceholderId();
            } else {
                RoundTripHFPlaceholder12 hldr = (RoundTripHFPlaceholder12)tx.getClientDataRecord(RecordTypes.RoundTripHFPlaceholder12.typeID);
                if (hldr != null) {
                    placeholderId = hldr.getPlaceholderId();
                }
            }
            if (placeholderId != type) continue;
            return tx;
        }
        return null;
    }

    public String getProgrammableTag() {
        CString binaryTag;
        RecordContainer progBinaryTag;
        String tag = null;
        RecordContainer progTags = (RecordContainer)this.getSheetContainer().findFirstOfType(RecordTypes.SlideProgTagsContainer.typeID);
        if (progTags != null && (progBinaryTag = (RecordContainer)progTags.findFirstOfType(RecordTypes.SlideProgBinaryTagContainer.typeID)) != null && (binaryTag = (CString)progBinaryTag.findFirstOfType(RecordTypes.CString.typeID)) != null) {
            tag = binaryTag.getText();
        }
        return tag;
    }

    public void dispose() {
        this._slideShow = null;
        if (this._background != null) {
            this._background.dispose();
            this._background = null;
        }
        if (this._shapes != null) {
            for (Shape sp : this._shapes) {
                sp.dispose();
            }
            this._shapes = null;
        }
        if (this._container != null) {
            this._container.dispose();
            this._container = null;
        }
    }
}

