/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.ShapeKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherChildAnchorRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherClientAnchorRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSpRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSpgrRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Hyperlink;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Shape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.ShapeFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class ShapeGroup
extends Shape {
    public ShapeGroup() {
        this(null, null);
        this._escherContainer = this.createSpContainer(false);
    }

    protected ShapeGroup(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    @Override
    public int getShapeId() {
        EscherRecord r;
        Iterator<EscherRecord> iter = this._escherContainer.getChildIterator();
        int grpShapeID = 0;
        if (iter.hasNext() && (r = iter.next()) instanceof EscherContainerRecord) {
            EscherContainerRecord container = (EscherContainerRecord)r;
            EscherSpRecord spRecord = (EscherSpRecord)container.getChildById((short)-4086);
            grpShapeID = spRecord.getShapeId();
        }
        return grpShapeID;
    }

    public Shape[] getShapes() {
        Iterator<EscherRecord> iter = this._escherContainer.getChildIterator();
        if (iter.hasNext()) {
            iter.next();
        }
        ArrayList<Shape> shapeList = new ArrayList<Shape>();
        while (iter.hasNext()) {
            EscherRecord r = iter.next();
            if (!(r instanceof EscherContainerRecord)) continue;
            EscherContainerRecord container = (EscherContainerRecord)r;
            Shape shape = ShapeFactory.createShape(container, this);
            shape.setSheet(this.getSheet());
            shapeList.add(shape);
        }
        Shape[] shapes = shapeList.toArray(new Shape[shapeList.size()]);
        return shapes;
    }

    public void setAnchor(Rectangle anchor) {
        EscherContainerRecord spContainer = (EscherContainerRecord)this._escherContainer.getChild(0);
        EscherClientAnchorRecord clientAnchor = (EscherClientAnchorRecord)ShapeKit.getEscherChild(spContainer, -4080);
        byte[] header = new byte[16];
        LittleEndian.putUShort(header, 0, 0);
        LittleEndian.putUShort(header, 2, 0);
        LittleEndian.putInt(header, 4, 8);
        clientAnchor.fillFields(header, 0, null);
        clientAnchor.setFlag((short)((float)(anchor.y * 576) / 72.0f));
        clientAnchor.setCol1((short)((float)(anchor.x * 576) / 72.0f));
        clientAnchor.setDx1((short)((float)((anchor.width + anchor.x) * 576) / 72.0f));
        clientAnchor.setRow1((short)((float)((anchor.height + anchor.y) * 576) / 72.0f));
        EscherSpgrRecord spgr = (EscherSpgrRecord)ShapeKit.getEscherChild(spContainer, -4087);
        spgr.setRectX1((int)((float)(anchor.x * 576) / 72.0f));
        spgr.setRectY1((int)((float)(anchor.y * 576) / 72.0f));
        spgr.setRectX2((int)((float)((anchor.x + anchor.width) * 576) / 72.0f));
        spgr.setRectY2((int)((float)((anchor.y + anchor.height) * 576) / 72.0f));
    }

    public void setCoordinates(Rectangle2D anchor) {
        EscherContainerRecord spContainer = (EscherContainerRecord)this._escherContainer.getChild(0);
        EscherSpgrRecord spgr = (EscherSpgrRecord)ShapeKit.getEscherChild(spContainer, -4087);
        int x1 = (int)Math.round(anchor.getX() * 576.0 / 72.0);
        int y1 = (int)Math.round(anchor.getY() * 576.0 / 72.0);
        int x2 = (int)Math.round((anchor.getX() + anchor.getWidth()) * 576.0 / 72.0);
        int y2 = (int)Math.round((anchor.getY() + anchor.getHeight()) * 576.0 / 72.0);
        spgr.setRectX1(x1);
        spgr.setRectY1(y1);
        spgr.setRectX2(x2);
        spgr.setRectY2(y2);
    }

    public Rectangle2D getCoordinates() {
        EscherContainerRecord spContainer = (EscherContainerRecord)this._escherContainer.getChild(0);
        EscherSpgrRecord spgr = (EscherSpgrRecord)ShapeKit.getEscherChild(spContainer, -4087);
        Rectangle2D.Float anchor = new Rectangle2D.Float();
        anchor.x = (float)spgr.getRectX1() * 72.0f / 576.0f;
        anchor.y = (float)spgr.getRectY1() * 72.0f / 576.0f;
        anchor.width = (float)(spgr.getRectX2() - spgr.getRectX1()) * 72.0f / 576.0f;
        anchor.height = (float)(spgr.getRectY2() - spgr.getRectY1()) * 72.0f / 576.0f;
        return anchor;
    }

    public Rectangle2D getClientAnchor2D(Shape shape) {
        Rectangle2D anchor = shape.getAnchor2D();
        if (shape != null && shape.getParent() != null) {
            Rectangle2D clientAnchor = ((ShapeGroup)shape.getParent()).getClientAnchor2D(shape.getParent());
            Rectangle2D spgrAnchor = ((ShapeGroup)shape.getParent()).getCoordinates();
            double scalex = spgrAnchor.getWidth() / clientAnchor.getWidth();
            double scaley = spgrAnchor.getHeight() / clientAnchor.getHeight();
            double x = clientAnchor.getX() + (anchor.getX() - spgrAnchor.getX()) / scalex;
            double y = clientAnchor.getY() + (anchor.getY() - spgrAnchor.getY()) / scaley;
            double width = anchor.getWidth() / scalex;
            double height = anchor.getHeight() / scaley;
            anchor = new Rectangle2D.Double(x, y, width, height);
        }
        return anchor;
    }

    @Override
    protected EscherContainerRecord createSpContainer(boolean isChild) {
        EscherContainerRecord spgr = new EscherContainerRecord();
        spgr.setRecordId((short)-4093);
        spgr.setOptions((short)15);
        EscherContainerRecord spcont = new EscherContainerRecord();
        spcont.setRecordId((short)-4092);
        spcont.setOptions((short)15);
        EscherSpgrRecord spg = new EscherSpgrRecord();
        spg.setOptions((short)1);
        spcont.addChildRecord(spg);
        EscherSpRecord sp = new EscherSpRecord();
        short type = 2;
        sp.setOptions(type);
        sp.setFlags(513);
        spcont.addChildRecord(sp);
        EscherClientAnchorRecord anchor = new EscherClientAnchorRecord();
        spcont.addChildRecord(anchor);
        spgr.addChildRecord(spcont);
        return spgr;
    }

    public void addShape(Shape shape) {
        this._escherContainer.addChildRecord(shape.getSpContainer());
        Sheet sheet = this.getSheet();
        shape.setSheet(sheet);
        shape.setShapeId(sheet.allocateShapeId());
        shape.afterInsert(sheet);
    }

    public void moveTo(int x, int y) {
        Rectangle anchor = this.getAnchor();
        int dx = x - anchor.x;
        int dy = y - anchor.y;
        anchor.translate(dx, dy);
        this.setAnchor(anchor);
        Shape[] shape = this.getShapes();
        for (int i = 0; i < shape.length; ++i) {
            Rectangle chanchor = shape[i].getAnchor();
            chanchor.translate(dx, dy);
            shape[i].setAnchor(chanchor);
        }
    }

    @Override
    public Rectangle2D getAnchor2D() {
        EscherContainerRecord spContainer = (EscherContainerRecord)this._escherContainer.getChild(0);
        EscherClientAnchorRecord clientAnchor = (EscherClientAnchorRecord)ShapeKit.getEscherChild(spContainer, -4080);
        Rectangle2D.Float anchor = new Rectangle2D.Float();
        if (clientAnchor == null) {
            EscherChildAnchorRecord rec = (EscherChildAnchorRecord)ShapeKit.getEscherChild(spContainer, -4081);
            anchor = new Rectangle2D.Float((float)rec.getDx1() * 72.0f / 576.0f, (float)rec.getDy1() * 72.0f / 576.0f, (float)(rec.getDx2() - rec.getDx1()) * 72.0f / 576.0f, (float)(rec.getDy2() - rec.getDy1()) * 72.0f / 576.0f);
        } else {
            anchor.x = (float)clientAnchor.getCol1() * 72.0f / 576.0f;
            anchor.y = (float)clientAnchor.getFlag() * 72.0f / 576.0f;
            anchor.width = (float)(clientAnchor.getDx1() - clientAnchor.getCol1()) * 72.0f / 576.0f;
            anchor.height = (float)(clientAnchor.getRow1() - clientAnchor.getFlag()) * 72.0f / 576.0f;
        }
        return anchor;
    }

    @Override
    public int getShapeType() {
        EscherContainerRecord groupInfoContainer = (EscherContainerRecord)this._escherContainer.getChild(0);
        EscherSpRecord spRecord = (EscherSpRecord)groupInfoContainer.getChildById((short)-4086);
        return spRecord.getOptions() >> 4;
    }

    @Override
    public Hyperlink getHyperlink() {
        return null;
    }

    @Override
    public boolean getFlipHorizontal() {
        return ShapeKit.getGroupFlipHorizontal(this.getSpContainer());
    }

    @Override
    public boolean getFlipVertical() {
        return ShapeKit.getGroupFlipVertical(this.getSpContainer());
    }

    @Override
    public int getRotation() {
        return ShapeKit.getGroupRotation(this.getSpContainer());
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

