/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.ShapeKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherClientDataRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherComplexProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.exceptions.HSLFException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Picture;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Shape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Document;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExControl;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExObjList;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.OEShapeAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordTypes;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;

public final class ActiveXShape
extends Picture {
    public static final int DEFAULT_ACTIVEX_THUMBNAIL = -1;

    public ActiveXShape(int movieIdx, int pictureIdx) {
        super(pictureIdx, null);
        this.setActiveXIndex(movieIdx);
    }

    protected ActiveXShape(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    @Override
    protected EscherContainerRecord createSpContainer(int idx, boolean isChild) {
        this._escherContainer = super.createSpContainer(idx, isChild);
        return this._escherContainer;
    }

    public void setActiveXIndex(int idx) {
        EscherContainerRecord spContainer = this.getSpContainer();
        Iterator<EscherRecord> it = spContainer.getChildIterator();
        while (it.hasNext()) {
            EscherRecord obj = it.next();
            if (obj.getRecordId() != -4079) continue;
            EscherClientDataRecord clientRecord = (EscherClientDataRecord)obj;
            byte[] recdata = clientRecord.getRemainingData();
            LittleEndian.putInt(recdata, 8, idx);
        }
    }

    public int getControlIndex() {
        int idx = -1;
        OEShapeAtom oe = (OEShapeAtom)this.getClientDataRecord(RecordTypes.OEShapeAtom.typeID);
        if (oe != null) {
            idx = oe.getOptions();
        }
        return idx;
    }

    public void setProperty(String key, String value) {
    }

    public ExControl getExControl() {
        int idx = this.getControlIndex();
        ExControl ctrl = null;
        Document doc = this.getSheet().getSlideShow().getDocumentRecord();
        ExObjList lst = (ExObjList)doc.findFirstOfType(RecordTypes.ExObjList.typeID);
        if (lst != null) {
            Record[] ch = lst.getChildRecords();
            for (int i = 0; i < ch.length; ++i) {
                ExControl c;
                if (!(ch[i] instanceof ExControl) || (c = (ExControl)ch[i]).getExOleObjAtom().getObjID() != idx) continue;
                ctrl = c;
                break;
            }
        }
        return ctrl;
    }

    @Override
    protected void afterInsert(Sheet sheet) {
        ExControl ctrl = this.getExControl();
        ctrl.getExControlAtom().setSlideId(sheet._getSheetNumber());
        try {
            String name = ctrl.getProgId() + "-" + this.getControlIndex();
            byte[] data = (name + '\u0000').getBytes("UTF-16LE");
            EscherComplexProperty prop = new EscherComplexProperty(896, false, data);
            EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(this._escherContainer, -4085);
            opt.addEscherProperty(prop);
        }
        catch (UnsupportedEncodingException e) {
            throw new HSLFException(e);
        }
    }
}

