/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.doc;

import android.graphics.Path;
import android.graphics.PointF;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.ArrowPathAndTail;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.LineArrowPathBuilder;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.WPAutoShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.doc.PathWithArrow;
import java.util.ArrayList;
import java.util.List;

public class VMLPathParser {
    public static final byte Command_Invalid = -1;
    public static final byte Command_MoveTo = 0;
    public static final byte Command_LineTo = 1;
    public static final byte Command_CurveTo = 2;
    public static final byte Command_Close = 3;
    public static final byte Command_End = 4;
    public static final byte Command_RMoveTo = 5;
    public static final byte Command_RLineTo = 6;
    public static final byte Command_RCurveTo = 7;
    public static final byte Command_NoFill = 8;
    public static final byte Command_NoStroke = 9;
    public static final byte Command_AngleEllipseTo = 10;
    public static final byte Command_AngleEllipse = 11;
    public static final byte Command_ArcTo = 12;
    public static final byte Command_Arc = 13;
    public static final byte Command_ClockwiseArcTo = 14;
    public static final byte Command_ClockwiseArc = 15;
    private static final byte Command_EllipticalQaudrantX = 16;
    private static final byte Command_EllipticalQaudrantY = 17;
    private static final byte Command_QuadraticBezier = 18;
    private static VMLPathParser instance = new VMLPathParser();
    private static byte NodeType_Invalidate = (byte)-1;
    private static byte NodeType_Start = 0;
    private static byte NodeType_Middle = 1;
    private static byte NodeType_End = (byte)2;
    private byte currentNodeType = NodeType_Invalidate;
    private byte preNodeType = NodeType_Invalidate;
    private PointF preNode = new PointF();
    private PointF ctrNode1 = new PointF();
    private PointF ctrNode2 = new PointF();
    private PointF nextNode = new PointF();
    Path startArrowPath = null;
    Path endArrowPath = null;
    private int index;
    private StringBuilder builder = new StringBuilder();
    private List<Integer> paraList = new ArrayList<Integer>();

    private VMLPathParser() {
    }

    public static VMLPathParser instance() {
        return instance;
    }

    public PathWithArrow createPath(WPAutoShape autoshape, String pathContext, int lineWidth) {
        try {
            byte command;
            this.index = 0;
            this.startArrowPath = null;
            this.endArrowPath = null;
            ArrayList<Path> pathList = new ArrayList<Path>();
            Path path = null;
            boolean newPath = true;
            byte nextCommand = command = this.nextCommand(pathContext);
            this.currentNodeType = NodeType_Start;
            this.preNodeType = NodeType_Invalidate;
            while (command != -1) {
                if (command == 4) {
                    newPath = true;
                    nextCommand = this.nextCommand(pathContext);
                    if (nextCommand == -1) {
                        this.currentNodeType = NodeType_End;
                    }
                } else {
                    if (newPath) {
                        newPath = false;
                        path = new Path();
                        pathList.add(path);
                    }
                    Integer[] paras = this.nextParameters(pathContext);
                    nextCommand = this.nextCommand(pathContext);
                    if (nextCommand == -1 || nextCommand == 4) {
                        this.currentNodeType = NodeType_End;
                    }
                    this.processPath(autoshape, lineWidth, path, command, paras);
                    this.preNodeType = this.currentNodeType;
                    this.currentNodeType = NodeType_Middle;
                }
                command = nextCommand;
            }
            PathWithArrow pathWithArrow = new PathWithArrow(pathList.toArray(new Path[pathList.size()]), this.startArrowPath, this.endArrowPath);
            this.startArrowPath = null;
            this.endArrowPath = null;
            return pathWithArrow;
        }
        catch (Exception e) {
            return null;
        }
    }

    private byte nextCommand(String pathContext) {
        this.builder.delete(0, this.builder.length());
        while (this.index < pathContext.length() && Character.isLetter(pathContext.charAt(this.index))) {
            this.builder.append(pathContext.charAt(this.index++));
        }
        String comm = this.builder.toString();
        if (comm.contains("h")) {
            comm = comm.substring(2);
        }
        if ("m".equalsIgnoreCase(comm)) {
            return 0;
        }
        if ("l".equalsIgnoreCase(comm)) {
            return 1;
        }
        if ("c".equalsIgnoreCase(comm)) {
            return 2;
        }
        if ("x".equalsIgnoreCase(comm)) {
            return 3;
        }
        if ("e".equalsIgnoreCase(comm)) {
            return 4;
        }
        if ("t".equalsIgnoreCase(comm)) {
            return 5;
        }
        if ("r".equalsIgnoreCase(comm)) {
            return 6;
        }
        if ("v".equalsIgnoreCase(comm)) {
            return 7;
        }
        if ("nf".equalsIgnoreCase(comm)) {
            return 8;
        }
        if ("ns".equalsIgnoreCase(comm)) {
            return 9;
        }
        if ("ae".equalsIgnoreCase(comm)) {
            return 10;
        }
        if ("al".equalsIgnoreCase(comm)) {
            return 11;
        }
        if ("at".equalsIgnoreCase(comm)) {
            return 12;
        }
        if ("ar".equalsIgnoreCase(comm)) {
            return 13;
        }
        if ("wa".equalsIgnoreCase(comm)) {
            return 14;
        }
        if ("wr".equalsIgnoreCase(comm)) {
            return 15;
        }
        if ("qx".equalsIgnoreCase(comm)) {
            return 16;
        }
        if ("qy".equalsIgnoreCase(comm)) {
            return 17;
        }
        if ("qb".equalsIgnoreCase(comm)) {
            return 18;
        }
        if (comm.contains("x") || comm.contains("X")) {
            this.index -= comm.length() - 1;
            return 3;
        }
        return -1;
    }

    private Integer[] nextParameters(String pathContext) {
        this.paraList.clear();
        int[] point = null;
        while (this.hasNextPoint(pathContext)) {
            point = this.nextPoint(pathContext);
            this.paraList.add(point[0]);
            this.paraList.add(point[1]);
        }
        return this.paraList.toArray(new Integer[this.paraList.size()]);
    }

    private boolean hasNextPoint(String pathContext) {
        return this.index < pathContext.length() && !Character.isLetter(pathContext.charAt(this.index));
    }

    private int[] nextPoint(String pathContext) {
        int[] point = new int[2];
        this.builder.delete(0, this.builder.length());
        while (this.index < pathContext.length() && (Character.isDigit(pathContext.charAt(this.index)) || pathContext.charAt(this.index) == '-')) {
            this.builder.append(pathContext.charAt(this.index++));
        }
        if (this.builder.length() > 0) {
            point[0] = Integer.parseInt(this.builder.toString());
        }
        if (this.index < pathContext.length() && pathContext.charAt(this.index) == ',') {
            ++this.index;
            this.builder.delete(0, this.builder.length());
            while (this.index < pathContext.length() && (Character.isDigit(pathContext.charAt(this.index)) || pathContext.charAt(this.index) == '-')) {
                this.builder.append(pathContext.charAt(this.index++));
            }
            if (this.builder.length() > 0) {
                point[1] = Integer.parseInt(this.builder.toString());
            }
            if (this.index < pathContext.length() && pathContext.charAt(this.index) == ',') {
                ++this.index;
            }
        }
        return point;
    }

    private void processPath(WPAutoShape autoshape, int lineWidth, Path path, byte command, Integer[] parameters) {
        int cnt;
        ArrowPathAndTail startArrowPathAndTail = null;
        ArrowPathAndTail endArrowPathAndTail = null;
        if (this.preNodeType == NodeType_Start && autoshape != null && autoshape.getStartArrowhead()) {
            switch (command) {
                case 1: {
                    startArrowPathAndTail = LineArrowPathBuilder.getDirectLineArrowPath(parameters[0].intValue(), parameters[1].intValue(), this.nextNode.x, this.nextNode.y, autoshape.getStartArrow(), lineWidth);
                    break;
                }
                case 2: {
                    startArrowPathAndTail = LineArrowPathBuilder.getCubicBezArrowPath(parameters[4].intValue(), parameters[5].intValue(), parameters[2].intValue(), parameters[3].intValue(), parameters[0].intValue(), parameters[1].intValue(), this.nextNode.x, this.nextNode.y, autoshape.getStartArrow(), lineWidth);
                    break;
                }
                case 6: {
                    startArrowPathAndTail = LineArrowPathBuilder.getDirectLineArrowPath((float)parameters[0].intValue() + this.nextNode.x, (float)parameters[1].intValue() + this.nextNode.y, this.nextNode.x, this.nextNode.y, autoshape.getStartArrow(), lineWidth);
                    break;
                }
                case 7: {
                    startArrowPathAndTail = LineArrowPathBuilder.getCubicBezArrowPath((float)parameters[4].intValue() + this.nextNode.x, (float)parameters[5].intValue() + this.nextNode.y, (float)parameters[2].intValue() + this.nextNode.x, (float)parameters[3].intValue() + this.nextNode.y, (float)parameters[0].intValue() + this.nextNode.x, (float)parameters[1].intValue() + this.nextNode.y, this.nextNode.x, this.nextNode.y, autoshape.getStartArrow(), lineWidth);
                }
            }
        }
        if (this.currentNodeType == NodeType_End && autoshape != null && autoshape.getEndArrowhead()) {
            cnt = parameters.length;
            switch (command) {
                case 1: {
                    if (cnt > 2) {
                        endArrowPathAndTail = LineArrowPathBuilder.getDirectLineArrowPath(parameters[cnt - 4].intValue(), parameters[cnt - 3].intValue(), parameters[cnt - 2].intValue(), parameters[cnt - 1].intValue(), autoshape.getEndArrow(), lineWidth);
                        break;
                    }
                    endArrowPathAndTail = LineArrowPathBuilder.getDirectLineArrowPath(this.nextNode.x, this.nextNode.y, parameters[cnt - 2].intValue(), parameters[cnt - 1].intValue(), autoshape.getEndArrow(), lineWidth);
                    break;
                }
                case 2: {
                    if (cnt > 6) {
                        endArrowPathAndTail = LineArrowPathBuilder.getCubicBezArrowPath(parameters[cnt - 8].intValue(), parameters[cnt - 7].intValue(), parameters[cnt - 6].intValue(), parameters[cnt - 5].intValue(), parameters[cnt - 4].intValue(), parameters[cnt - 3].intValue(), parameters[cnt - 2].intValue(), parameters[cnt - 1].intValue(), autoshape.getEndArrow(), lineWidth);
                        break;
                    }
                    endArrowPathAndTail = LineArrowPathBuilder.getCubicBezArrowPath(this.nextNode.x, this.nextNode.y, parameters[cnt - 6].intValue(), parameters[cnt - 5].intValue(), parameters[cnt - 4].intValue(), parameters[cnt - 3].intValue(), parameters[cnt - 2].intValue(), parameters[cnt - 1].intValue(), autoshape.getEndArrow(), lineWidth);
                    break;
                }
                case 6: {
                    if (cnt > 2) {
                        endArrowPathAndTail = LineArrowPathBuilder.getDirectLineArrowPath((float)parameters[cnt - 4].intValue() + this.nextNode.x, (float)parameters[cnt - 3].intValue() + this.nextNode.y, (float)parameters[cnt - 2].intValue() + this.nextNode.x, (float)parameters[cnt - 1].intValue() + this.nextNode.y, autoshape.getEndArrow(), lineWidth);
                        break;
                    }
                    endArrowPathAndTail = LineArrowPathBuilder.getDirectLineArrowPath(this.nextNode.x, this.nextNode.y, (float)parameters[cnt - 2].intValue() + this.nextNode.x, (float)parameters[cnt - 1].intValue() + this.nextNode.y, autoshape.getEndArrow(), lineWidth);
                    break;
                }
                case 7: {
                    endArrowPathAndTail = cnt > 6 ? LineArrowPathBuilder.getCubicBezArrowPath((float)parameters[cnt - 8].intValue() + this.nextNode.x, (float)parameters[cnt - 7].intValue() + this.nextNode.y, (float)parameters[cnt - 6].intValue() + this.nextNode.x, (float)parameters[cnt - 5].intValue() + this.nextNode.y, (float)parameters[cnt - 4].intValue() + this.nextNode.x, (float)parameters[cnt - 3].intValue() + this.nextNode.y, (float)parameters[cnt - 2].intValue() + this.nextNode.x, (float)parameters[cnt - 1].intValue() + this.nextNode.y, autoshape.getEndArrow(), lineWidth) : LineArrowPathBuilder.getCubicBezArrowPath(this.nextNode.x, this.nextNode.y, (float)parameters[cnt - 6].intValue() + this.nextNode.x, (float)parameters[cnt - 5].intValue() + this.nextNode.y, (float)parameters[cnt - 4].intValue() + this.nextNode.x, (float)parameters[cnt - 3].intValue() + this.nextNode.y, (float)parameters[cnt - 2].intValue() + this.nextNode.x, (float)parameters[cnt - 1].intValue() + this.nextNode.y, autoshape.getEndArrow(), lineWidth);
                }
            }
        }
        if (startArrowPathAndTail != null) {
            this.startArrowPath = startArrowPathAndTail.getArrowPath();
            path.reset();
            PointF pos = LineArrowPathBuilder.getReferencedPosition(this.nextNode.x, this.nextNode.y, startArrowPathAndTail.getArrowTailCenter().x, startArrowPathAndTail.getArrowTailCenter().y, autoshape.getStartArrowType());
            path.moveTo(pos.x, pos.y);
        }
        if (endArrowPathAndTail != null) {
            this.endArrowPath = endArrowPathAndTail.getArrowPath();
            cnt = parameters.length;
            PointF pos = LineArrowPathBuilder.getReferencedPosition(parameters[cnt - 2].intValue(), parameters[cnt - 1].intValue(), endArrowPathAndTail.getArrowTailCenter().x, endArrowPathAndTail.getArrowTailCenter().y, autoshape.getEndArrowType());
            parameters[cnt - 2] = (int)pos.x;
            parameters[cnt - 1] = (int)pos.y;
        }
        switch (command) {
            case 0: {
                this.processCommand_MoveTo(path, parameters);
                break;
            }
            case 1: {
                this.processCommand_LineTo(path, parameters);
                break;
            }
            case 2: {
                this.processCommand_CurveTo(path, parameters);
                break;
            }
            case 5: {
                this.processCommand_rMoveTo(path, parameters);
                break;
            }
            case 6: {
                this.processCommand_rLineTo(path, parameters);
                break;
            }
            case 7: {
                this.processCommand_rCurveTo(path, parameters);
                break;
            }
            case 3: {
                path.close();
            }
        }
    }

    private void processCommand_MoveTo(Path path, Integer[] parameters) {
        float x = 0.0f;
        float y = 0.0f;
        if (parameters.length == 2) {
            x = parameters[0].intValue();
            y = parameters[1].intValue();
        } else if (parameters.length == 1) {
            x = parameters[0].intValue();
        }
        path.moveTo(x, y);
        this.nextNode.set(x, y);
    }

    private void processCommand_LineTo(Path path, Integer[] parameters) {
        for (int paraIndex = 0; paraIndex < parameters.length - 1; paraIndex += 2) {
            path.lineTo((float)parameters[paraIndex].intValue(), (float)parameters[paraIndex + 1].intValue());
            this.preNode.set(this.nextNode);
            this.nextNode.set((float)parameters[paraIndex].intValue(), (float)parameters[paraIndex + 1].intValue());
        }
    }

    private void processCommand_CurveTo(Path path, Integer[] parameters) {
        for (int paraIndex = 0; paraIndex < parameters.length - 5; paraIndex += 6) {
            path.cubicTo((float)parameters[paraIndex].intValue(), (float)parameters[paraIndex + 1].intValue(), (float)parameters[paraIndex + 2].intValue(), (float)parameters[paraIndex + 3].intValue(), (float)parameters[paraIndex + 4].intValue(), (float)parameters[paraIndex + 5].intValue());
            this.preNode.set(this.nextNode);
            this.ctrNode1.set((float)parameters[paraIndex].intValue(), (float)parameters[paraIndex + 1].intValue());
            this.ctrNode2.set((float)parameters[paraIndex + 2].intValue(), (float)parameters[paraIndex + 3].intValue());
            this.nextNode.set((float)parameters[paraIndex + 4].intValue(), (float)parameters[paraIndex + 5].intValue());
        }
    }

    private void processCommand_rMoveTo(Path path, Integer[] parameters) {
        if (parameters.length == 2) {
            path.rMoveTo((float)parameters[0].intValue(), (float)parameters[1].intValue());
            this.preNode.set(this.nextNode);
            this.nextNode.offset((float)parameters[0].intValue(), (float)parameters[1].intValue());
        } else if (parameters.length == 1) {
            path.rMoveTo((float)parameters[0].intValue(), 0.0f);
            this.preNode.set(this.nextNode);
            this.nextNode.offset((float)parameters[0].intValue(), 0.0f);
        } else {
            path.rMoveTo(0.0f, 0.0f);
            this.preNode.set(this.nextNode);
            this.nextNode.offset(0.0f, 0.0f);
        }
    }

    private void processCommand_rLineTo(Path path, Integer[] parameters) {
        for (int paraIndex = 0; paraIndex < parameters.length - 1; paraIndex += 2) {
            path.rLineTo((float)parameters[paraIndex].intValue(), (float)parameters[paraIndex + 1].intValue());
            this.preNode.set(this.nextNode);
            this.nextNode.offset((float)parameters[paraIndex].intValue(), (float)parameters[paraIndex + 1].intValue());
        }
    }

    private void processCommand_rCurveTo(Path path, Integer[] parameters) {
        for (int paraIndex = 0; paraIndex < parameters.length - 5; paraIndex += 6) {
            path.rCubicTo((float)parameters[paraIndex].intValue(), (float)parameters[paraIndex + 1].intValue(), (float)parameters[paraIndex + 2].intValue(), (float)parameters[paraIndex + 3].intValue(), (float)parameters[paraIndex + 4].intValue(), (float)parameters[paraIndex + 5].intValue());
            this.preNode.set(this.nextNode);
            this.ctrNode1.offset((float)parameters[paraIndex].intValue(), (float)parameters[paraIndex + 1].intValue());
            this.ctrNode2.offset((float)parameters[paraIndex + 2].intValue(), (float)parameters[paraIndex + 3].intValue());
            this.nextNode.offset((float)parameters[paraIndex + 4].intValue(), (float)parameters[paraIndex + 5].intValue());
        }
    }
}

