/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc;

import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.DocumentSummaryInformation;
import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.HPSFException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.MutablePropertySet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.PropertySet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.PropertySetFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.SummaryInformation;
import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.WritingNotSupportedException;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.DirectoryEntry;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.DirectoryNode;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.DocumentInputStream;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.Entry;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.NPOIFSFileSystem;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.POIFSFileSystem;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.Internal;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.POILogFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.POILogger;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.POIUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public abstract class POIDocument {
    private SummaryInformation sInf;
    private DocumentSummaryInformation dsInf;
    protected DirectoryNode directory;
    private static final POILogger logger = POILogFactory.getLogger(POIDocument.class);
    private boolean initialized = false;

    protected POIDocument(DirectoryNode dir) {
        this.directory = dir;
    }

    @Deprecated
    protected POIDocument(DirectoryNode dir, POIFSFileSystem fs) {
        this.directory = dir;
    }

    protected POIDocument(POIFSFileSystem fs) {
        this(fs.getRoot());
    }

    protected POIDocument(NPOIFSFileSystem fs) {
        this(fs.getRoot());
    }

    public DocumentSummaryInformation getDocumentSummaryInformation() {
        if (!this.initialized) {
            this.readProperties();
        }
        return this.dsInf;
    }

    public SummaryInformation getSummaryInformation() {
        if (!this.initialized) {
            this.readProperties();
        }
        return this.sInf;
    }

    public void createInformationProperties() {
        if (!this.initialized) {
            this.readProperties();
        }
        if (this.sInf == null) {
            this.sInf = PropertySetFactory.newSummaryInformation();
        }
        if (this.dsInf == null) {
            this.dsInf = PropertySetFactory.newDocumentSummaryInformation();
        }
    }

    protected void readProperties() {
        PropertySet ps = this.getPropertySet("\u0005DocumentSummaryInformation");
        if (ps != null && ps instanceof DocumentSummaryInformation) {
            this.dsInf = (DocumentSummaryInformation)ps;
        } else if (ps != null) {
            logger.log(POILogger.WARN, (Object)"DocumentSummaryInformation property set came back with wrong class - ", ps.getClass());
        }
        ps = this.getPropertySet("\u0005SummaryInformation");
        if (ps instanceof SummaryInformation) {
            this.sInf = (SummaryInformation)ps;
        } else if (ps != null) {
            logger.log(POILogger.WARN, (Object)"SummaryInformation property set came back with wrong class - ", ps.getClass());
        }
        this.initialized = true;
    }

    protected PropertySet getPropertySet(String setName) {
        DocumentInputStream dis;
        if (this.directory == null) {
            return null;
        }
        try {
            dis = this.directory.createDocumentInputStream(this.directory.getEntry(setName));
        }
        catch (IOException ie) {
            logger.log(POILogger.WARN, "Error getting property set with name " + setName + "\n" + ie);
            return null;
        }
        try {
            PropertySet set = PropertySetFactory.create(dis);
            return set;
        }
        catch (IOException ie) {
            logger.log(POILogger.WARN, "Error creating property set with name " + setName + "\n" + ie);
        }
        catch (HPSFException he) {
            logger.log(POILogger.WARN, "Error creating property set with name " + setName + "\n" + he);
        }
        return null;
    }

    protected void writeProperties(POIFSFileSystem outFS) throws IOException {
        this.writeProperties(outFS, null);
    }

    protected void writeProperties(POIFSFileSystem outFS, List<String> writtenEntries) throws IOException {
        DocumentSummaryInformation dsi;
        SummaryInformation si = this.getSummaryInformation();
        if (si != null) {
            this.writePropertySet("\u0005SummaryInformation", si, outFS);
            if (writtenEntries != null) {
                writtenEntries.add("\u0005SummaryInformation");
            }
        }
        if ((dsi = this.getDocumentSummaryInformation()) != null) {
            this.writePropertySet("\u0005DocumentSummaryInformation", dsi, outFS);
            if (writtenEntries != null) {
                writtenEntries.add("\u0005DocumentSummaryInformation");
            }
        }
    }

    protected void writePropertySet(String name, PropertySet set, POIFSFileSystem outFS) throws IOException {
        try {
            MutablePropertySet mSet = new MutablePropertySet(set);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            mSet.write(bOut);
            byte[] data = bOut.toByteArray();
            ByteArrayInputStream bIn = new ByteArrayInputStream(data);
            outFS.createDocument(bIn, name);
            logger.log(POILogger.INFO, "Wrote property set " + name + " of size " + data.length);
        }
        catch (WritingNotSupportedException wnse) {
            System.err.println("Couldn't write property set with name " + name + " as not supported by HPSF yet");
        }
    }

    public abstract void write(OutputStream var1) throws IOException;

    @Deprecated
    protected void copyNodes(POIFSFileSystem source, POIFSFileSystem target, List<String> excepts) throws IOException {
        POIUtils.copyNodes(source, target, excepts);
    }

    @Deprecated
    protected void copyNodes(DirectoryNode sourceRoot, DirectoryNode targetRoot, List<String> excepts) throws IOException {
        POIUtils.copyNodes(sourceRoot, targetRoot, excepts);
    }

    @Internal
    @Deprecated
    protected void copyNodeRecursively(Entry entry, DirectoryEntry target) throws IOException {
        POIUtils.copyNodeRecursively(entry, target);
    }
}

