/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.hyperlink;

import com.ahmadullahpk.alldocumentreader.xs.common.hyperlink.Hyperlink;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HyperlinkManage {
    private List<Hyperlink> hlinks = new ArrayList<Hyperlink>();
    private Map<String, Integer> hlinkIndexs = new HashMap<String, Integer>();

    public Hyperlink getHyperlink(int hlinkID) {
        if (hlinkID >= 0 && hlinkID < this.hlinks.size()) {
            return this.hlinks.get(hlinkID);
        }
        return null;
    }

    public Integer getHyperlinkIndex(String key) {
        return this.hlinkIndexs.get(key);
    }

    public int addHyperlink(String address, int linkType) {
        Integer index = this.hlinkIndexs.get(address);
        if (index == null) {
            Hyperlink hlink = new Hyperlink();
            hlink.setLinkType(linkType);
            hlink.setAddress(address);
            int size = this.hlinks.size();
            this.hlinks.add(hlink);
            this.hlinkIndexs.put(address, size);
            return size;
        }
        return index;
    }

    public void dispose() {
        if (this.hlinks != null) {
            for (Hyperlink hyperlink : this.hlinks) {
                hyperlink.dispose();
            }
            this.hlinks.clear();
        }
        if (this.hlinkIndexs != null) {
            this.hlinkIndexs.clear();
        }
    }
}

