/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.bg;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Rect;
import android.graphics.Shader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.AShader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.TileShader;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.Picture;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;

public class PatternShader
extends AShader {
    private Picture picture;
    private int backgroundColor;
    private int foregroundColor;

    public PatternShader(Picture picture, int backgroundColor, int foregroundColor) {
        this.picture = picture;
        this.backgroundColor = backgroundColor;
        this.foregroundColor = foregroundColor;
    }

    @Override
    public Shader createShader(IControl control, int viewIndex, Rect rect) {
        try {
            Bitmap bmp = TileShader.getBitmap(control, viewIndex, this.picture, rect, null);
            if (bmp != null) {
                int width = bmp.getWidth();
                int height = bmp.getHeight();
                int[] pixels = new int[width * height];
                bmp.getPixels(pixels, 0, width, 0, 0, width, height);
                for (int i = 0; i < width * height; ++i) {
                    pixels[i] = (pixels[i] & 0xFFFFFF) == 0 ? this.backgroundColor : this.foregroundColor;
                }
                bmp = Bitmap.createBitmap((int[])pixels, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Shader.TileMode tileX = Shader.TileMode.REPEAT;
                Shader.TileMode tileY = Shader.TileMode.REPEAT;
                this.shader = new BitmapShader(bmp, tileX, tileY);
            }
            return this.shader;
        }
        catch (Exception e) {
            return null;
        }
    }
}

