/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.autoshape;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.common.BackgroundDrawer;
import com.ahmadullahpk.alldocumentreader.xs.common.PaintKit;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.ExtendPath;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.actionButton.ActionButtonPathBuilder;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.arrow.ArrowPathBuilder;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.baseshape.BaseShapePathBuilder;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.flowChart.FlowChartDrawing;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.line.LinePathBuilder;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.math.MathPathBuilder;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.rect.RectPathBuilder;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.smartArt.SmartArtPathBuilder;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.starAndBanner.BannerPathBuilder;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.starAndBanner.star.StarPathBuilder;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.wedgecallout.WedgeCalloutDrawing;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.ArbitraryPolygonShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.LineShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.WPAutoShape;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.IAnimation;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.ShapeAnimation;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import java.util.List;

public class AutoShapeKit {
    public static int ARROW_WIDTH = 10;
    private static Rect rect = new Rect();
    private static Matrix m = new Matrix();
    private static final AutoShapeKit kit = new AutoShapeKit();

    public static AutoShapeKit instance() {
        return kit;
    }

    private IAnimation getShapeAnimation(AutoShape shape) {
        IAnimation animation = shape.getAnimation();
        if (animation != null) {
            ShapeAnimation shapeAnim = animation.getShapeAnimation();
            int paraBegin = shapeAnim.getParagraphBegin();
            int paraEnd = shapeAnim.getParagraphEnd();
            if (paraBegin == -2 && paraEnd == -2 || paraBegin == -1 && paraEnd == -1) {
                return animation;
            }
        }
        return null;
    }

    private void processShapeRect(Rect rect, IAnimation animation) {
        if (animation != null) {
            int width = rect.width();
            int height = rect.height();
            int alpha = animation.getCurrentAnimationInfor().getAlpha();
            float rate = (float)alpha / 255.0f * 0.5f;
            int centerX = rect.centerX();
            int centerY = rect.centerY();
            rect.set((int)((float)centerX - (float)width * rate), (int)((float)centerY - (float)height * rate), (int)((float)centerX + (float)width * rate), (int)((float)centerY + (float)height * rate));
        }
    }

    public void drawAutoShape(Canvas canvas, IControl control, int viewIndex, AutoShape shape, float zoom) {
        Rectangle shapeRect = shape.getBounds();
        int left = Math.round((float)shapeRect.x * zoom);
        int top = Math.round((float)shapeRect.y * zoom);
        int width = Math.round((float)shapeRect.width * zoom);
        int height = Math.round((float)shapeRect.height * zoom);
        rect.set(left, top, left + width, top + height);
        this.drawAutoShape(canvas, control, viewIndex, shape, rect, zoom);
    }

    public void drawAutoShape(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        IAnimation animation = this.getShapeAnimation(shape);
        this.processShapeRect(rect, animation);
        int type = shape.getShapeType();
        switch (type) {
            case 20: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                if (!(shape instanceof LineShape)) break;
                List<ExtendPath> pathList = LinePathBuilder.getLinePath((LineShape)shape, rect, zoom);
                for (int i = 0; i < pathList.size(); ++i) {
                    ExtendPath extendPath = new ExtendPath(pathList.get(i));
                    this.drawShape(canvas, control, viewIndex, shape, extendPath, rect, animation, zoom);
                }
                break;
            }
            case 233: {
                m.reset();
                m.postScale(zoom, zoom);
                List<ExtendPath> pathList = ((ArbitraryPolygonShape)shape).getPaths();
                for (int i = 0; i < pathList.size(); ++i) {
                    ExtendPath extendPath = new ExtendPath(pathList.get(i));
                    extendPath.getPath().transform(m);
                    extendPath.getPath().offset((float)rect.left, (float)rect.top);
                    this.drawShape(canvas, control, viewIndex, shape, extendPath, rect, animation, zoom);
                }
                break;
            }
            case 247: 
            case 248: 
            case 249: {
                m.reset();
                m.postScale(zoom, zoom);
                List<ExtendPath> pathList = ((WPAutoShape)shape).getPaths();
                Rect r = new Rect(rect);
                if (rect.width() == 0 || rect.height() == 0) {
                    RectF bounds = new RectF();
                    pathList.get(0).getPath().computeBounds(bounds, true);
                    r.set((int)bounds.left, (int)bounds.top, (int)bounds.right, (int)bounds.bottom);
                }
                for (int i = 0; i < pathList.size(); ++i) {
                    ExtendPath extendPath = new ExtendPath(pathList.get(i));
                    extendPath.getPath().transform(m);
                    extendPath.getPath().offset((float)rect.left, (float)rect.top);
                    this.drawShape(canvas, control, viewIndex, shape, extendPath, r, animation, zoom);
                }
                break;
            }
            case 1: 
            case 2: 
            case 136: 
            case 202: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: {
                this.drawShape(canvas, control, viewIndex, shape, RectPathBuilder.getRectPath(shape, rect), rect, animation, zoom);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 56: 
            case 57: 
            case 65: 
            case 73: 
            case 74: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 95: 
            case 96: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 234: {
                Object obj = BaseShapePathBuilder.getBaseShapePath(shape, rect);
                if (obj instanceof Path) {
                    this.drawShape(canvas, control, viewIndex, shape, (Path)obj, rect, animation, zoom);
                    break;
                }
                List pathList = (List)obj;
                for (int i = 0; i < pathList.size(); ++i) {
                    ExtendPath extendPath = new ExtendPath((ExtendPath)pathList.get(i));
                    this.drawShape(canvas, control, viewIndex, shape, extendPath, rect, animation, zoom);
                }
                break;
            }
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: {
                this.drawShape(canvas, control, viewIndex, shape, MathPathBuilder.getMathPath(shape, rect), rect, animation, zoom);
                break;
            }
            case 13: 
            case 15: 
            case 55: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 182: {
                Object obj = ArrowPathBuilder.getArrowPath(shape, rect);
                if (obj instanceof Path) {
                    this.drawShape(canvas, control, viewIndex, shape, (Path)obj, rect, animation, zoom);
                    break;
                }
                List list = (List)obj;
                int cnt = list.size();
                for (int i = 0; i < cnt; ++i) {
                    this.drawShape(canvas, control, viewIndex, shape, (Path)list.get(i), rect, animation, zoom);
                }
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 176: 
            case 177: {
                FlowChartDrawing.instance().drawFlowChart(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 61: 
            case 62: 
            case 63: 
            case 106: 
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                Object obj = WedgeCalloutDrawing.instance().getWedgeCalloutPath(shape, rect);
                if (obj instanceof Path) {
                    this.drawShape(canvas, control, viewIndex, shape, (Path)obj, rect, animation, zoom);
                    break;
                }
                List list = (List)obj;
                int cnt = list.size();
                for (int i = 0; i < cnt; ++i) {
                    this.drawShape(canvas, control, viewIndex, shape, (ExtendPath)list.get(i), rect, animation, zoom);
                }
                break;
            }
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: {
                List<ExtendPath> pathList = ActionButtonPathBuilder.getActionButtonExtendPath(shape, rect);
                if (pathList == null) {
                    return;
                }
                int cnt = pathList.size();
                for (int i = 0; i < cnt; ++i) {
                    this.drawShape(canvas, control, viewIndex, shape, pathList.get(i), rect, animation, zoom);
                }
                break;
            }
            case 12: 
            case 58: 
            case 59: 
            case 60: 
            case 71: 
            case 72: 
            case 92: 
            case 187: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                Path path = StarPathBuilder.getStarPath(shape, rect);
                if (path == null) break;
                this.drawShape(canvas, control, viewIndex, shape, path, rect, animation, zoom);
                break;
            }
            case 53: 
            case 54: 
            case 64: 
            case 97: 
            case 98: 
            case 107: 
            case 108: 
            case 188: 
            case 244: {
                List<ExtendPath> pathList = BannerPathBuilder.getFlagExtendPath(shape, rect);
                if (pathList == null) {
                    return;
                }
                int cnt = pathList.size();
                for (int i = 0; i < cnt; ++i) {
                    this.drawShape(canvas, control, viewIndex, shape, pathList.get(i), rect, animation, zoom);
                }
                break;
            }
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 245: 
            case 246: {
                Path path = SmartArtPathBuilder.getStarPath(shape, rect);
                if (path == null) break;
                this.drawShape(canvas, control, viewIndex, shape, path, rect, animation, zoom);
                break;
            }
        }
    }

    private void processCanvas(Canvas canvas, Rect rect, float angle, boolean flipH, boolean flipV, IAnimation animation) {
        if (animation != null) {
            angle += (float)animation.getCurrentAnimationInfor().getAngle();
        }
        if (flipV) {
            canvas.translate((float)rect.left, (float)rect.bottom);
            canvas.scale(1.0f, -1.0f);
            canvas.translate((float)(-rect.left), (float)(-rect.top));
            angle = -angle;
        }
        if (flipH) {
            canvas.translate((float)rect.right, (float)rect.top);
            canvas.scale(-1.0f, 1.0f);
            canvas.translate((float)(-rect.left), (float)(-rect.top));
            angle = -angle;
        }
        if (angle != 0.0f) {
            canvas.rotate(angle, (float)rect.centerX(), (float)rect.centerY());
        }
    }

    public void drawShape(Canvas canvas, IControl control, int viewIndex, AutoShape shape, ExtendPath pathExtend, Rect rect, IAnimation animation, float zoom) {
        canvas.save();
        Paint paint = PaintKit.instance().getPaint();
        this.processCanvas(canvas, rect, shape.getRotation(), shape.getFlipHorizontal(), shape.getFlipVertical(), animation);
        int alpha = paint.getAlpha();
        BackgroundAndFill fill = pathExtend.getBackgroundAndFill();
        if (fill != null) {
            paint.setStyle(Paint.Style.FILL);
            BackgroundDrawer.drawPathBackground(canvas, control, viewIndex, fill, rect, animation, zoom, pathExtend.getPath(), paint);
            paint.setAlpha(alpha);
        }
        if (pathExtend.hasLine()) {
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth((float)pathExtend.getLine().getLineWidth() * zoom);
            if (pathExtend.getLine().isDash() && !pathExtend.isArrowPath()) {
                DashPathEffect dashPathEffect = new DashPathEffect(new float[]{5.0f * zoom, 5.0f * zoom}, 10.0f);
                paint.setPathEffect((PathEffect)dashPathEffect);
            }
            BackgroundDrawer.drawPathBackground(canvas, control, viewIndex, pathExtend.getLine().getBackgroundAndFill(), rect, animation, zoom, pathExtend.getPath(), paint);
            paint.setAlpha(alpha);
        }
        canvas.restore();
    }

    public void drawShape(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Path path, Rect rect, float zoom) {
        this.drawShape(canvas, control, viewIndex, shape, path, rect, this.getShapeAnimation(shape), zoom);
    }

    public void drawShape(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Path path, Rect rect, IAnimation animation, float zoom) {
        if (path == null) {
            return;
        }
        canvas.save();
        Paint paint = PaintKit.instance().getPaint();
        int color2 = paint.getColor();
        Paint.Style style2 = paint.getStyle();
        int alpha = paint.getAlpha();
        this.processCanvas(canvas, rect, shape.getRotation(), shape.getFlipHorizontal(), shape.getFlipVertical(), animation);
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        if (fill != null) {
            paint.setStyle(Paint.Style.FILL);
            BackgroundDrawer.drawPathBackground(canvas, control, viewIndex, fill, rect, animation, zoom, path, paint);
            paint.setAlpha(alpha);
        }
        if (shape.hasLine()) {
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth((float)shape.getLine().getLineWidth() * zoom);
            if (shape.getLine().isDash()) {
                DashPathEffect dashPathEffect = new DashPathEffect(new float[]{5.0f * zoom, 5.0f * zoom}, 10.0f);
                paint.setPathEffect((PathEffect)dashPathEffect);
            }
            BackgroundDrawer.drawPathBackground(canvas, control, viewIndex, shape.getLine().getBackgroundAndFill(), rect, animation, zoom, path, paint);
            paint.setAlpha(alpha);
        }
        paint.setAlpha(alpha);
        paint.setColor(color2);
        paint.setStyle(style2);
        canvas.restore();
    }
}

