/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.widgets;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import com.ahmadullahpk.alldocumentreader.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SymmetricProgressBar
extends View
implements Animator.AnimatorListener,
ValueAnimator.AnimatorUpdateListener {
    private final List<Integer> colors = new ArrayList<Integer>(4);
    private final List<Drawable> drawables = new ArrayList<Drawable>(this.colors.size());
    private final List<ValueAnimator> animators = new ArrayList<ValueAnimator>(this.colors.size());
    private Interpolator interpolator;
    private boolean animating;
    private boolean hasRepeated;
    private int duration;

    public SymmetricProgressBar(Context context) {
        this(context, null);
    }

    public SymmetricProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        int interpolatorResId;
        int[] colors;
        TypedArray array2;
        if (attrs == null) {
            array2 = null;
            colors = context.getResources().getIntArray(R.array.SymmetricProgressBar_colors);
        } else {
            array2 = context.obtainStyledAttributes(attrs, R.styleable.SymmetricProgressBar);
            colors = context.getResources().getIntArray(array2.getResourceId(R.styleable.SymmetricProgressBar_colors, R.array.SymmetricProgressBar_colors));
        }
        for (int color2 : colors) {
            this.colors.add(color2);
        }
        int n = interpolatorResId = array2 == null ? 17432582 : array2.getResourceId(R.styleable.SymmetricProgressBar_interpolator, 17432582);
        if (interpolatorResId > 0) {
            this.setInterpolator(context, interpolatorResId);
        }
        if (array2 != null) {
            this.setDuration(array2.getInteger(R.styleable.SymmetricProgressBar_duration, context.getResources().getInteger(R.integer.SymmetricProgressBar_duration)));
            array2.recycle();
        }
    }

    public List<Integer> getColors() {
        return Collections.unmodifiableList(this.colors);
    }

    public void setColors(Collection<Integer> colors) {
        this.colors.clear();
        this.colors.addAll(colors);
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public void setInterpolator(Context context, int resId) {
        this.setInterpolator(AnimationUtils.loadInterpolator((Context)context, (int)resId));
    }

    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public boolean isAnimating() {
        return this.animating;
    }

    public void setVisibility(int visibility) {
        if (this.getVisibility() != visibility) {
            super.setVisibility(visibility);
            if (visibility == 0) {
                this.startAnimation();
            } else {
                this.stopAnimation();
            }
        }
    }

    public void startAnimation() {
        if (!this.animating) {
            this.animating = true;
            this.hasRepeated = false;
            for (ValueAnimator animator : this.animators) {
                animator.removeAllListeners();
            }
            this.drawables.clear();
            this.animators.clear();
            Iterator<Object> iterator = this.colors.iterator();
            while (iterator.hasNext()) {
                int color2 = (Integer)iterator.next();
                ColorDrawable drawable2 = new ColorDrawable(color2);
                this.updateDrawables(this.getWidth(), this.getHeight());
                this.drawables.add((Drawable)drawable2);
                this.animators.add(ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.1f}));
            }
            for (int i = 0; i < this.animators.size(); ++i) {
                ValueAnimator animator = this.animators.get(i);
                animator.setRepeatMode(1);
                animator.setRepeatCount(-1);
                animator.setDuration((long)(this.duration / this.colors.size() * this.colors.size()));
                animator.setInterpolator((TimeInterpolator)this.interpolator);
                animator.setStartDelay((long)(i * this.duration / this.colors.size()));
                animator.addListener((Animator.AnimatorListener)this);
                animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
                animator.start();
            }
            if (this.getVisibility() == 0) {
                this.postInvalidate();
            }
        }
    }

    public void stopAnimation() {
        this.animating = false;
        this.hasRepeated = false;
        for (ValueAnimator animator : this.animators) {
            animator.end();
            animator.removeAllListeners();
        }
        this.postInvalidate();
    }

    public void onAnimationStart(Animator animation) {
    }

    public void onAnimationEnd(Animator animation) {
    }

    public void onAnimationCancel(Animator animation) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAnimationRepeat(Animator animation) {
        List<Drawable> list = this.drawables;
        synchronized (list) {
            List<ValueAnimator> list2 = this.animators;
            synchronized (list2) {
                int index = this.animators.indexOf(animation);
                this.drawables.add(this.drawables.remove(index));
                this.animators.add(this.animators.remove(index));
            }
        }
        this.hasRepeated = true;
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        this.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.animating) {
            List<Drawable> list = this.drawables;
            synchronized (list) {
                List<ValueAnimator> list2 = this.animators;
                synchronized (list2) {
                    if (this.hasRepeated) {
                        this.drawables.get(0).draw(canvas);
                    }
                    for (int i = 0; i < this.drawables.size(); ++i) {
                        Drawable drawable2 = this.drawables.get(i);
                        float fraction = ((Float)this.animators.get(i).getAnimatedValue()).floatValue();
                        canvas.save();
                        canvas.clipRect((float)this.getWidth() / 2.0f * (1.0f - fraction), 0.0f, (float)this.getWidth() / 2.0f * (1.0f + fraction), (float)this.getHeight());
                        drawable2.draw(canvas);
                        canvas.restore();
                    }
                }
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.startAnimation();
    }

    protected void onDetachedFromWindow() {
        this.stopAnimation();
        super.onDetachedFromWindow();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.updateDrawables(w, h);
    }

    private void updateDrawables(int w, int h) {
        for (Drawable drawable2 : this.drawables) {
            drawable2.setBounds(0, 0, w, h);
        }
    }
}

