/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.viewmodel;

import androidx.annotation.NonNull;
import com.ahmadullahpk.alldocumentreader.dataType.Cell;
import com.ahmadullahpk.alldocumentreader.dataType.ColumnHeader;
import com.ahmadullahpk.alldocumentreader.dataType.RowHeader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class TableViewModel {
    public static final int MOOD_COLUMN_INDEX = 3;
    public static final int GENDER_COLUMN_INDEX = 4;
    public static final int SAD = 1;
    public static final int HAPPY = 2;
    public static final int BOY = 1;
    public static final int GIRL = 2;
    private static final int COLUMN_SIZE = 500;
    private static final int ROW_SIZE = 500;

    @NonNull
    private List<RowHeader> getSimpleRowHeaderList() {
        ArrayList<RowHeader> list = new ArrayList<RowHeader>();
        for (int i = 0; i < 500; ++i) {
            RowHeader header = new RowHeader(String.valueOf(i), "row " + i);
            list.add(header);
        }
        return list;
    }

    @NonNull
    private List<ColumnHeader> getRandomColumnHeaderList() {
        ArrayList<ColumnHeader> list = new ArrayList<ColumnHeader>();
        for (int i = 0; i < 500; ++i) {
            String title = "column " + i;
            int nRandom = new Random().nextInt();
            if (nRandom % 4 == 0 || nRandom % 3 == 0 || nRandom == i) {
                title = "large column " + i;
            }
            ColumnHeader header = new ColumnHeader(String.valueOf(i), title);
            list.add(header);
        }
        return list;
    }

    @NonNull
    private List<List<Cell>> getCellListForSortingTest() {
        ArrayList<List<Cell>> list = new ArrayList<List<Cell>>();
        for (int i = 0; i < 500; ++i) {
            ArrayList<Cell> cellList = new ArrayList<Cell>();
            for (int j = 0; j < 500; ++j) {
                Object text = "cell " + j + " " + i;
                int random = new Random().nextInt();
                if (j == 0) {
                    text = i;
                } else if (j == 1) {
                    text = random;
                } else if (j == 3) {
                    text = random % 2 == 0 ? 2 : 1;
                } else if (j == 4) {
                    text = random % 2 == 0 ? 1 : 2;
                }
                String id2 = j + "-" + i;
                Cell cell = j == 3 ? new Cell(id2, text) : (j == 4 ? new Cell(id2, text) : new Cell(id2, text));
                cellList.add(cell);
            }
            list.add(cellList);
        }
        return list;
    }

    @NonNull
    public List<List<Cell>> getCellList() {
        return this.getCellListForSortingTest();
    }

    @NonNull
    public List<RowHeader> getRowHeaderList() {
        return this.getSimpleRowHeaderList();
    }

    @NonNull
    public List<ColumnHeader> getColumnHeaderList() {
        return this.getRandomColumnHeaderList();
    }
}

