/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.activity;

import android.content.Context;
import android.os.Bundle;
import android.print.PrintAttributes;
import android.print.PrintDocumentAdapter;
import android.print.PrintJob;
import android.print.PrintManager;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import androidx.appcompat.app.AppCompatDelegate;
import com.ahmadullahpk.alldocumentreader.R;
import com.ahmadullahpk.alldocumentreader.activity.BaseActivity;
import com.ahmadullahpk.alldocumentreader.databinding.ActivityPrintPdfBinding;
import com.ahmadullahpk.alldocumentreader.manageui.CustomFrameLayout;
import com.ahmadullahpk.alldocumentreader.manageui.RoundCornerFrameLay;
import com.ahmadullahpk.alldocumentreader.util.Singleton;
import com.ahmadullahpk.alldocumentreader.util.Utility;
import java.io.IOException;
import java.io.InputStream;

public class PrintPdfActivity
extends BaseActivity {
    ActivityPrintPdfBinding binding;
    private CustomFrameLayout.Builder toolbarBuilder;
    PrintDocumentAdapter printAdapter;
    PrintJob printJob;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            AppCompatDelegate.setDefaultNightMode((int)1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.binding = ActivityPrintPdfBinding.inflate(this.getLayoutInflater());
        RoundCornerFrameLay layout2 = this.binding.getRoot();
        this.setContentView((View)layout2);
        this.setStatusBar();
        this.adaptFitsSystemWindows(this.getWindow().getDecorView());
        this.configHeader();
        WebView webView = this.binding.webView;
        webView.setInitialScale(100);
        webView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView webView, int i) {
                if (i < 100) {
                    PrintPdfActivity.this.binding.progressBar.setVisibility(0);
                }
                if (i == 100) {
                    PrintPdfActivity.this.binding.progressBar.setVisibility(8);
                }
            }
        });
        if (this.getIntent() != null) {
            // empty if block
        }
        this.binding.btnSaveAsPDF.setOnClickListener(view -> this.createWebPrintJob(webView));
    }

    private void createWebPrintJob(WebView webView) {
        PrintManager printManager = (PrintManager)this.getSystemService("print");
        this.printAdapter = webView.createPrintDocumentAdapter("New PDF File.pdf");
        this.printJob = printManager.print(this.getString(R.string.app_name) + " Document", this.printAdapter, new PrintAttributes.Builder().setMediaSize(PrintAttributes.MediaSize.ISO_A4).setColorMode(2).setMinMargins(PrintAttributes.Margins.NO_MARGINS).build());
    }

    protected String getHtmlContent(String str) {
        String LoadData = this.LoadData("bootstrap/bootstrap.css");
        String LoadData2 = this.LoadData("dist/summernote.css");
        return "<html><head> <style>" + LoadData + LoadData2 + "</style></head><body>" + str + "</body></html>";
    }

    public void onResume() {
        super.onResume();
        if (this.printJob != null && this.printJob.isCompleted()) {
            Utility.Toast((Context)this, this.getResources().getString(R.string.pdfFileCreatedSuccessfully));
            Singleton.getInstance().setFileDeleted(true);
        }
    }

    public String LoadData(String str) {
        try {
            InputStream open = this.getAssets().open(str);
            byte[] bArr = new byte[open.available()];
            open.read(bArr);
            open.close();
            return new String(bArr);
        }
        catch (IOException unused) {
            return "";
        }
    }

    private void configHeader() {
        this.binding.header.headerTitleText.setTextAppearance((Context)this, R.style.PageTitleBold);
        this.binding.header.headerTitleText.setFont((Context)this, 1);
        this.binding.appToolbar.setToolbarTitle("Preview");
        this.binding.header.headerTitleText.setText("Preview");
        this.toolbarBuilder = new CustomFrameLayout.Builder(this.binding.appToolbar, (Context)this);
        this.toolbarBuilder.setBackArrow(R.drawable.back_arrow, this.getResources().getColor(R.color.blue_start), this.getResources().getColor(R.color.blue_end), view -> this.onBackPressed());
    }
}

