/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.activity;

import android.app.ProgressDialog;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.View;
import android.widget.RelativeLayout;
import androidx.appcompat.app.AppCompatDelegate;
import com.ahmadullahpk.alldocumentreader.R;
import com.ahmadullahpk.alldocumentreader.activity.BaseActivity;
import com.ahmadullahpk.alldocumentreader.adapters_All.TableEventListener;
import com.ahmadullahpk.alldocumentreader.adapters_All.TablePreviewwAdp;
import com.ahmadullahpk.alldocumentreader.dataType.Cell;
import com.ahmadullahpk.alldocumentreader.dataType.ColumnHeader;
import com.ahmadullahpk.alldocumentreader.dataType.RowHeader;
import com.ahmadullahpk.alldocumentreader.databinding.ActivityCsvViewerBinding;
import com.ahmadullahpk.alldocumentreader.manageui.CustomFrameLayout;
import com.ahmadullahpk.alldocumentreader.util.CSVReader;
import com.ahmadullahpk.alldocumentreader.util.Utility;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.TableView;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.filter.Filter;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.pagination.Pagination;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CSVViewer_Activity
extends BaseActivity {
    ActivityCsvViewerBinding binding;
    private CustomFrameLayout.Builder toolbarBuilder;
    List<List<Cell>> cellDataList = new ArrayList<List<Cell>>();
    List<ColumnHeader> columnHeaderList = new ArrayList<ColumnHeader>();
    ArrayList<List<String>> csv_data = new ArrayList();
    Boolean fromConverterApp = false;
    private Pagination mPagination;
    private final boolean mPaginationEnabled = false;
    private Filter mTableFilter;
    private TableView mTableView;
    List<RowHeader> rowHeaderList = new ArrayList<RowHeader>();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            AppCompatDelegate.setDefaultNightMode((int)1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.binding = ActivityCsvViewerBinding.inflate(this.getLayoutInflater());
        RelativeLayout view = this.binding.getRoot();
        this.setContentView((View)view);
        this.binding.headerTitleText.setTextAppearance((Context)this, R.style.PageTitleBold);
        this.binding.imgBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CSVViewer_Activity.this.onBackPressed();
            }
        });
        this.mTableView = (TableView)this.findViewById(R.id.tableview);
        if (this.getIntent() != null) {
            String stringExtra = this.getIntent().getStringExtra("path");
            String stringExtra2 = this.getIntent().getStringExtra("name");
            this.fromConverterApp = this.getIntent().getBooleanExtra("fromConverterApp", false);
            Integer.parseInt(this.getIntent().getStringExtra("fileType"));
            this.binding.headerTitleText.setMaxLines(1);
            this.binding.headerTitleText.setText((CharSequence)stringExtra2);
            new LoadCVSDataFromPath(stringExtra).execute(new Void[0]);
        }
        this.mTableFilter = new Filter(this.mTableView);
        Objects.requireNonNull(this);
    }

    public void loadCVSDate(String str) {
        try {
            List read = new CSVReader((Context)this).read(new FileInputStream(str));
            if (read.size() > 0) {
                for (int i = 0; i < read.size(); ++i) {
                    String[] strArr = (String[])read.get(i);
                    ArrayList<Cell> arrayList = new ArrayList<Cell>();
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    if (strArr.length > 1) {
                        String str2 = "";
                        for (int i2 = 0; i2 < strArr.length; ++i2) {
                            if (i == 0) {
                                this.columnHeaderList.add(new ColumnHeader(String.valueOf(i), strArr[i2]));
                            } else {
                                arrayList.add(new Cell(i2 + "-" + i, strArr[i2]));
                            }
                            arrayList2.add(strArr[i2] + "");
                            str2 = str2 + " -  " + strArr[i2];
                        }
                        this.rowHeaderList.add(new RowHeader(String.valueOf(i), String.valueOf(i)));
                    }
                    this.cellDataList.add(arrayList);
                    this.csv_data.add(arrayList2);
                }
                Utility.logCatMsg("size " + read.size());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void filterTable(String str) {
        this.mTableFilter.set(str);
    }

    public void filterTableForMood(String str) {
        this.mTableFilter.set(2, str);
    }

    public void filterTableForGender(String str) {
        this.mTableFilter.set(4, str);
    }

    public void nextTablePage() {
        this.mPagination.nextPage();
    }

    public void previousTablePage() {
        this.mPagination.previousPage();
    }

    public void goToTablePage(int i) {
        this.mPagination.goToPage(i);
    }

    public void setTableItemsPerPage(int i) {
        this.mPagination.setItemsPerPage(i);
    }

    class LoadCVSDataFromPath
    extends AsyncTask<Void, Void, Void> {
        String file_path;
        ProgressDialog progressDialog;

        public LoadCVSDataFromPath(String str) {
            this.file_path = str;
        }

        protected void onPreExecute() {
            ProgressDialog progressDialog2;
            this.progressDialog = progressDialog2 = new ProgressDialog((Context)CSVViewer_Activity.this);
            progressDialog2.setMessage((CharSequence)CSVViewer_Activity.this.getResources().getString(R.string.loadingFiles));
            this.progressDialog.setProgressStyle(1);
            this.progressDialog.setMax(100);
            this.progressDialog.setProgress(0);
            this.progressDialog.setCancelable(false);
            this.progressDialog.setButton(-1, (CharSequence)CSVViewer_Activity.this.getResources().getString(R.string.cancel), (dialogInterface, i) -> {
                dialogInterface.dismiss();
                this.cancel(true);
            });
            this.progressDialog.show();
            super.onPreExecute();
        }

        protected Void doInBackground(Void ... voidArr) {
            CSVViewer_Activity.this.loadCVSDate(this.file_path);
            return null;
        }

        protected void onPostExecute(Void voidR) {
            super.onPostExecute((Object)voidR);
            ProgressDialog progressDialog2 = this.progressDialog;
            if (progressDialog2 != null && progressDialog2.isShowing()) {
                this.progressDialog.dismiss();
            }
            TablePreviewwAdp tablePreviewwAdp = new TablePreviewwAdp();
            CSVViewer_Activity.this.mTableView.setAdapter(tablePreviewwAdp);
            CSVViewer_Activity.this.mTableView.setTableViewListener(new TableEventListener(CSVViewer_Activity.this.mTableView));
            tablePreviewwAdp.setAllItems(CSVViewer_Activity.this.columnHeaderList, CSVViewer_Activity.this.rowHeaderList, CSVViewer_Activity.this.cellDataList);
        }
    }
}

